/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BItemModuleHelper {
    private static final Logger logger = LoggerFactory.getLogger(BItemModuleHelper.class);
    @Autowired
    private IContext context;
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;

    public Long getByShopName(String name) {
        ShopDto shopDto;
        ShopQueryDto shopQueryDto = new ShopQueryDto();
        shopQueryDto.setInstanceId(this.context.instanceId());
        shopQueryDto.setTenantId(this.context.tenantId());
        shopQueryDto.setName(name);
        shopQueryDto.setStatus("NORMAL");
        PageInfo shopDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByConditions(shopQueryDto, 10, 1));
        if (shopDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)shopDtoPageInfo.getList()) && null != (shopDto = shopDtoPageInfo.getList().stream().findFirst().orElseGet(() -> null))) {
            return shopDto.getId();
        }
        return null;
    }

    public List<Long> getCustomerIdsByUserIdAndShopId(Long userId, List<Long> shopIds) {
        ServiceContext serviceContext;
        String object;
        Assert.notEmpty(shopIds, (String)"shopId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)userId, (String)"userId\u4e0d\u80fd\u4e3a\u7a7a");
        if (userId.equals(this.context.userId()) && (object = (serviceContext = ServiceContext.getContext()).getAttachment("yes.req.cus.b2b.customerid")) != null) {
            return Collections.singletonList(Long.valueOf(object));
        }
        Long orgInfoId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
        ArrayList<Long> customerIdList = new ArrayList<Long>();
        for (Long shopId : shopIds) {
            ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData();
            SellerRespDto sellerRespDto = (SellerRespDto)this.sellerQueryApi.queryById(shopDto.getSellerId()).getData();
            RestResponse customerRespDtoRest = this.customerExtQueryApi.queryCustomerByOrgAndMerch(orgInfoId, sellerRespDto.getOrganizationId());
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRespDtoRest);
            if (customerRespDto != null) {
                customerIdList.add(customerRespDto.getId());
                continue;
            }
            logger.info("userId={},\u4e0d\u662f\u5546\u5bb6shopId={}\u7684\u6240\u5c5e\u7684\u5ba2\u6237", (Object)userId, (Object)shopId);
        }
        return customerIdList;
    }
}

