/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceBeanReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceAddOrModifyRespDto;
import com.dtyunxi.yundt.module.bitem.api.IBItemPriceService;
import com.dtyunxi.yundt.module.bitem.api.dto.response.SellerSkuPriceDto;
import com.dtyunxi.yundt.module.bitem.biz.price.IItemPriceTypeService;
import com.dtyunxi.yundt.module.bitem.biz.price.constants.PriceTypeEnum;
import com.yx.tcbj.center.api.dto.request.SellerSkuPriceReqDto;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BItemPriceService
implements IBItemPriceService {
    private static Logger logger = LoggerFactory.getLogger(BItemPriceService.class);
    @Value(value="${itemPrice.usePriceCenterPrice:true}")
    private boolean usePriceCenterPrice;
    @Value(value="${itemPrice.useRules:DEFAULT}")
    private String itemPriceUseRules;
    @Resource
    private List<IItemPriceTypeService> itemPriceTypeServiceList;
    private static Map<PriceTypeEnum, IItemPriceTypeService> itemPriceTypeMap;

    public IItemPriceTypeService getPriceService() {
        PriceTypeEnum priceTypeEnum;
        if (Objects.isNull(itemPriceTypeMap)) {
            itemPriceTypeMap = this.itemPriceTypeServiceList.stream().collect(Collectors.toMap(IItemPriceTypeService::priceType, Function.identity()));
        }
        if (itemPriceTypeMap.containsKey((Object)(priceTypeEnum = PriceTypeEnum.toPriceTypeEnum(this.itemPriceUseRules)))) {
            return itemPriceTypeMap.get((Object)priceTypeEnum);
        }
        logger.error("[\u4ef7\u683c\u67e5\u8be2] >>> \u6a21\u5f0f[{}]\u6ca1\u6709\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b", (Object)this.itemPriceUseRules);
        throw new BizException("10000", "\u6a21\u5f0f" + this.itemPriceUseRules + "\u6ca1\u6709\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b");
    }

    public RestResponse<List<ItemPolicyPriceRespDto>> getItemPrice(CommunalPriceQueryReqDto communalPriceQueryReqDto) {
        return this.getPriceService().getItemPrice(communalPriceQueryReqDto);
    }

    public RestResponse<PriceAddOrModifyRespDto> queryPriceLimit(PriceBeanReqDto priceBeanReqDto) {
        return this.getPriceService().queryPriceLimit(priceBeanReqDto);
    }

    public Map<String, SellerSkuPriceDto> getSellerSkuPrice(SellerSkuPriceReqDto sellerSkuPriceReqDto) {
        return this.getPriceService().getSellerSkuPrice(sellerSkuPriceReqDto);
    }
}

