/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ItemAuthEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemAuthLimitDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuExtRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceConditionQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuRetailPriceReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuPriceQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuRetailPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IBasePriceItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.bitem.api.IBItemPriceService;
import com.dtyunxi.yundt.module.bitem.api.IBitemLibService;
import com.dtyunxi.yundt.module.bitem.api.constants.AuthTypeEnum;
import com.dtyunxi.yundt.module.bitem.api.constants.CustomerBuyScopeTypeEnum;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemListQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemListInfo;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemListRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.SellerSkuPriceDto;
import com.dtyunxi.yundt.module.bitem.biz.price.ItemPriceHelper;
import com.dtyunxi.yundt.module.bitem.biz.price.impl.TcbjPriceImpl;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.api.dto.request.SellerSkuPriceReqDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BitemLibServiceImpl
implements IBitemLibService {
    private static final Logger logger = LoggerFactory.getLogger(BitemLibServiceImpl.class);
    @Value(value="${itemPrice.useRules:DEFAULT}")
    private String itemPriceUseRules;
    @Resource
    private IContext context;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private TcbjPriceImpl tcbjPriceImpl;
    @Resource
    private IBItemPriceService ibItemPriceService;
    @Resource
    private ItemPriceHelper itemPriceHelper;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IBasePriceItemQueryApi basePriceItemQueryApi;

    public ItemListInfo queryDealerItemlib(ItemListQueryReqDto itemListQueryReqDto, Integer pageNum, Integer pageSize) {
        if (itemListQueryReqDto.getInstanceId() == null) {
            itemListQueryReqDto.setInstanceId(this.context.instanceId());
        }
        if (itemListQueryReqDto.getTenantId() == null) {
            itemListQueryReqDto.setTenantId(this.context.tenantId());
        }
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u6570\u636e\u53c2\u6570={}", JSON.toJSON((Object)itemListQueryReqDto));
        PageInfo<ItemListRespDto> pageInfo = this.queryItem(itemListQueryReqDto, pageNum, pageSize);
        ItemListInfo itemListInfo = new ItemListInfo();
        itemListInfo.setPageInfo(pageInfo);
        return itemListInfo;
    }

    private void filterLimit(ItemReqDto itemReqDto) {
        List limitList = itemReqDto.getLimitList();
        if (CollUtil.isEmpty((Collection)limitList)) {
            return;
        }
        List limitDtos = limitList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getBusinessType()) && Objects.nonNull(item.getTargetType()) && CollUtil.isNotEmpty((Collection)item.getTargetIdList())).collect(Collectors.groupingBy(item -> item.getBusinessType() + "-" + item.getTargetType())).values().stream().map(items -> {
            HashSet targetIdList = new HashSet();
            items.forEach(item -> targetIdList.addAll(item.getTargetIdList()));
            ItemAuthLimitDto itemAuthLimitDto = new ItemAuthLimitDto();
            itemAuthLimitDto.setTargetIdList(new ArrayList(targetIdList));
            itemAuthLimitDto.setTargetType(((ItemAuthLimitDto)items.get(0)).getTargetType());
            itemAuthLimitDto.setBusinessType(((ItemAuthLimitDto)items.get(0)).getBusinessType());
            return itemAuthLimitDto;
        }).collect(Collectors.toList());
        itemReqDto.setLimitList(limitDtos);
    }

    public PageInfo<ItemSkuExtRespDto> queryItemLibSkuByPage(ItemListQueryReqDto itemListQueryReqDto, Integer pageNum, Integer pageSize) {
        if (itemListQueryReqDto.getInstanceId() == null) {
            itemListQueryReqDto.setInstanceId(this.context.instanceId());
        }
        if (itemListQueryReqDto.getTenantId() == null) {
            itemListQueryReqDto.setTenantId(this.context.tenantId());
        }
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u6570\u636e\u53c2\u6570={}", JSON.toJSON((Object)itemListQueryReqDto));
        ItemReqDto itemReqDto = new ItemReqDto();
        BeanUtils.copyProperties((Object)itemListQueryReqDto, (Object)itemReqDto);
        itemReqDto.setId(null);
        itemReqDto.setCode(itemListQueryReqDto.getItemCode());
        itemReqDto.setName(itemListQueryReqDto.getItemName());
        itemReqDto.setDirId(itemListQueryReqDto.getBackDirId());
        itemReqDto.setType(itemListQueryReqDto.getType());
        this.filterLimit(itemReqDto);
        if (itemListQueryReqDto.getBundle() != null) {
            if (itemListQueryReqDto.getBundle() == 1) {
                itemReqDto.setType(ItemTypeEnum.BUNDLE.getType());
            } else if (itemReqDto.getType() == null) {
                itemReqDto.setTypeList((List)Lists.newArrayList((Object[])new Integer[]{ItemTypeEnum.GENERAL.getType(), ItemTypeEnum.VIRTUAL.getType(), ItemTypeEnum.PRODUCT.getType()}));
            } else {
                itemReqDto.setTypeList((List)Lists.newArrayList((Object[])new Integer[]{itemReqDto.getType()}));
            }
        }
        Long currentUserOrgId = this.getCurrentUserOrgId(this.context.userId());
        ArrayList brandOrgIds = CustomerTypeEnum.DEALER.getCode().equals(itemListQueryReqDto.getChannel()) ? this.queryBrandOrgIds(currentUserOrgId) : Lists.newArrayList((Object[])new Long[]{currentUserOrgId});
        itemReqDto.setOrganizationIdList(brandOrgIds);
        if (AuthTypeEnum.RETAILER.getCode().equals(itemListQueryReqDto.getAuthType())) {
            Assert.notNull((Object)itemListQueryReqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            HashSet brandIds = Sets.newHashSet();
            HashSet dirIds = Sets.newHashSet();
            HashSet disableSkuids = Sets.newHashSet();
            HashSet skuIds = Sets.newHashSet();
            ItemAuthQueryReqDto itemAuthQueryReqDto = new ItemAuthQueryReqDto();
            itemAuthQueryReqDto.setChannel(Integer.valueOf(1));
            itemAuthQueryReqDto.setTargetType(Integer.valueOf(2));
            itemAuthQueryReqDto.setOrganizationIdList((List)Lists.newArrayList((Object[])new Long[]{itemListQueryReqDto.getMerchantId()}));
            itemAuthQueryReqDto.setPageNum(Integer.valueOf(1));
            itemAuthQueryReqDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
            RestResponse pageInfoRestResp = this.itemAuthQueryApi.queryItemAuthPage(itemAuthQueryReqDto);
            PageInfo itemAuthPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
            if (Objects.isNull(itemAuthPageInfo) || CollectionUtils.isEmpty((Collection)itemAuthPageInfo.getList())) {
                return new PageInfo();
            }
            for (ItemAuthQueryRespDto itemAuthQueryRespDto : itemAuthPageInfo.getList()) {
                CustomerBuyScopeTypeEnum type = CustomerBuyScopeTypeEnum.toCustomerBuyScopeTypeEnum((String)itemAuthQueryRespDto.getBusinessType());
                if (type == null) continue;
                switch (type) {
                    case SKU: {
                        skuIds.add(itemAuthQueryRespDto.getBusinessId());
                        break;
                    }
                    case BRAND: {
                        brandIds.add(itemAuthQueryRespDto.getBusinessId());
                        break;
                    }
                    case CATEGORY: {
                        dirIds.add(itemAuthQueryRespDto.getBusinessId());
                        break;
                    }
                    case BANSKU: {
                        disableSkuids.add(itemAuthQueryRespDto.getBusinessId());
                        break;
                    }
                }
            }
            itemReqDto.setDirIdList((List)Lists.newArrayList((Iterable)dirIds));
            itemReqDto.setBrandIdList((List)Lists.newArrayList((Iterable)brandIds));
            itemReqDto.setSkuIdList((List)Lists.newArrayList((Iterable)skuIds));
            itemReqDto.setOutSkuIdList((List)Lists.newArrayList((Iterable)disableSkuids));
        }
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u5e93sku\u5217\u8868: {}", (Object)JSON.toJSONString((Object)itemReqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemLibSkuByPage(itemReqDto, pageNum, pageSize));
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u5e93sku\u5217\u8868: {}", (Object)JSON.toJSONString((Object)itemReqDto));
        List list = pageInfo.getList();
        this.setSkuPrice(list);
        return pageInfo;
    }

    private void setSkuPrice(List<ItemSkuExtRespDto> list) {
        ItemSkuPriceQueryReqDto itemSkuPriceQueryReqDto = new ItemSkuPriceQueryReqDto();
        ArrayList shopConditionList = Lists.newArrayList();
        shopConditionList.addAll(list.stream().map(t -> {
            ItemSkuPriceConditionQueryReqDto itemSkuPriceConditionQueryReqDto = new ItemSkuPriceConditionQueryReqDto();
            itemSkuPriceConditionQueryReqDto.setSkuId(t.getSkuId());
            itemSkuPriceConditionQueryReqDto.setShopId(t.getShopId());
            return itemSkuPriceConditionQueryReqDto;
        }).collect(Collectors.toList()));
        itemSkuPriceQueryReqDto.setShopConditionList((List)shopConditionList);
        logger.info("\u67e5\u8be2\u4ef7\u683c\u7684\u53c2\u6570:{}", (Object)JacksonUtil.toJson((Object)itemSkuPriceQueryReqDto));
        RestResponse restResponse = this.basePriceItemQueryApi.queryRetailSkuPrice(itemSkuPriceQueryReqDto);
        logger.info("\u67e5\u8be2\u4ef7\u683c\u8fd4\u56de\u7684\u6570\u636e:{}", (Object)JacksonUtil.toJson((Object)restResponse));
        if (!"0".equals(restResponse.getResultCode())) {
            logger.info("\u67e5\u8be2\u4ef7\u683c\u6709\u8bef:{}", (Object)JacksonUtil.toJson((Object)restResponse));
            return;
        }
        List itemSkuPriceQueryRespDtoList = (List)restResponse.getData();
        if (CollectionUtils.isEmpty((Collection)itemSkuPriceQueryRespDtoList)) {
            logger.info("\u67e5\u8be2\u4ef7\u683c\u8fd4\u56de\u4e3a\u7a7a:{}", (Object)JacksonUtil.toJson((Object)itemSkuPriceQueryRespDtoList));
            return;
        }
        Map itemSkuPriceQueryReqDtoMap = itemSkuPriceQueryRespDtoList.stream().collect(Collectors.toMap(item -> item.getShopId() + "-" + item.getSkuId(), Function.identity(), (o1, o2) -> o2));
        list.forEach(itemRespDto -> {
            ItemSkuPriceQueryRespDto priceDealerRetail = (ItemSkuPriceQueryRespDto)itemSkuPriceQueryReqDtoMap.get(itemRespDto.getShopId() + "-" + itemRespDto.getSkuId());
            ItemSkuPriceQueryRespDto retailPriceRespDto = (ItemSkuPriceQueryRespDto)itemSkuPriceQueryReqDtoMap.get(itemRespDto.getShopId() + "-" + itemRespDto.getSkuId());
            if (Objects.nonNull(priceDealerRetail) && Objects.nonNull(priceDealerRetail.getDealerRetailPrice())) {
                itemRespDto.setPrice(priceDealerRetail.getDealerRetailPrice());
            }
            if (Objects.nonNull(retailPriceRespDto) && Objects.nonNull(retailPriceRespDto.getDealerRetailPrice())) {
                itemRespDto.setSalePrice(retailPriceRespDto.getCostRetailPrice());
            }
        });
    }

    public PageInfo<ItemSkuExtRespDto> queryDealerSkuByPage(ItemListQueryReqDto itemListQueryReqDto, Integer pageNum, Integer pageSize) {
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u6570\u636e\u53c2\u6570={}", JSON.toJSON((Object)itemListQueryReqDto));
        Long sellerId = itemListQueryReqDto.getSellerId();
        Assert.notNull((Object)sellerId, (String)"\u6240\u5c5e\u5546\u5bb6id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SellerRespDto sellerRespDto = (SellerRespDto)this.sellerQueryApi.queryById(sellerId).getData();
        Long sellerOrgId = sellerRespDto.getOrganizationId();
        Long customerId = null;
        ServiceContext serviceContext = ServiceContext.getContext();
        String CUSTOMERID_HEAD = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
        customerId = StringUtils.isNotEmpty((CharSequence)CUSTOMERID_HEAD) ? Long.valueOf(CUSTOMERID_HEAD) : this.getCustomerIdByUserIdAndSellerOrgId(this.context.userId(), sellerOrgId);
        Assert.notNull((Object)customerId, (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashSet brandIds = Sets.newHashSet();
        HashSet dirIds = Sets.newHashSet();
        HashSet disableSkuids = Sets.newHashSet();
        HashSet skuIds = Sets.newHashSet();
        ItemAuthQueryReqDto itemAuthQueryReqDto = new ItemAuthQueryReqDto();
        itemAuthQueryReqDto.setChannel(Integer.valueOf(1));
        itemAuthQueryReqDto.setOrganizationIdList((List)Lists.newArrayList((Object[])new Long[]{sellerOrgId}));
        itemAuthQueryReqDto.setTargetType(Integer.valueOf(2));
        itemAuthQueryReqDto.setPageNum(Integer.valueOf(1));
        itemAuthQueryReqDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        RestResponse pageInfoRestResp = this.itemAuthQueryApi.queryItemAuthPage(itemAuthQueryReqDto);
        PageInfo itemAuthPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
        if (Objects.isNull(itemAuthPageInfo) || CollectionUtils.isEmpty((Collection)itemAuthPageInfo.getList())) {
            return new PageInfo();
        }
        for (ItemAuthQueryRespDto itemAuthQueryRespDto : itemAuthPageInfo.getList()) {
            CustomerBuyScopeTypeEnum type = CustomerBuyScopeTypeEnum.toCustomerBuyScopeTypeEnum((String)itemAuthQueryRespDto.getBusinessType());
            if (type == null) continue;
            switch (type) {
                case SKU: {
                    skuIds.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
                case BRAND: {
                    brandIds.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
                case CATEGORY: {
                    dirIds.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
                case BANSKU: {
                    disableSkuids.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
            }
        }
        ItemReqDto itemReqDto = new ItemReqDto();
        BeanUtils.copyProperties((Object)itemListQueryReqDto, (Object)itemReqDto);
        itemReqDto.setId(null);
        String keyword = itemListQueryReqDto.getKeyword();
        if (StrUtil.isNotBlank((CharSequence)keyword)) {
            itemReqDto.setKeyword(keyword);
        } else {
            itemReqDto.setCode(itemListQueryReqDto.getItemCode());
            itemReqDto.setName(itemListQueryReqDto.getItemName());
        }
        itemReqDto.setDirId(itemListQueryReqDto.getBackDirId());
        itemReqDto.setType(itemListQueryReqDto.getType());
        itemReqDto.setBrandId(itemListQueryReqDto.getBrandId());
        itemReqDto.setBrandIdList(itemListQueryReqDto.getBrandIdList());
        ArrayList<Integer> subTypeListReq = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty((Collection)itemReqDto.getSubTypeList())) {
            subTypeListReq.addAll(itemReqDto.getSubTypeList());
        }
        if (!Objects.isNull(itemReqDto.getSubType())) {
            subTypeListReq.add(itemReqDto.getSubType());
        }
        itemReqDto.setSubTypeList(subTypeListReq);
        if (itemListQueryReqDto.getBundle() != null) {
            if (itemListQueryReqDto.getBundle() == 1) {
                itemReqDto.setType(ItemTypeEnum.BUNDLE.getType());
            } else if (itemReqDto.getType() == null) {
                itemReqDto.setTypeList((List)Lists.newArrayList((Object[])new Integer[]{ItemTypeEnum.GENERAL.getType(), ItemTypeEnum.VIRTUAL.getType(), ItemTypeEnum.PRODUCT.getType()}));
            } else {
                itemReqDto.setTypeList((List)Lists.newArrayList((Object[])new Integer[]{itemReqDto.getType()}));
            }
        }
        itemReqDto.setDirIdList((List)Lists.newArrayList((Iterable)dirIds));
        itemReqDto.setBrandIdList((List)Lists.newArrayList((Iterable)brandIds));
        itemReqDto.setSkuIdList((List)Lists.newArrayList((Iterable)skuIds));
        itemReqDto.setOutSkuIdList((List)Lists.newArrayList((Iterable)disableSkuids));
        List<Long> brandOrgIds = this.queryBrandOrgIds(sellerOrgId);
        itemReqDto.setOrganizationIdList(brandOrgIds);
        itemReqDto.setSellerId(null);
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u5e93sku\u5217\u8868: {}", (Object)JSON.toJSONString((Object)itemReqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemLibSkuByPage(itemReqDto, pageNum, pageSize));
        Long shopId = itemListQueryReqDto.getShopId();
        this.replaceCustSkuPrice(pageInfo.getList(), customerId, shopId);
        return pageInfo;
    }

    public PageInfo<ItemSkuQueryRespDto> querySkuByPage(ItemSkuQueryReqDto itemSkuQueryReqDto, Integer pageNum, Integer pageSize) {
        Long userOrgInfoId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        Integer channel = itemSkuQueryReqDto.getChannel();
        if (Objects.equals(channel, CustomerTypeEnum.DEALER.getCode())) {
            ShopToBQueryReqDto shopToBQueryReqDto = new ShopToBQueryReqDto();
            shopToBQueryReqDto.setOrganizationIdList((List)ListUtil.toList((Object[])new Long[]{userOrgInfoId}));
            shopToBQueryReqDto.setPageNum(1);
            shopToBQueryReqDto.setPageSize(10000);
            shopToBQueryReqDto.setStatus("NORMAL");
            shopToBQueryReqDto.setSellerStatus("NORMAL");
            PageInfo shopToBListRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryPage(shopToBQueryReqDto));
            if (CollUtil.isEmpty((Collection)shopToBListRespDtoPageInfo.getList())) {
                return new PageInfo(ListUtil.empty());
            }
            List shopIdList = shopToBListRespDtoPageInfo.getList().stream().map(ShopToBListRespDto::getId).distinct().collect(Collectors.toList());
            ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
            itemAuthReqDto.setTargetType(ItemAuthEnum.TargetType.SHOP.getCode());
            itemAuthReqDto.setTargetIdList(shopIdList);
            itemAuthReqDto.setStatus(ItemAuthEnum.Status.ENABLE.getCode());
            List itemAuthRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemAuthQueryApi.list(itemAuthReqDto));
            if (CollUtil.isEmpty((Collection)itemAuthRespDtos)) {
                return new PageInfo(ListUtil.empty());
            }
            itemSkuQueryReqDto.setInSkuIdList(itemAuthRespDtos.stream().map(ItemAuthRespDto::getBusinessId).distinct().collect(Collectors.toList()));
        } else {
            itemSkuQueryReqDto.setItemOrgId(userOrgInfoId);
        }
        RestResponse pageInfo = this.itemSkuQueryApi.querySkuPage(itemSkuQueryReqDto, pageNum, pageSize);
        return (PageInfo)pageInfo.getData();
    }

    private void replaceCustSkuPrice(List<ItemSkuExtRespDto> list, Long customerId, Long shopId) {
        block2: {
            block3: {
                SellerSkuPriceReqDto sellerSkuPriceReqDto = new SellerSkuPriceReqDto();
                if (!CollectionUtils.isNotEmpty(list)) break block2;
                Set skuIdList = list.stream().map(e -> e.getSkuId() != null ? e.getSkuId() : e.getId()).collect(Collectors.toSet());
                sellerSkuPriceReqDto.setSkuIdList(new ArrayList(skuIdList));
                sellerSkuPriceReqDto.setCustomerId(customerId);
                if (!"TCBJ".equalsIgnoreCase(this.itemPriceUseRules)) break block3;
                Map<String, SellerSkuPriceDto> skuPriceDtoMap = this.tcbjPriceImpl.getSellerSkuPrice(sellerSkuPriceReqDto);
                for (ItemSkuExtRespDto itemSkuExtRespDto : list) {
                    Long skuId = itemSkuExtRespDto.getSkuId() != null ? itemSkuExtRespDto.getSkuId() : itemSkuExtRespDto.getId();
                    String tmpKey = customerId + "-" + skuId;
                    SellerSkuPriceDto skuPriceDto = skuPriceDtoMap.get(tmpKey);
                    itemSkuExtRespDto.setItemPrice(skuPriceDto != null ? skuPriceDto.getMaxSkuPrice() : BigDecimal.ZERO);
                }
                break block2;
            }
            if (!"PRICE_CENTER".equalsIgnoreCase(this.itemPriceUseRules)) break block2;
            CommunalPriceQueryReqDto reqDto = new CommunalPriceQueryReqDto();
            reqDto.setCustomerIds(Arrays.asList(customerId));
            reqDto.setPolicyDate(new Date());
            ArrayList skuPriceReqDtoList = new ArrayList();
            list.forEach(itemSkuInfo -> {
                CommunalPriceQueryReqDto.ItemSkuPriceReqDto skuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
                skuPriceReqDto.setSkuId(itemSkuInfo.getId());
                skuPriceReqDto.setItemId(itemSkuInfo.getItemId());
                skuPriceReqDto.setShopId(shopId);
                skuPriceReqDtoList.add(skuPriceReqDto);
            });
            reqDto.setSkuList(skuPriceReqDtoList);
            List itemPolicyPriceRespDtos = (List)this.ibItemPriceService.getItemPrice(reqDto).getData();
            Map priceMap = itemPolicyPriceRespDtos.stream().collect(Collectors.toMap(skuInfo -> {
                String key = skuInfo.getShopId() + "-" + skuInfo.getSkuId();
                return key;
            }, Function.identity(), (o1, o2) -> o2));
            for (ItemSkuExtRespDto itemSkuExtRespDto : list) {
                Long skuId;
                Long l = skuId = itemSkuExtRespDto.getSkuId() != null ? itemSkuExtRespDto.getSkuId() : itemSkuExtRespDto.getId();
                String tmpKey = shopId + "-" + skuId;
                ItemPolicyPriceRespDto itemPolicyPriceRespDto = (ItemPolicyPriceRespDto)priceMap.get(tmpKey);
                if (itemPolicyPriceRespDto == null) continue;
                BigDecimal price = this.itemPriceHelper.getDefaultMatchPrice(itemPolicyPriceRespDto, null);
                itemSkuExtRespDto.setItemPrice(price);
            }
        }
    }

    private Long getCustomerIdByUserIdAndSellerOrgId(Long userId, Long sellerOrgId) {
        Long merchantId = sellerOrgId;
        Long userOrgInfoId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        ArrayList<Long> orgInfoIdList = new ArrayList<Long>();
        orgInfoIdList.add(userOrgInfoId);
        searchReqDto.setOrgInfoIds(orgInfoIdList);
        searchReqDto.setTenantId(this.context.tenantId());
        searchReqDto.setMerchantId(merchantId);
        RestResponse listRestResp = this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
        if (!CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            return ((CustomerRespDto)customerRespDtos.get(0)).getId();
        }
        return null;
    }

    private PageInfo<ItemListRespDto> queryItem(ItemListQueryReqDto itemListQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo result = new PageInfo();
        HashSet brandIds = Sets.newHashSet();
        HashSet dirIds = Sets.newHashSet();
        HashSet disableSkuids = Sets.newHashSet();
        ArrayList shopIds = new ArrayList();
        HashSet skuIds = Sets.newHashSet();
        ItemAuthQueryReqDto itemAuthQueryReqDto = new ItemAuthQueryReqDto();
        itemAuthQueryReqDto.setChannel(Integer.valueOf(2));
        itemAuthQueryReqDto.setTargetType(Integer.valueOf(2));
        itemAuthQueryReqDto.setPageNum(Integer.valueOf(1));
        itemAuthQueryReqDto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        itemAuthQueryReqDto.setKeyword(itemListQueryReqDto.getKeyword());
        RestResponse pageInfoRestResp = this.itemAuthQueryApi.queryItemAuthPage(itemAuthQueryReqDto);
        PageInfo itemAuthPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
        if (Objects.isNull(itemAuthPageInfo) || CollectionUtils.isEmpty((Collection)itemAuthPageInfo.getList())) {
            return result;
        }
        for (ItemAuthQueryRespDto itemAuthQueryRespDto : itemAuthPageInfo.getList()) {
            CustomerBuyScopeTypeEnum type = CustomerBuyScopeTypeEnum.toCustomerBuyScopeTypeEnum((String)itemAuthQueryRespDto.getBusinessType());
            if (type == null) continue;
            switch (type) {
                case SKU: {
                    skuIds.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
                case BRAND: {
                    brandIds.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
                case CATEGORY: {
                    dirIds.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
                case BANSKU: {
                    disableSkuids.add(itemAuthQueryRespDto.getBusinessId());
                    break;
                }
            }
        }
        Long currentUserOrgId = this.getCurrentUserOrgId(this.context.userId());
        ItemReqDto itemReqDto = new ItemReqDto();
        BeanUtils.copyProperties((Object)itemListQueryReqDto, (Object)itemReqDto);
        itemReqDto.setId(null);
        itemReqDto.setCode(itemListQueryReqDto.getItemCode());
        itemReqDto.setName(itemListQueryReqDto.getItemName());
        itemReqDto.setDirId(itemListQueryReqDto.getBackDirId());
        itemReqDto.setType(itemListQueryReqDto.getType());
        if (itemListQueryReqDto.getBundle() != null) {
            if (itemListQueryReqDto.getBundle() == 1) {
                itemReqDto.setType(ItemTypeEnum.BUNDLE.getType());
            } else if (itemReqDto.getType() == null) {
                itemReqDto.setTypeList((List)Lists.newArrayList((Object[])new Integer[]{ItemTypeEnum.GENERAL.getType(), ItemTypeEnum.VIRTUAL.getType(), ItemTypeEnum.PRODUCT.getType()}));
            } else {
                itemReqDto.setTypeList((List)Lists.newArrayList((Object[])new Integer[]{itemReqDto.getType()}));
            }
        }
        List<Long> brandOrgIds = this.queryBrandOrgIds(currentUserOrgId);
        if (CollectionUtils.isNotEmpty((Collection)brandIds)) {
            brandOrgIds = brandOrgIds.stream().distinct().collect(Collectors.toList());
        }
        itemReqDto.setDirIdList((List)Lists.newArrayList((Iterable)dirIds));
        itemReqDto.setBrandIdList((List)Lists.newArrayList((Iterable)brandIds));
        itemReqDto.setSkuIdList((List)Lists.newArrayList((Iterable)skuIds));
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u5e93\u5217\u8868: {}", (Object)JSON.toJSONString((Object)itemReqDto));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.searchItemLibByPage(itemReqDto, pageNum, pageSize));
        List itemRespDtos = pageInfo.getList();
        if (null == pageInfo || CollectionUtils.isEmpty((Collection)itemRespDtos)) {
            return result;
        }
        HashMap selleNameMap = new HashMap(64);
        List<ItemListRespDto> list = itemRespDtos.stream().map(t -> this.convertToItemListRespDto((ItemRespDto)t, selleNameMap, Lists.newArrayList((Iterable)disableSkuids))).collect(Collectors.toList());
        this.fillItemResDirName(list);
        BeanUtils.copyProperties((Object)pageInfo, (Object)result);
        this.setRetailPrice(list);
        result.setList(list);
        return result;
    }

    private void setRetailPrice(List<ItemListRespDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (ItemListRespDto itemListRespDto : list) {
            ItemSkuRetailPriceReqDto dto = new ItemSkuRetailPriceReqDto();
            dto.setShopId(itemListRespDto.getShopId());
            dto.setItemCode(itemListRespDto.getItemCode());
            dto.setPageSize(Integer.valueOf(1));
            dto.setPageNum(Integer.valueOf(1));
            dto.setChannel(CustomerTypeEnum.DEALER.getCode());
            logger.info("\u8bf7\u6c42\u4ef7\u683c\u67e5\u8be2\u53c2\u6570:{}", (Object)JacksonUtil.toJson((Object)dto));
            RestResponse pageInfoRestResponse = this.basePriceItemQueryApi.querySkuRetailPriceByPage(dto);
            logger.info("\u8bf7\u6c42\u4ef7\u683c\u8fd4\u56de\u7684\u7ed3\u679c:{}", (Object)JacksonUtil.toJson((Object)pageInfoRestResponse));
            if (!ObjectUtils.isNotEmpty((Object)pageInfoRestResponse) || !ObjectUtils.isNotEmpty((Object)pageInfoRestResponse.getData()) || !CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList()) || !ObjectUtils.isNotEmpty(((PageInfo)pageInfoRestResponse.getData()).getList().get(0)) || !ObjectUtils.isNotEmpty((Object)((ItemSkuRetailPriceRespDto)((PageInfo)pageInfoRestResponse.getData()).getList().get(0)).getItemSkuPriceInfo())) continue;
            itemListRespDto.setRetailPrice(((ItemSkuRetailPriceRespDto)((PageInfo)pageInfoRestResponse.getData()).getList().get(0)).getItemSkuPriceInfo().getRetailPrice());
        }
    }

    private void fillItemResDirName(List<ItemListRespDto> list) {
        List dirIdList = list.stream().map(e -> e.getDirId()).collect(Collectors.toList());
        List res = (List)RestResponseHelper.extractData((RestResponse)this.directoryQueryApi.queryDirByIds(StringUtils.join(dirIdList, (String)",")));
        Map<Long, DirectoryItemRespDto> dirItemMap = res.stream().collect(Collectors.toMap(DirectoryItemRespDto::getId, p -> p, (o, n) -> o));
        list.forEach(e -> {
            DirectoryItemRespDto dirItemDto = (DirectoryItemRespDto)dirItemMap.get(e.getDirId());
            if (dirItemDto != null) {
                e.setDirName(dirItemDto.getName());
            }
        });
    }

    private Long getCurrentUserOrgId(Long userId) {
        return (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
    }

    private List<Long> queryBrandSellerId(Long currentUserOrgId) {
        ArrayList<Long> res = new ArrayList<Long>();
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setOrgInfoIds(Arrays.asList(currentUserOrgId));
        searchReqDto.setInstanceId(this.context.instanceId());
        searchReqDto.setType(Integer.valueOf(2));
        searchReqDto.setTenantId(this.context.tenantId());
        List customerListResp = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto)));
        customerListResp.forEach(e -> {
            SellerRespDto sellerRespDto;
            Long merchantId = e.getMerchantId();
            if (merchantId != null && (sellerRespDto = (SellerRespDto)this.sellerExtQueryApi.querySellerByOrganizationId(merchantId).getData()) != null) {
                res.add(sellerRespDto.getId());
            }
        });
        return res;
    }

    private List<Long> queryBrandOrgIds(Long currentUserOrgId) {
        return (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryUpperOrgIdsByOrgId(currentUserOrgId));
    }

    private ItemListRespDto convertToItemListRespDto(ItemRespDto itemRespDto, Map<Long, String> sellerNameMap, List<Long> disableSkuids) {
        if (null == sellerNameMap) {
            sellerNameMap = new HashMap<Long, String>(64);
        }
        List mediaList = itemRespDto.getItemMediasList();
        List skuList = itemRespDto.getItemSkuList();
        if (CollectionUtils.isNotEmpty(disableSkuids)) {
            skuList = skuList.stream().filter(e -> disableSkuids.contains(e.getId())).collect(Collectors.toList());
        }
        String imgPath = null;
        if (CollectionUtils.isNotEmpty((Collection)mediaList)) {
            List imgPathList = mediaList.stream().map(ItemMediasRespDto::getPath1).collect(Collectors.toList());
            imgPath = (String)imgPathList.get(0);
        }
        Long itemTotalStorage = 0L;
        ItemListRespDto itemListRespDto = new ItemListRespDto();
        BeanUtils.copyProperties((Object)itemRespDto, (Object)itemListRespDto);
        itemListRespDto.setItemId(itemRespDto.getId());
        itemListRespDto.setIsAfterSale(itemRespDto.getIsAfterSale());
        itemListRespDto.setItemCode(itemRespDto.getCode());
        itemListRespDto.setItemName(itemRespDto.getName());
        itemListRespDto.setItemTotalStorage(itemTotalStorage);
        itemListRespDto.setImgPath(imgPath);
        itemListRespDto.setSkus(skuList);
        itemListRespDto.setType(itemRespDto.getType());
        Long sellerId = itemRespDto.getSellerId();
        String sellerName = this.getSellerName(sellerId, sellerNameMap);
        itemListRespDto.setSellerName(sellerName);
        return itemListRespDto;
    }

    private List<BigDecimal> getSortPrices(List<ItemSkuRespDto> skuList) {
        List<Object> sellPriceList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(skuList)) {
            sellPriceList = skuList.stream().map(ItemSkuRespDto::getPrice).filter(Objects::nonNull).collect(Collectors.toList()).stream().sorted().collect(Collectors.toList());
        }
        return sellPriceList;
    }

    private String getSellerName(Long sellerId, Map<Long, String> sellerNameMap) {
        String sellerName = null;
        if (sellerNameMap.containsKey(sellerId)) {
            sellerName = sellerNameMap.get(sellerId);
        } else {
            SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryById(sellerId));
            if (sellerRespDto != null) {
                sellerName = sellerRespDto.getName();
                sellerNameMap.put(sellerId, sellerName);
            }
        }
        return sellerName;
    }
}

