/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import cn.hutool.core.lang.Assert;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.bitem.api.IBshopService;
import com.dtyunxi.yundt.module.bitem.api.dto.response.marketing.ItemActivityInfoRespDto;
import com.dtyunxi.yundt.module.bitem.biz.service.IBItemActivityService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BshopServiceImpl
implements IBshopService {
    private static final Logger logger = LoggerFactory.getLogger(BshopServiceImpl.class);
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IBItemActivityService activityService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;

    public List<ShopDto> customerShop() {
        List orgIds = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryUpstreamOrgIdsByUserIdAndEnabledStatus(this.context.userId()));
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return Lists.newArrayList();
        }
        ShopToBQueryReqDto shopToBQueryReqDto = new ShopToBQueryReqDto();
        shopToBQueryReqDto.setOrganizationIdList(orgIds);
        shopToBQueryReqDto.setPageNum(1);
        shopToBQueryReqDto.setPageSize(10000);
        shopToBQueryReqDto.setStatus("NORMAL");
        shopToBQueryReqDto.setSellerStatus("NORMAL");
        RestResponse shopRestResponse = this.shopExtQueryApi.queryPage(shopToBQueryReqDto);
        List<ShopDto> shopDtoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)shopRestResponse)).getList().stream().map(item -> {
            ShopDto shopDto = new ShopDto();
            shopDto.setStatus(item.getStatus());
            shopDto.setName(item.getName());
            shopDto.setId(item.getId());
            shopDto.setSellerId(item.getSellerId());
            shopDto.setSellerName(item.getSellerName());
            shopDto.setOrganizationId(item.getOrganizationId());
            shopDto.setOrganizationName(item.getOrganizationName());
            return shopDto;
        }).collect(Collectors.toList());
        return shopDtoList;
    }

    public List<ItemActivityInfoRespDto> queryCouponActivityByShopId(Long shopId) {
        Long customerId = this.queryCustomerIdByShopId(shopId);
        return this.activityService.queryCouponActivityByShopId(shopId, customerId);
    }

    public Long queryCustomerIdByShopId(Long shopId) {
        CustomerInfoDto customerInfoDto = this.queryCustomerInfoByShopId(shopId);
        return customerInfoDto.getCustomerId();
    }

    public CustomerInfoDto queryCustomerInfoByShopId(Long shopId) {
        Long orgInfoId;
        Long customerId;
        String customerIdStr = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isNumeric((CharSequence)customerIdStr)) {
            logger.info("\u4e1a\u52a1\u5458\u7aef\uff1a{}", (Object)customerIdStr);
            customerId = Long.valueOf(customerIdStr);
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds((List)Lists.newArrayList((Object[])new Long[]{customerId})));
            orgInfoId = ((CustomerRespDto)customerRespDtos.get(0)).getOrgInfoId();
        } else {
            logger.info("h5\u7aef");
            orgInfoId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
            ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryById(shopId.longValue(), new String[0]));
            Long sellerOrgId = shopDto.getOrganizationId();
            if (Objects.isNull(sellerOrgId)) {
                RestResponse sellerRespDtoRest = this.sellerQueryApi.queryById(shopDto.getSellerId());
                SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)sellerRespDtoRest);
                sellerOrgId = sellerRespDto.getOrganizationId();
            }
            RestResponse customerRespDtoRest = this.customerExtQueryApi.queryCustomerByOrgAndMerch(orgInfoId, sellerOrgId);
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRespDtoRest);
            Assert.notNull((Object)customerRespDto, (String)"\u6839\u636e\u5e97\u94fa\u83b7\u53d6\u5ba2\u6237ID\u65f6\u5ba2\u6237\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            customerId = customerRespDto.getId();
        }
        CustomerInfoDto customerInfoDto = new CustomerInfoDto();
        customerInfoDto.setCustomerId(customerId);
        customerInfoDto.setOrgId(orgInfoId);
        return customerInfoDto;
    }
}

