/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerBuyScopeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ItemAuthEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.bitem.api.IBCustomerBuyScopeService;
import com.dtyunxi.yundt.module.bitem.api.constants.CustomerBuyScopeTypeEnum;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemDepthQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.CustomerItemAuthInfo;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomerBuyScopeServiceImpl
implements IBCustomerBuyScopeService {
    private static final Logger logger = LoggerFactory.getLogger(CustomerBuyScopeServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;

    public List<CustomerBuyScopeRespDto> getBuyScopeList(List<Long> targetIdList, ItemAuthEnum.TargetType targetType) {
        ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
        itemAuthReqDto.setTargetType(targetType.getCode());
        itemAuthReqDto.setTargetIdList(targetIdList);
        itemAuthReqDto.setStatus(ItemAuthEnum.Status.ENABLE.getCode());
        itemAuthReqDto.setAuthStatus(ItemAuthEnum.Status.ENABLE.getCode());
        logger.info("\u67e5\u8be2\u5ba2\u6237\u5df2\u6388\u6743\u5546\u54c1\u5165\u53c2:{}", (Object)JSON.toJsonString((Object)itemAuthReqDto));
        List itemAuthRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemAuthQueryApi.list(itemAuthReqDto));
        return itemAuthRespDtos.stream().map(item -> {
            CustomerBuyScopeRespDto customerBuyScopeRespDto = new CustomerBuyScopeRespDto();
            customerBuyScopeRespDto.setCustomerId(item.getTargetId());
            customerBuyScopeRespDto.setBusinessId(item.getBusinessId());
            customerBuyScopeRespDto.setBusinessType(item.getBusinessType());
            return customerBuyScopeRespDto;
        }).collect(Collectors.toList());
    }

    public Map<CustomerBuyScopeTypeEnum, List<CustomerBuyScopeRespDto>> getBuyScopeMap(List<Long> targetIdList, ItemAuthEnum.TargetType targetType) {
        List<CustomerBuyScopeRespDto> customerBuyScopeList = this.getBuyScopeList(targetIdList, targetType);
        Map<CustomerBuyScopeTypeEnum, List<CustomerBuyScopeRespDto>> customerBuyScopeMap = customerBuyScopeList.stream().filter(item -> Objects.nonNull(CustomerBuyScopeTypeEnum.toCustomerBuyScopeTypeEnum((String)item.getBusinessType()))).collect(Collectors.groupingBy(item -> CustomerBuyScopeTypeEnum.toCustomerBuyScopeTypeEnum((String)item.getBusinessType()), Collectors.toList()));
        return customerBuyScopeMap;
    }

    public Map<Long, List<Long>> getShopCustomerMap(List<Long> shopIds) {
        if (CollUtil.isEmpty(shopIds)) {
            return null;
        }
        List shopList = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(new HashSet<Long>(shopIds)));
        if (CollUtil.isEmpty((Collection)shopList)) {
            return null;
        }
        List sellerIdList = shopList.stream().filter(shop -> Objects.nonNull(shop.getSellerId())).map(ShopDto::getSellerId).collect(Collectors.toList());
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setIdList(sellerIdList);
        List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(sellerQueryReqDto));
        if (CollUtil.isEmpty((Collection)sellerRespDtos)) {
            return null;
        }
        List merchantIds = sellerRespDtos.stream().map(SellerRespDto::getOrganizationId).collect(Collectors.toList());
        Long currentUserOrgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.querySubCustomerListByOrgIds(merchantIds));
        if (CollUtil.isEmpty((Collection)customerRespDtos)) {
            return null;
        }
        List customerIds = customerRespDtos.stream().filter(customerDto -> Objects.equals(currentUserOrgId, customerDto.getOrgInfoId())).map(BaseRespDto::getId).collect(Collectors.toList());
        Map<Long, Long> shopSellerMap = shopList.stream().collect(Collectors.toMap(ShopDto::getId, ShopDto::getSellerId, (o1, o2) -> o2));
        Map<Long, Long> sellerOrgMap = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getId, SellerRespDto::getOrganizationId, (o1, o2) -> o2));
        Map orgMap = customerRespDtos.stream().filter(customerDto -> Objects.equals(currentUserOrgId, customerDto.getOrgInfoId())).collect(Collectors.groupingBy(CustomerRespDto::getMerchantId, Collectors.toList()));
        HashMap<Long, List<Long>> shopCustomerMap = new HashMap<Long, List<Long>>();
        shopSellerMap.entrySet().stream().filter(obj -> sellerOrgMap.containsKey(obj.getValue())).forEach(obj -> {
            Long orgId = (Long)sellerOrgMap.get(obj.getValue());
            if (orgMap.containsKey(orgId)) {
                shopCustomerMap.put((Long)obj.getKey(), ((List)orgMap.get(orgId)).stream().map(BaseRespDto::getId).collect(Collectors.toList()));
            }
        });
        return shopCustomerMap;
    }

    private List<Long> getCustomerIdByShopId(List<Long> shopIds) {
        if (CollUtil.isEmpty(shopIds)) {
            return null;
        }
        List shopList = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(new HashSet<Long>(shopIds)));
        if (CollUtil.isEmpty((Collection)shopList)) {
            return null;
        }
        List sellerIdList = shopList.stream().filter(shop -> Objects.nonNull(shop.getSellerId())).map(ShopDto::getSellerId).collect(Collectors.toList());
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setIdList(sellerIdList);
        List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(sellerQueryReqDto));
        if (CollUtil.isEmpty((Collection)sellerRespDtos)) {
            return null;
        }
        List merchantIds = sellerRespDtos.stream().map(SellerRespDto::getOrganizationId).collect(Collectors.toList());
        Long currentUserOrgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.querySubCustomerListByOrgIds(merchantIds));
        if (CollUtil.isEmpty((Collection)customerRespDtos)) {
            return null;
        }
        List<Long> customerIds = customerRespDtos.stream().filter(customerDto -> Objects.equals(currentUserOrgId, customerDto.getOrgInfoId())).map(BaseRespDto::getId).collect(Collectors.toList());
        return customerIds;
    }

    public List<Long> getCurrentCustomerId(List<Long> shopIds) {
        return this.getCustomerIdByShopId(shopIds);
    }

    public boolean setCustomerBuyScopeLimit(ItemDepthQueryReqDto itemDepthReqDto, ItemSearchQueryReqDto itemSearchQueryReqDto, Map<Long, List<Long>> outSkuIdsMap) {
        CustomerItemAuthInfo customerItemAuthInfo = this.setCustomerItemAuth(itemDepthReqDto, itemSearchQueryReqDto, outSkuIdsMap);
        return customerItemAuthInfo.getState();
    }

    public CustomerItemAuthInfo setCustomerItemAuth(ItemDepthQueryReqDto itemDepthReqDto, ItemSearchQueryReqDto itemSearchQueryReqDto, Map<Long, List<Long>> outSkuIdsMap) {
        CustomerItemAuthInfo customerItemAuthInfo = new CustomerItemAuthInfo();
        List customerIds = null;
        List shopIds = itemSearchQueryReqDto.getShopIds();
        Long shopId = itemSearchQueryReqDto.getShopId();
        if (CollUtil.isEmpty((Collection)shopIds) && Objects.isNull(shopId)) {
            return customerItemAuthInfo;
        }
        if (Objects.nonNull(shopId)) {
            if (CollUtil.isNotEmpty((Collection)shopIds) && !shopIds.contains(shopId)) {
                return customerItemAuthInfo;
            }
            shopIds = ListUtil.toList((Object[])new Long[]{shopId});
        }
        if (CollUtil.isEmpty((Collection)shopIds)) {
            RestResponse customerRestResponse = this.customerExtQueryApi.queryCustomerIdsByUserId(this.context.userId());
            customerIds = (List)RestResponseHelper.extractData((RestResponse)customerRestResponse);
        } else {
            customerIds = this.getCurrentCustomerId(shopIds);
        }
        if (CollUtil.isEmpty(customerIds)) {
            return customerItemAuthInfo;
        }
        Long brandId = itemDepthReqDto.getBrandId();
        itemSearchQueryReqDto.setBrandId(brandId);
        Map<CustomerBuyScopeTypeEnum, List<CustomerBuyScopeRespDto>> customerBuyScopeMap = this.getBuyScopeMap(customerIds, ItemAuthEnum.TargetType.CUSTOMER);
        if (CollUtil.isEmpty(customerBuyScopeMap)) {
            logger.info("[\u5ba2\u6237\u53ef\u4e70] >>> \u6ca1\u6709\u6388\u6743\u53ef\u4e70\u5546\u54c1\uff0c\u5ba2\u6237\u65e0\u5546\u54c1\u53ef\u8d2d\u4e70");
            return customerItemAuthInfo;
        }
        Set<CustomerBuyScopeTypeEnum> customerBuyScopeTypeEnums = customerBuyScopeMap.keySet();
        for (CustomerBuyScopeTypeEnum key : customerBuyScopeTypeEnums) {
            List businessIds = customerBuyScopeMap.get(key).stream().map(CustomerBuyScopeRespDto::getBusinessId).collect(Collectors.toList());
            if (CollUtil.isEmpty(businessIds)) continue;
            switch (key) {
                case BRAND: {
                    if (Objects.isNull(brandId)) {
                        itemSearchQueryReqDto.setInBrandIds(businessIds);
                        break;
                    }
                    if (businessIds.contains(brandId)) break;
                    logger.info("[\u5ba2\u6237\u53ef\u4e70] >>> \u524d\u7aef\u9650\u5236\u4e86\u54c1\u724c[{}]\uff0c\u4e0e\u6570\u636e\u5e93\u9650\u5236\u65e0\u4ea4\u96c6\uff0c\u5ba2\u6237\u65e0\u5546\u54c1\u53ef\u8d2d\u4e70", (Object)brandId);
                    return customerItemAuthInfo;
                }
                case CATEGORY: {
                    List dirIds = itemSearchQueryReqDto.getDirIds();
                    if (CollUtil.isEmpty((Collection)dirIds)) {
                        itemSearchQueryReqDto.setDirIds(businessIds);
                        break;
                    }
                    businessIds.retainAll(dirIds);
                    if (CollUtil.isEmpty(businessIds)) {
                        logger.info("[\u5ba2\u6237\u53ef\u4e70] >>> \u524d\u7aef\u9650\u5236\u4e86\u7c7b\u76ee[{}]\uff0c\u4e0e\u6570\u636e\u5e93\u9650\u5236\u65e0\u4ea4\u96c6\uff0c\u5ba2\u6237\u65e0\u5546\u54c1\u53ef\u8d2d\u4e70", (Object)dirIds);
                        return customerItemAuthInfo;
                    }
                    itemSearchQueryReqDto.setDirIds(businessIds);
                    break;
                }
                case SKU: {
                    List skuRespDtos = (List)this.itemSkuQueryApi.queryBySkuId(businessIds).getData();
                    if (CollUtil.isEmpty((Collection)skuRespDtos)) {
                        return customerItemAuthInfo;
                    }
                    List itemIdList = skuRespDtos.stream().map(ItemSkuRespDto::getItemId).collect(Collectors.toList());
                    if (CollUtil.isEmpty(itemIdList)) {
                        return customerItemAuthInfo;
                    }
                    List itemIds = itemSearchQueryReqDto.getItemIds();
                    logger.info("[\u5ba2\u6237\u53ef\u4e70] >>> \u5ba2\u6237{}\u53ef\u4e70\u7684 SKU \u5217\u8868\u4e3a{}\u8f6c\u4e3a\u5546\u54c1ID{}", new Object[]{customerIds, businessIds, itemIdList});
                    if (CollUtil.isEmpty((Collection)itemIds)) {
                        itemSearchQueryReqDto.setItemIds(itemIdList);
                    } else {
                        itemIdList.retainAll(itemIds);
                        if (CollUtil.isEmpty(itemIdList)) {
                            logger.info("[\u5ba2\u6237\u53ef\u4e70] >>> \u5df2\u9650\u5236{}\u540e\u65e0\u4ea4\u96c6\uff0c\u5ba2\u6237\u65e0\u5546\u54c1\u53ef\u8d2d\u4e70", (Object)itemIds);
                            return customerItemAuthInfo;
                        }
                        itemSearchQueryReqDto.setItemIds(itemIdList);
                    }
                    logger.info("[\u5ba2\u6237\u53ef\u4e70] >>> \u5ba2\u6237\u53ef\u4e70\u5546\u54c1ID{}", (Object)itemSearchQueryReqDto.getItemIds());
                    if (Objects.nonNull(itemSearchQueryReqDto.getShopId())) {
                        customerItemAuthInfo.pull(itemSearchQueryReqDto.getShopId(), businessIds);
                    }
                    customerItemAuthInfo.setCustomerItemAuthList(customerBuyScopeMap.get(key));
                    customerItemAuthInfo.setCustomerIdList(customerIds);
                    break;
                }
                case BANSKU: {
                    Map<Long, List<ItemSkuRespDto>> itemSkuMap = ((List)this.itemSkuQueryApi.queryBySkuId(businessIds).getData()).stream().collect(Collectors.groupingBy(ItemSkuRespDto::getItemId));
                    itemSkuMap.forEach((itemId, list) -> {
                        List skuIds = list.stream().map(ItemSkuRespDto::getItemId).collect(Collectors.toList());
                        if (outSkuIdsMap.containsKey(itemId)) {
                            outSkuIdsMap.put((Long)itemId, skuIds);
                        } else {
                            ((List)outSkuIdsMap.get(itemId)).addAll(skuIds);
                        }
                    });
                    break;
                }
            }
        }
        customerItemAuthInfo.setState(Boolean.TRUE);
        return customerItemAuthInfo;
    }

    public CustomerItemAuthInfo setShopItemAuth(ItemDepthQueryReqDto itemDepthReqDto, ItemSearchQueryReqDto itemSearchQueryReqDto, Map<Long, List<Long>> outSkuIdsMap) {
        Map<CustomerBuyScopeTypeEnum, List<CustomerBuyScopeRespDto>> customerBuyScopeMap;
        CustomerItemAuthInfo customerItemAuthInfo = new CustomerItemAuthInfo();
        List shopIds = itemSearchQueryReqDto.getShopIds();
        Long shopId = itemSearchQueryReqDto.getShopId();
        if (CollUtil.isEmpty((Collection)shopIds) && Objects.isNull(shopId)) {
            return customerItemAuthInfo;
        }
        if (Objects.nonNull(shopId)) {
            shopIds = ListUtil.toList((Object[])new Long[]{shopId});
        }
        if (CollUtil.isEmpty(customerBuyScopeMap = this.getBuyScopeMap(shopIds, ItemAuthEnum.TargetType.SHOP))) {
            logger.info("[\u5e97\u94fa\u53ef\u5356] >>> \u6ca1\u6709\u6388\u6743\u53ef\u5356\u5546\u54c1\uff0c\u5e97\u94fa\u65e0\u5546\u54c1\u53ef\u5356");
            return customerItemAuthInfo;
        }
        Set<CustomerBuyScopeTypeEnum> customerBuyScopeTypeEnums = customerBuyScopeMap.keySet();
        for (CustomerBuyScopeTypeEnum key : customerBuyScopeTypeEnums) {
            List businessIds = customerBuyScopeMap.get(key).stream().map(CustomerBuyScopeRespDto::getBusinessId).collect(Collectors.toList());
            if (CollUtil.isEmpty(businessIds)) continue;
            switch (key) {
                case SKU: {
                    List skuRespDtos = (List)this.itemSkuQueryApi.queryBySkuId(businessIds).getData();
                    List itemIdList = skuRespDtos.stream().map(ItemSkuRespDto::getItemId).collect(Collectors.toList());
                    if (CollUtil.isEmpty(itemIdList)) {
                        return customerItemAuthInfo;
                    }
                    List itemIds = itemSearchQueryReqDto.getItemIds();
                    logger.info("[\u5e97\u94fa\u53ef\u5356] >>> \u5e97\u94fa{}\u53ef\u5356\u7684 SKU \u5217\u8868\u4e3a{}\u8f6c\u4e3a\u5546\u54c1ID{}", new Object[]{shopIds, businessIds, itemIdList});
                    if (CollUtil.isEmpty((Collection)itemIds)) {
                        itemSearchQueryReqDto.setItemIds(itemIdList);
                    } else {
                        itemIdList.retainAll(itemIds);
                        if (CollUtil.isEmpty(itemIdList)) {
                            logger.info("[\u5e97\u94fa\u53ef\u5356] >>> \u5df2\u9650\u5236{}\u540e\u65e0\u4ea4\u96c6\uff0c\u5e97\u94fa\u65e0\u5546\u54c1\u53ef\u5356", (Object)itemIds);
                            return customerItemAuthInfo;
                        }
                        itemSearchQueryReqDto.setItemIds(itemIdList);
                    }
                    customerItemAuthInfo.setShopIdList(shopIds);
                    customerItemAuthInfo.setShopItemAuthList(customerBuyScopeMap.get(key));
                    logger.info("[\u5e97\u94fa\u53ef\u5356] >>> \u53ef\u5356\u5546\u54c1ID{}", (Object)itemSearchQueryReqDto.getItemIds());
                    break;
                }
            }
        }
        customerItemAuthInfo.setState(Boolean.TRUE);
        return customerItemAuthInfo;
    }
}

