/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.price.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceBeanReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceAddOrModifyRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.BitemInfoDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.SellerSkuPriceDto;
import com.dtyunxi.yundt.module.bitem.biz.handler.BitemHandler;
import com.dtyunxi.yundt.module.bitem.biz.handler.SellerSkuPriceHandler;
import com.dtyunxi.yundt.module.bitem.biz.price.BasePriceTypeServiceImpl;
import com.dtyunxi.yundt.module.bitem.biz.price.constants.PriceTypeEnum;
import com.yx.tcbj.center.api.dto.request.SellerSkuPriceReqDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TcbjPriceImpl
extends BasePriceTypeServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(TcbjPriceImpl.class);
    @Resource
    private BitemHandler bitemHandler;
    @Resource
    private SellerSkuPriceHandler sellerSkuPriceHandler;

    @Override
    public RestResponse<List<ItemPolicyPriceRespDto>> getItemPrice(CommunalPriceQueryReqDto communalPriceQueryReqDto) {
        List customerIds = communalPriceQueryReqDto.getCustomerIds();
        Long custId = communalPriceQueryReqDto.getCustId();
        if (CollUtil.isEmpty((Collection)customerIds)) {
            customerIds = ListUtil.toList((Object[])new Long[]{custId});
        }
        if (CollUtil.isEmpty((Collection)customerIds)) {
            return new RestResponse((Object)ListUtil.empty());
        }
        List skuList = communalPriceQueryReqDto.getSkuList();
        if (CollUtil.isEmpty((Collection)skuList)) {
            return new RestResponse((Object)ListUtil.empty());
        }
        Map shopIdMap = skuList.stream().collect(Collectors.groupingBy(CommunalPriceQueryReqDto.ItemSkuPriceReqDto::getShopId, Collectors.mapping(CommunalPriceQueryReqDto.ItemSkuPriceReqDto::getSkuId, Collectors.toList())));
        Set<Long> shopIdList = shopIdMap.keySet();
        BitemInfoDto shopRelationInfo = this.bitemHandler.getShopRelationInfo(ListUtil.toList(shopIdList));
        Map shopSellerMap = shopRelationInfo.getShopSellerMap();
        Map sellerOrgMap = shopRelationInfo.getSellerOrgMap();
        Map orgCustomerMap = shopRelationInfo.getOrgCustomerMap();
        SellerSkuPriceReqDto sellerSkuPriceReqDto = new SellerSkuPriceReqDto();
        sellerSkuPriceReqDto.setCustomerIdList(customerIds);
        sellerSkuPriceReqDto.setSkuIdList(skuList.stream().map(CommunalPriceQueryReqDto.ItemSkuPriceReqDto::getSkuId).collect(Collectors.toList()));
        Map<String, SellerSkuPriceDto> sellerSkuPriceMap = this.getSellerSkuPrice(sellerSkuPriceReqDto);
        HashMap decimalMap = MapUtil.newHashMap();
        ArrayList<ItemPolicyPriceRespDto> itemPolicyPriceRespDtos = new ArrayList<ItemPolicyPriceRespDto>();
        for (CommunalPriceQueryReqDto.ItemSkuPriceReqDto skuInfo : skuList) {
            Long orgId;
            Long sellerId = (Long)shopSellerMap.get(skuInfo.getShopId());
            if (Objects.isNull(sellerId) || Objects.isNull(orgId = (Long)sellerOrgMap.get(sellerId)) || !orgCustomerMap.containsKey(orgId)) continue;
            List custIdList = (List)orgCustomerMap.get(orgId);
            if (CollUtil.isEmpty((Collection)custIdList)) {
                this.logger.info("[\u4ef7\u683c\u67e5\u8be2] >>> \u5e97\u94fa[{}]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5ba2\u6237id", (Object)skuInfo.getShopId());
                continue;
            }
            for (Long customerId : customerIds) {
                if (!custIdList.contains(customerId)) continue;
                String key = customerId + "-" + skuInfo.getSkuId();
                if (sellerSkuPriceMap.containsKey(key)) {
                    ItemPolicyPriceRespDto itemPolicyPriceRespDto = new ItemPolicyPriceRespDto();
                    itemPolicyPriceRespDto.setItemId(skuInfo.getItemId());
                    itemPolicyPriceRespDto.setShopId(skuInfo.getShopId());
                    itemPolicyPriceRespDto.setSkuId(skuInfo.getSkuId());
                    itemPolicyPriceRespDto.setPrice(sellerSkuPriceMap.get(key).getMinSkuPrice());
                    itemPolicyPriceRespDto.setCustId(String.valueOf(customerId));
                    HashMap retailPriceMap = MapUtil.newHashMap();
                    BigDecimal retailPrice = sellerSkuPriceMap.get(key).getRetailPrice();
                    retailPriceMap.put("retailPrice", retailPrice);
                    itemPolicyPriceRespDto.setExtFields((Map)retailPriceMap);
                    itemPolicyPriceRespDtos.add(itemPolicyPriceRespDto);
                    decimalMap.put(skuInfo.getShopId() + "-" + key, itemPolicyPriceRespDto.getPrice());
                    continue;
                }
                decimalMap.put(skuInfo.getShopId() + "-" + key, null);
            }
        }
        this.logger.info("[\u4ef7\u683c\u67e5\u8be2] >>> \u5ba2\u6237{}\u67e5\u4ef7\u7ed3\u679c[shopId-customerId-skuId:price]\uff1a{}", (Object)customerIds, (Object)JSON.toJsonString((Object)decimalMap));
        return new RestResponse(itemPolicyPriceRespDtos);
    }

    @Override
    public RestResponse<PriceAddOrModifyRespDto> queryPriceLimit(PriceBeanReqDto priceBeanReqDto) {
        return null;
    }

    @Override
    public Map<String, SellerSkuPriceDto> getSellerSkuPrice(SellerSkuPriceReqDto sellerSkuPriceReqDto) {
        this.logger.info("[\u4ef7\u683c\u67e5\u8be2] >>> \u6c64\u81e3\u500d\u5065\u67e5\u8be2\u4ef7\u683c\uff0c\u67e5\u8be2\u4ef7\u683c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)sellerSkuPriceReqDto));
        return this.sellerSkuPriceHandler.getSellerSkuPrice(sellerSkuPriceReqDto);
    }

    @Override
    public PriceTypeEnum priceType() {
        return PriceTypeEnum.TCBJ;
    }
}

