/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.common.condition.Criteria;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.IItemActivityStockApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ActivityStockReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.RemainingStockBatchReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.TargetCustomerReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.RemainingStockBatchRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityPriceDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityPriceQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IItemActivityPriceQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IItemActivityTagQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCategoryEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponTemplateExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponTypeEnum;
import com.dtyunxi.yundt.module.bitem.api.constants.GroupActivityConstant;
import com.dtyunxi.yundt.module.bitem.api.dto.ShopItemDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.marketing.BaseActivityDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.marketing.ItemActivityInfoRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.marketing.ItemForActivityInfoRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.marketing.TobCouponTemplate;
import com.dtyunxi.yundt.module.bitem.api.dto.response.marketing.XCXItemForActivityInfoRespDto;
import com.dtyunxi.yundt.module.bitem.biz.service.IBItemActivityService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BItemActivityServiceImpl
implements IBItemActivityService {
    private static final Logger logger = LoggerFactory.getLogger(BItemActivityServiceImpl.class);
    @Resource
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IItemActivityTagQueryApi itemActivityTagQueryApi;
    @Resource
    private ICouponTemplateExtQueryApi couponTemplateExtQueryApi;
    @Resource
    private IItemActivityPriceQueryApi itemActivityPriceQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IItemActivityStockApi itemActivityStockApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;

    @Override
    public List<ItemActivityInfoRespDto> queryCouponActivityByShopId(Long shopId, Long customerId) {
        List<Object> couponActivityList = Lists.newArrayList();
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setPreheatStartTime(new Date());
        queryReqDto.setShopId(shopId);
        queryReqDto.setDimensionList((List)Lists.newArrayList((Object[])new Integer[]{ActivityDimensionEnum.COUPON.getKey()}));
        queryReqDto.setDisplay(Integer.valueOf(1));
        List itemActivityTagDtos = (List)this.itemActivityTagQueryApi.queryList(queryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)itemActivityTagDtos)) {
            return couponActivityList;
        }
        Map<String, ItemActivityTagDto> itemActivityTagMap = itemActivityTagDtos.stream().collect(Collectors.toMap(tagDto -> tagDto.getShopId() + "_" + tagDto.getActivityId(), e -> e, (e1, e2) -> e1));
        ArrayList activityInfoRespDtos = Lists.newArrayList();
        for (ItemActivityTagDto tagDto2 : itemActivityTagMap.values()) {
            ItemActivityInfoRespDto itemActivityInfoRespDto2 = this.convertToItemActivityInfoRespDto(tagDto2);
            activityInfoRespDtos.add(itemActivityInfoRespDto2);
        }
        couponActivityList = this.getCouponActivityInfoRespDtos(activityInfoRespDtos);
        List activityIdsList = activityInfoRespDtos.stream().map(BaseActivityDto::getId).collect(Collectors.toList());
        CustomerRespDto customerInfo = (CustomerRespDto)this.customerQueryApi.queryById(customerId).getData();
        TargetCustomerReqDto targetCustomerReqDto = new TargetCustomerReqDto();
        targetCustomerReqDto.setActivityIds(activityIdsList);
        targetCustomerReqDto.setCustomerInfo((CustomerReqDto)BeanUtil.copyProperties((Object)customerInfo, CustomerReqDto.class, (String[])new String[0]));
        List targetActivityIdsList = (List)this.itemActivityStockApi.validateTargetCustomersAndMallType(targetCustomerReqDto).getData();
        activityIdsList.clear();
        activityIdsList.addAll(targetActivityIdsList);
        couponActivityList.removeIf(itemActivityInfoRespDto -> !activityIdsList.contains(itemActivityInfoRespDto.getId()));
        return couponActivityList;
    }

    @Override
    public ItemForActivityInfoRespDto queryActivityByItemId(Long itemId, Long shopId, List<Long> activityIdsList, Long customerId) {
        ItemForActivityInfoRespDto itemForActivityInfo = new ItemForActivityInfoRespDto();
        itemForActivityInfo.setSystemTime(System.currentTimeMillis());
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setPreheatStartTime(new Date());
        queryReqDto.setItemId(itemId);
        queryReqDto.setShopId(shopId);
        queryReqDto.setDimensionList((List)Lists.newArrayList((Object[])new Integer[]{ActivityDimensionEnum.COUPON.getKey(), ActivityDimensionEnum.ORDER.getKey(), ActivityDimensionEnum.ITEM.getKey()}));
        queryReqDto.setDisplay(Integer.valueOf(1));
        List itemActivityTagDtos = (List)this.itemActivityTagQueryApi.queryList(queryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)itemActivityTagDtos)) {
            return itemForActivityInfo;
        }
        Map<Integer, List<ItemActivityInfoRespDto>> group = itemActivityTagDtos.stream().map(this::convertToItemActivityInfoRespDto).collect(Collectors.groupingBy(ItemActivityInfoRespDto::getDimension));
        ArrayList orderActivityIds = Lists.newArrayList();
        for (Integer dimension : group.keySet()) {
            List<ItemActivityInfoRespDto> activityInfoRespDtos = group.get(dimension);
            if (ActivityDimensionEnum.COUPON.getKey().equals(dimension)) {
                List<ItemActivityInfoRespDto> couponActivityList = this.getCouponActivityInfoRespDtos(activityInfoRespDtos);
                itemForActivityInfo.setCouponActivityInfo(couponActivityList);
                activityIdsList.addAll(activityInfoRespDtos.stream().map(BaseActivityDto::getId).collect(Collectors.toList()));
                continue;
            }
            if (ActivityDimensionEnum.ORDER.getKey().equals(dimension)) {
                List activityInfoRespDtoList = activityInfoRespDtos.stream().map(item -> {
                    XCXItemForActivityInfoRespDto xcxItemForActivityInfoRespDto = new XCXItemForActivityInfoRespDto();
                    CubeBeanUtils.copyProperties((Object)xcxItemForActivityInfoRespDto, (Object)item, (String[])new String[0]);
                    return xcxItemForActivityInfoRespDto;
                }).collect(Collectors.toList());
                itemForActivityInfo.setOrderActivityInfo(activityInfoRespDtoList);
                orderActivityIds.addAll(activityInfoRespDtos.stream().map(BaseActivityDto::getId).collect(Collectors.toList()));
                continue;
            }
            if (!ActivityDimensionEnum.ITEM.getKey().equals(dimension)) continue;
            orderActivityIds.addAll(activityInfoRespDtos.stream().map(BaseActivityDto::getId).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)orderActivityIds)) {
            RemainingStockBatchReqDto reqDto = new RemainingStockBatchReqDto();
            ArrayList<ActivityStockReqDto> activityStockList = new ArrayList<ActivityStockReqDto>(1);
            ActivityStockReqDto stockReqDto = new ActivityStockReqDto();
            stockReqDto.setItemId(itemId);
            stockReqDto.setShopId(shopId);
            stockReqDto.setActivityIds((List)orderActivityIds);
            activityStockList.add(stockReqDto);
            reqDto.setActivityStockList(activityStockList);
            RestResponse activityRemainingStockBatch = this.itemActivityStockApi.getActivityRemainingStockBatch(reqDto);
            RemainingStockBatchRespDto respDto = (RemainingStockBatchRespDto)RestResponseHelper.extractData((RestResponse)activityRemainingStockBatch);
            itemForActivityInfo.setRemainingStockMap(respDto.getRemainingStockMap());
            Map activityListMap = respDto.getActivityListMap();
            List needActivityIds = (List)activityListMap.get(shopId + "_" + itemId);
            if (CollectionUtils.isNotEmpty((Collection)needActivityIds)) {
                activityIdsList.addAll(needActivityIds);
            }
        }
        CustomerRespDto customerInfo = (CustomerRespDto)this.customerQueryApi.queryById(customerId).getData();
        TargetCustomerReqDto targetCustomerReqDto = new TargetCustomerReqDto();
        targetCustomerReqDto.setActivityIds(activityIdsList);
        targetCustomerReqDto.setCustomerInfo((CustomerReqDto)BeanUtil.copyProperties((Object)customerInfo, CustomerReqDto.class, (String[])new String[0]));
        List targetActivityIdsList = (List)this.itemActivityStockApi.validateTargetCustomersAndMallType(targetCustomerReqDto).getData();
        activityIdsList.clear();
        activityIdsList.addAll(targetActivityIdsList);
        List couponActivityInfoList = itemForActivityInfo.getCouponActivityInfo();
        couponActivityInfoList.removeIf(itemActivityInfoRespDto -> !activityIdsList.contains(itemActivityInfoRespDto.getId()));
        List orderActivityInfoList = itemForActivityInfo.getOrderActivityInfo();
        orderActivityInfoList.removeIf(itemActivityInfoRespDto -> !activityIdsList.contains(itemActivityInfoRespDto.getId()));
        return itemForActivityInfo;
    }

    private List<ItemActivityInfoRespDto> getCouponActivityInfoRespDtos(List<ItemActivityInfoRespDto> activityInfoRespDtos) {
        List<Long> activityIds = activityInfoRespDtos.stream().map(BaseActivityDto::getId).collect(Collectors.toList());
        Long currentUserOrgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        List<TobCouponTemplate> templates = this.queryByActivityIds(activityIds, currentUserOrgId);
        Map<Long, TobCouponTemplate> templateMap = templates.stream().collect(Collectors.toMap(TobCouponTemplate::getActivityId, e -> e, (e1, e2) -> e1));
        ArrayList activityList = Lists.newArrayList();
        activityInfoRespDtos.forEach(activityInfoDto -> {
            if (templateMap.containsKey(activityInfoDto.getId())) {
                TobCouponTemplate tobCouponTemplate = (TobCouponTemplate)templateMap.get(activityInfoDto.getId());
                tobCouponTemplate.setTag(activityInfoDto.getTag());
                activityInfoDto.setTobCouponTemplate(tobCouponTemplate);
                activityList.add(activityInfoDto);
            }
        });
        return activityList;
    }

    private ItemActivityInfoRespDto convertToItemActivityInfoRespDto(ItemActivityTagDto itemActivityTagDto) {
        ItemActivityInfoRespDto activityInfo = new ItemActivityInfoRespDto();
        try {
            ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(itemActivityTagDto.getActivityId().longValue()).getData();
            CubeBeanUtils.copyProperties((Object)activityInfo, (Object)activityRespDto, (String[])new String[0]);
            if (null == activityRespDto.getPreheatStartTime()) {
                activityInfo.setPreheatStartTime(activityRespDto.getBeginTime());
            }
            activityInfo.setDimension(activityRespDto.getActivityTemplate().getDimension());
            activityInfo.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return activityInfo;
    }

    @Override
    public PageInfo<ActivityRespDto> queryActivityPage(ActivityDto queryDto, Integer pageNum, Integer pageSize) {
        queryDto.setAuditStatusEnum(AuditStatusEnum.AUDIT_PASS);
        queryDto.setActivityStatus((List)Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.READY.getKey(), ActivityStatusEnum.ACTIVATE.getKey()}));
        return (PageInfo)this.activityQueryApi.queryActivityPage(queryDto, pageNum, pageSize).getData();
    }

    @Override
    public List<TobCouponTemplate> queryByActivityIds(List<Long> activityIds, Long currentUserOrgId) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.ge((String)"receive_end_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)new Date())));
        sqlFilterList.add(SqlFilter.in((String)"activityId", activityIds));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_type", (Object)CouponTypeEnum.COUPON.getType()));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_template_status", (Object)CouponTemplateStatusEnum.ACTIVATE.getStatus()));
        sqlFilterList.add(SqlFilter.in((String)"coupon_category", (Object)Lists.newArrayList((Object[])new Integer[]{CouponCategoryEnum.QUOTA_CASH.getCategory(), CouponCategoryEnum.DISCOUNT.getCategory()})));
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilterList);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        if (Objects.nonNull(currentUserOrgId)) {
            criteria.setFields((List)Lists.newArrayList((Object[])new String[]{currentUserOrgId.toString()}));
        }
        PageInfo couponTpPage = (PageInfo)this.couponTemplateExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), Integer.valueOf(1), Integer.valueOf(activityIds.size())).getData();
        PageInfo<TobCouponTemplate> pageInfo = this.convertToCouponTemplatePage((PageInfo<CouponTemplateExtRespDto>)couponTpPage);
        return pageInfo.getList();
    }

    private PageInfo<TobCouponTemplate> convertToCouponTemplatePage(PageInfo<CouponTemplateExtRespDto> couponTemplatePage) {
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties(couponTemplatePage, (Object)pageInfo);
        TobCouponTemplate tobCouponTemplate = null;
        ArrayList<TobCouponTemplate> tobCouponTemplateList = new ArrayList<TobCouponTemplate>();
        if (CollectionUtils.isNotEmpty((Collection)couponTemplatePage.getList())) {
            for (CouponTemplateExtRespDto templateExtRespDto : couponTemplatePage.getList()) {
                tobCouponTemplate = new TobCouponTemplate();
                CubeBeanUtils.copyProperties((Object)tobCouponTemplate, (Object)templateExtRespDto, (String[])new String[0]);
                tobCouponTemplate.setCouponUseBeginTime(templateExtRespDto.getEffectiveTime());
                tobCouponTemplate.setCouponUseEndTime(templateExtRespDto.getInvalidTime());
                tobCouponTemplate.setLimitNum(templateExtRespDto.getLimitQty());
                tobCouponTemplate.setRemainingLimitNum(templateExtRespDto.getRemainingLimitQty());
                tobCouponTemplate.setDailyLimitNum(templateExtRespDto.getDayLimitQty());
                tobCouponTemplate.setRemainingDailyLimitNum(templateExtRespDto.getRemainingDayLimitQty());
                tobCouponTemplateList.add(tobCouponTemplate);
            }
        }
        pageInfo.setList(tobCouponTemplateList);
        return pageInfo;
    }

    @Override
    public List<Long> queryByCouponTpId(Long couponTpId) {
        CouponTemplateExtRespDto couponTemplate = null;
        try {
            couponTemplate = (CouponTemplateExtRespDto)this.couponTemplateExtQueryApi.queryById(couponTpId).getData();
        }
        catch (Exception e) {
            logger.error("couponTemplateExtQueryApi.queryById\u67e5\u8be2\u4f18\u60e0\u5238\u6a21\u677f\u5f02\u5e38", (Object)e.getMessage());
        }
        if (null == couponTemplate) {
            return Collections.EMPTY_LIST;
        }
        return this.queryByActivityId(couponTemplate.getActivityId());
    }

    @Override
    public List<Long> queryByActivityId(Long activityId) {
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setActivityId(activityId);
        List itemActivityTagDtos = (List)this.itemActivityTagQueryApi.queryList(queryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)itemActivityTagDtos)) {
            return Collections.EMPTY_LIST;
        }
        return itemActivityTagDtos.stream().map(ItemActivityTagDto::getItemId).collect(Collectors.toList());
    }

    @Override
    public Long queryActivityId(Long couponTpId) {
        try {
            CouponTemplateExtRespDto couponTemplate = (CouponTemplateExtRespDto)this.couponTemplateExtQueryApi.queryById(couponTpId).getData();
            return couponTemplate.getActivityId();
        }
        catch (Exception e) {
            logger.error("couponTemplateExtQueryApi.queryById\u67e5\u8be2\u4f18\u60e0\u5238\u6a21\u677f\u5f02\u5e38", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public Long getSellerId(Long activityId, Long couponTpId) {
        try {
            if (null != couponTpId) {
                activityId = this.queryActivityId(couponTpId);
            }
            if (null != activityId) {
                ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(activityId.longValue()).getData();
                return activityRespDto.getSellerId();
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6d3b\u52a8\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    @Override
    public Integer getGroupNumber(ActivityRespDto activityRespDto) {
        List conditions = activityRespDto.getConditionDtos();
        if (CollectionUtils.isNotEmpty((Collection)conditions)) {
            for (ConditionRespDto condition : conditions) {
                if (!GroupActivityConstant.CONDITION_GROUP_NUMBER_TP_ID.equals(condition.getConditionTemplateId())) continue;
                JSONObject jsonObject = JSON.parseObject((String)condition.getConditionParams());
                if (null == jsonObject) break;
                return jsonObject.getInteger("GroupNumberCondition.number");
            }
        }
        return null;
    }

    @Override
    public Map<String, List<ItemActivityTagDto>> queryItemActivityTags(ItemActivityTagQueryReqDto queryReqDto) {
        queryReqDto.setInstanceId(this.context.instanceId());
        queryReqDto.setTenantId(this.context.tenantId());
        queryReqDto.setPreheatStartTime(new Date());
        List list = (List)this.itemActivityTagQueryApi.queryList(queryReqDto).getData();
        this.filter(list);
        Map<String, List<ItemActivityTagDto>> itemTagsMap = list.stream().collect(Collectors.groupingBy(tagDto -> tagDto.getShopId() + tagDto.getItemId().toString()));
        return itemTagsMap;
    }

    private void filter(List<ItemActivityTagDto> tags) {
        List couponTags = tags.stream().filter((? super T tagDto) -> ActivityDimensionEnum.COUPON.getKey().equals(tagDto.getDimension())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(couponTags)) {
            Set activityIds = couponTags.stream().map(ItemActivityTagDto::getActivityId).collect(Collectors.toSet());
            List<TobCouponTemplate> templates = this.queryByActivityIds(Lists.newArrayList(activityIds), null);
            List availableIds = templates.stream().map(TobCouponTemplate::getActivityId).collect(Collectors.toList());
            activityIds.removeAll(availableIds);
            tags.removeIf(tagDto -> activityIds.contains(tagDto.getActivityId()));
        }
    }

    @Override
    public List<ShopItemDto> queryShopItems(Long activityId, Long couponTpId) {
        if (null != couponTpId) {
            activityId = this.queryActivityId(couponTpId);
        }
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setActivityId(activityId);
        List itemActivityTagDtos = (List)this.itemActivityTagQueryApi.queryList(queryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)itemActivityTagDtos)) {
            return Collections.EMPTY_LIST;
        }
        return itemActivityTagDtos.stream().map(tagDto -> new ShopItemDto(tagDto.getShopId(), tagDto.getItemId())).collect(Collectors.toList());
    }

    @Override
    public Map<String, List<ItemActivityPriceDto>> queryItemActivityPriceDtos(ItemActivityPriceQueryReqDto queryReqDto) {
        List priceDtos = (List)this.itemActivityStockApi.queryEnableList(queryReqDto).getData();
        Map<String, List<ItemActivityPriceDto>> priceMap = priceDtos.stream().collect(Collectors.groupingBy(priceDto -> priceDto.getShopId() + priceDto.getItemId().toString()));
        return priceMap;
    }
}

