/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceConditionQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuPriceQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IBasePriceItemQueryApi;
import com.dtyunxi.yundt.module.bitem.biz.service.IBItemAuthService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BItemAuthServiceImpl
implements IBItemAuthService {
    private static final Logger log = LoggerFactory.getLogger(BItemAuthServiceImpl.class);
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private IBasePriceItemQueryApi basePriceItemQueryApi;

    @Override
    public RestResponse<PageInfo<ItemAuthQueryRespDto>> queryItemAuthPage(ItemAuthQueryReqDto itemAuthQueryReqDto) {
        RestResponse pageInfoRestResponse = this.itemAuthQueryApi.queryItemAuthPage(itemAuthQueryReqDto);
        if (Objects.isNull(pageInfoRestResponse.getData()) || CollUtil.isEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
            return pageInfoRestResponse;
        }
        List list = ((PageInfo)pageInfoRestResponse.getData()).getList();
        this.setRetailPrice(list);
        ((PageInfo)pageInfoRestResponse.getData()).setList(list);
        return pageInfoRestResponse;
    }

    private void setRetailPrice(List<ItemAuthQueryRespDto> itemRespDtos) {
        ItemSkuPriceQueryReqDto itemSkuPriceQueryReqDto = new ItemSkuPriceQueryReqDto();
        itemSkuPriceQueryReqDto.setPriceTypeIdStr(PriceTypeEnum.RETAIL_PRICE + "," + PriceTypeEnum.DEALER_RETAIL_PRICE);
        ArrayList shopConditionList = Lists.newArrayList();
        shopConditionList.addAll(itemRespDtos.stream().map(t -> {
            ItemSkuPriceConditionQueryReqDto itemSkuPriceConditionQueryReqDto = new ItemSkuPriceConditionQueryReqDto();
            itemSkuPriceConditionQueryReqDto.setSkuId(t.getBusinessId());
            itemSkuPriceConditionQueryReqDto.setShopId(t.getTargetId());
            return itemSkuPriceConditionQueryReqDto;
        }).collect(Collectors.toList()));
        itemSkuPriceQueryReqDto.setShopConditionList((List)shopConditionList);
        RestResponse restResponse = this.basePriceItemQueryApi.queryRetailSkuPrice(itemSkuPriceQueryReqDto);
        log.info("\u67e5\u8be2\u4ef7\u683c\u8fd4\u56de\u7684\u6570\u636e:{}", (Object)JacksonUtil.toJson((Object)restResponse));
        if (!"0".equals(restResponse.getResultCode())) {
            log.info("\u67e5\u8be2\u4ef7\u683c\u6709\u8bef:{}", (Object)JacksonUtil.toJson((Object)restResponse));
            return;
        }
        List itemSkuPriceQueryRespDtoList = (List)restResponse.getData();
        if (CollectionUtils.isEmpty((Collection)itemSkuPriceQueryRespDtoList)) {
            log.info("\u67e5\u8be2\u4ef7\u683c\u8fd4\u56de\u4e3a\u7a7a:{}", (Object)JacksonUtil.toJson((Object)itemSkuPriceQueryRespDtoList));
            return;
        }
        Map itemSkuPriceQueryReqDtoMap = itemSkuPriceQueryRespDtoList.stream().collect(Collectors.toMap(item -> item.getShopId() + "-" + item.getSkuId(), Function.identity(), (o1, o2) -> o2));
        itemRespDtos.forEach(itemRespDto -> {
            ItemSkuPriceQueryRespDto priceDealerRetail = (ItemSkuPriceQueryRespDto)itemSkuPriceQueryReqDtoMap.get(itemRespDto.getTargetId() + "-" + itemRespDto.getBusinessId());
            if (Objects.nonNull(priceDealerRetail) && Objects.nonNull(priceDealerRetail.getDealerRetailPrice())) {
                itemRespDto.setDealerRetailPrice(priceDealerRetail.getDealerRetailPrice());
            }
            if (Objects.nonNull(priceDealerRetail) && Objects.nonNull(priceDealerRetail.getCostRetailPrice())) {
                itemRespDto.setRetailPrice(priceDealerRetail.getCostRetailPrice());
            }
        });
    }
}

