/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition.seckill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.model.SeckillItem;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.dto.ItemChangeApplyDetailDto;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.BlackItemSkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ApplicableActivityItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.PromotionActivitySkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.seckill.SeckillActivityDto;
import com.dtyunxi.yundt.module.marketing.api.enums.SelectTypeEnum;
import com.dtyunxi.yundt.module.marketing.biz.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeckillItemCondition
extends AbstractBaseTemplate {
    private static Logger logger = LoggerFactory.getLogger(SeckillItemCondition.class);

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880286L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.SECKILL_ACTIVITY.equals((Object)type) || ActivityType.SECKILL_TOB_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityTobDto> ConditionReqDto convertToCondition(T t) {
        SeckillActivityDto seckillActivityDto = (SeckillActivityDto)t;
        ConditionReqDto condition = this.getConditionReqDto();
        HashMap conditionParam = Maps.newHashMap();
        ArrayList seckillItems = Lists.newArrayList();
        if (SelectTypeEnum.ALL.getCode().equals(seckillActivityDto.getSelectType()) || SelectTypeEnum.CATEGORY.getCode().equals(seckillActivityDto.getSelectType())) {
            if (CollectionUtils.isNotEmpty((Collection)seckillActivityDto.getActivityItems())) {
                seckillActivityDto.getActivityItems().forEach(itemDto -> {
                    SeckillItem seckillItem = new SeckillItem();
                    seckillItem.setItemId(itemDto.getItemId());
                    seckillItem.setSkuId(itemDto.getSkuId());
                    seckillItem.setShopId(itemDto.getShopId());
                    seckillItem.setPrice(itemDto.getSellPrice());
                    seckillItem.setDiscount(itemDto.getDiscount());
                    seckillItem.setActivityPrice(itemDto.getActivityPrice());
                    seckillItems.add(seckillItem);
                });
            }
        } else {
            seckillActivityDto.getActivityItems().forEach(itemDto -> itemDto.getSkus().forEach(skuDto -> {
                SeckillItem seckillItem = new SeckillItem();
                seckillItem.setSkuId(skuDto.getSkuId());
                seckillItem.setItemId(itemDto.getItemId());
                seckillItem.setActivityStock(skuDto.getActivityStock());
                seckillItem.setPrice(skuDto.getRetailPrice());
                seckillItem.setShopId(itemDto.getShopId());
                if (2 == seckillActivityDto.getPromotionMethod()) {
                    seckillItem.setDiscount(skuDto.getDiscount());
                    if (null != skuDto.getRetailPrice()) {
                        seckillItem.setActivityPrice(skuDto.getRetailPrice().multiply(skuDto.getDiscount()).divide(new BigDecimal(10)));
                    }
                } else {
                    seckillItem.setActivityPrice(skuDto.getPromotionPrice());
                }
                seckillItems.add(seckillItem);
            }));
        }
        if (CollectionUtils.isNotEmpty((Collection)seckillActivityDto.getBlackItems())) {
            List blackItems = seckillActivityDto.getBlackItems().stream().map(itemDto -> {
                ItemSkuDto itemSkuDto = new ItemSkuDto();
                itemSkuDto.setItemId(itemDto.getItemId());
                itemSkuDto.setShopId(itemDto.getShopId());
                itemSkuDto.setSkuId(itemDto.getSkuId());
                return itemSkuDto;
            }).collect(Collectors.toList());
            conditionParam.put("SeckillItemCondition.blackItems", blackItems);
        }
        conditionParam.put("SeckillItemCondition.items", seckillItems);
        conditionParam.put("SeckillItemCondition.type", seckillActivityDto.getSelectType());
        conditionParam.put("SeckillItemCondition.brandIds", seckillActivityDto.getBrandIds());
        conditionParam.put("SeckillItemCondition.dirIds", seckillActivityDto.getDirIds());
        conditionParam.put("SeckillItemCondition.promotionMethod", seckillActivityDto.getPromotionMethod());
        conditionParam.put("SeckillItemCondition.promotionValue", seckillActivityDto.getPromotionValue());
        logger.info("\u9650\u65f6\u62a2\u8d2d\u6d3b\u52a8\u9002\u7528\u5546\u54c1\u6761\u4ef6\u53c2\u6570={}", (Object)JSON.toJSONString((Object)conditionParam));
        condition.setConditionParams(JSON.toJSONString((Object)conditionParam));
        return condition;
    }

    @Override
    protected <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        SeckillActivityDto seckillActivityDto = (SeckillActivityDto)t;
        IActivityItemQueryApi activityItemQueryApi = (IActivityItemQueryApi)SpringBeanUtil.getBean(IActivityItemQueryApi.class);
        IBitemService itemService = (IBitemService)SpringBeanUtil.getBean(IBitemService.class);
        IShopQueryApi shopQueryApi = (IShopQueryApi)SpringBeanUtil.getBean(IShopQueryApi.class);
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        Integer selectType = jsonObject.getInteger("SeckillItemCondition.type");
        Integer promotionMethod = jsonObject.getInteger("SeckillItemCondition.promotionMethod");
        List conditionItems = JSONArray.parseArray((String)jsonObject.getString("SeckillItemCondition.items"), SeckillItem.class);
        if (SelectTypeEnum.ALL.getCode().equals(selectType) || SelectTypeEnum.CATEGORY.getCode().equals(selectType)) {
            List brandIds = JSON.parseArray((String)jsonObject.getString("SeckillItemCondition.brandIds"), Long.class);
            List dirIds = JSON.parseArray((String)jsonObject.getString("SeckillItemCondition.dirIds"), Long.class);
            List blackItems = JSON.parseArray((String)jsonObject.getString("SeckillItemCondition.blackItems"), ItemSkuDto.class);
            ArrayList<BlackItemSkuDto> blackActivityItems = new ArrayList<BlackItemSkuDto>();
            if (CollectionUtils.isNotEmpty((Collection)blackItems)) {
                for (ItemSkuDto blackItem : blackItems) {
                    ItemChangeApplyDetailDto itemDetail = itemService.getDetailByItemId(blackItem.getShopId(), blackItem.getItemId(), ItemBusTypeEnum.ORDINARY.getType());
                    BlackItemSkuDto blackItemSkuDto = new BlackItemSkuDto();
                    blackItemSkuDto.setItemId(blackItem.getItemId());
                    blackItemSkuDto.setItemCode(itemDetail.getItemCode());
                    blackItemSkuDto.setItemName(itemDetail.getItemName());
                    blackItemSkuDto.setShopId(blackItem.getShopId());
                    blackItemSkuDto.setSkuId(blackItem.getSkuId());
                    itemDetail.getSkuList().stream().filter(skuRespDto -> skuRespDto.getId().equals(blackItem.getSkuId())).findFirst().ifPresent(itemSku -> {
                        if (null != itemSku.getAttrMap()) {
                            String skuName = StringUtils.join(itemSku.getAttrMap().values(), (String)" ");
                            blackItemSkuDto.setSkuDesc(skuName);
                            blackItemSkuDto.setAttr(skuName);
                        }
                    });
                    blackActivityItems.add(blackItemSkuDto);
                }
            }
            BigDecimal promotionValue = jsonObject.getBigDecimal("SeckillItemCondition.promotionValue");
            seckillActivityDto.setPromotionValue(promotionValue);
            seckillActivityDto.setBrandIds(brandIds);
            seckillActivityDto.setDirIds(dirIds);
            seckillActivityDto.setBlackItems(blackActivityItems);
            return;
        }
        ActivityItemQueryReqDto activityItemQueryReqDto = new ActivityItemQueryReqDto();
        activityItemQueryReqDto.setActivityId(seckillActivityDto.getId());
        List items = (List)activityItemQueryApi.queryAll(activityItemQueryReqDto).getData();
        Map<String, List<ActivityItemRespDto>> group = items.stream().collect(Collectors.groupingBy(activityItem -> activityItem.getShopId() + activityItem.getItemId().toString() + activityItem.getSkuId()));
        Map<String, List<SeckillItem>> seckillItemGroup = conditionItems.stream().collect(Collectors.groupingBy(activityItem -> activityItem.getShopId() + activityItem.getItemId().toString() + activityItem.getSkuId()));
        ArrayList groupActivityItemDtos = Lists.newArrayList();
        group.forEach((shopItemKey, itemDtos) -> {
            Long itemId = ((ActivityItemRespDto)itemDtos.get(0)).getItemId();
            Long shopId = ((ActivityItemRespDto)itemDtos.get(0)).getShopId();
            ItemChangeApplyDetailDto itemDetail = itemService.getDetailByItemId(shopId, itemId, ItemBusTypeEnum.ORDINARY.getType());
            if (null == itemDetail) {
                return;
            }
            ApplicableActivityItemDto applicableActivityItemDto = new ApplicableActivityItemDto();
            applicableActivityItemDto.setItemId(itemId);
            applicableActivityItemDto.setItemCode(itemDetail.getItemCode());
            applicableActivityItemDto.setItemName(itemDetail.getItemName());
            applicableActivityItemDto.setShopId(shopId);
            applicableActivityItemDto.setSkuId(((ActivityItemRespDto)itemDtos.get(0)).getSkuId());
            applicableActivityItemDto.setSubType(itemDetail.getSubType());
            if (null != shopId) {
                ShopBaseDto shopDto = (ShopBaseDto)shopQueryApi.queryBaseById(shopId).getData();
                applicableActivityItemDto.setShopName(shopDto == null ? null : shopDto.getName());
            }
            List seckillItems = (List)seckillItemGroup.get(shopItemKey);
            Long totalStock = 0L;
            ArrayList skus = Lists.newArrayList();
            BigDecimal minPrice = BigDecimal.ZERO;
            for (ActivityItemRespDto skuDto : itemDtos) {
                PromotionActivitySkuDto sku = new PromotionActivitySkuDto();
                sku.setActivityStock(skuDto.getOriginalStock());
                applicableActivityItemDto.setActivityStock(skuDto.getOriginalStock());
                applicableActivityItemDto.setRemainingStock(skuDto.getActivityStock());
                if (1 == promotionMethod) {
                    sku.setPromotionPrice(skuDto.getActivityPrice());
                }
                sku.setItemId(skuDto.getItemId());
                sku.setSkuId(skuDto.getSkuId());
                sku.setDiscount(((SeckillItem)seckillItems.get(0)).getDiscount());
                itemDetail.getSkuList().stream().filter(skuRespDto -> skuRespDto.getId().equals(skuDto.getSkuId())).findFirst().ifPresent(itemSku -> {
                    if (null != itemSku.getAttrMap()) {
                        String skuName = StringUtils.join(itemSku.getAttrMap().values(), (String)" ");
                        sku.setSkuName(skuName);
                        applicableActivityItemDto.setSkuDesc(skuName);
                        applicableActivityItemDto.setAttr(skuName);
                    }
                });
                BigDecimal price = itemService.queryItemPrice(shopId, skuDto.getItemId(), skuDto.getSkuId());
                if (null != price && price.compareTo(minPrice) == -1) {
                    minPrice = price;
                }
                sku.setRetailPrice(price);
                Long stock = itemService.queryVirStorage(shopId, null, skuDto.getSkuId());
                sku.setStock(stock);
                totalStock = totalStock + stock;
                skus.add(sku);
            }
            applicableActivityItemDto.setSkus((List)skus);
            applicableActivityItemDto.setTotalStock(totalStock);
            applicableActivityItemDto.setSellPrice(minPrice);
            groupActivityItemDtos.add(applicableActivityItemDto);
            seckillActivityDto.setActivityItems(groupActivityItemDtos);
        });
    }
}

