/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.rest;

import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityAuditReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityListRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.module.marketing.api.IActivityService;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ActivityAuthItemReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.group.ActivityQueryReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.group.PageEditActivityReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.ActivityListQueryRespDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CustomerNotAuthItemResp;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8425\u9500\u7ec4\u4ef6\uff1a\u6d3b\u52a8\u670d\u52a1"})
@Validated
@RestController
@RequestMapping(value={"/v1/marketing/activity"})
public class ActivityRest {
    @Resource
    private IActivityService activityService;

    @ApiOperation(value="\u5220\u9664\u6d3b\u52a8", notes="\u672a\u5f00\u59cb\u6d3b\u52a8\u53ef\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    RestResponse<Void> delete(@PathVariable(value="id") Long id) {
        this.activityService.delete(id);
        return new RestResponse();
    }

    @ApiOperation(value="\u7ed3\u675f\u6d3b\u52a8", notes="\u624b\u52a8\u7ed3\u675f\u6d3b\u52a8\uff0c\u64cd\u4f5c\u4e0d\u53ef\u9006")
    @PutMapping(value={"/{id}/closure"})
    RestResponse<Void> closure(@PathVariable(value="id") Long id) {
        this.activityService.finish(id);
        return new RestResponse();
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u5217\u8868")
    @GetMapping(value={"/list"})
    RestResponse<PageInfo<ActivityListQueryRespDto>> queryByPage(ActivityQueryReqDto activityQueryReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse((Object)this.activityService.queryActivityByPage(activityQueryReqDto, pageNum, pageSize));
    }

    @GetMapping(value={"/pageByTemplate"})
    @ApiOperation(value="\u6839\u636e\u6a21\u677fid\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u5217\u8868", notes="\u6839\u636e\u6a21\u677fid\u5206\u9875\u67e5\u8be2\u6d3b\u52a8\u5217\u8868")
    RestResponse<PageInfo<ActivityRespDto>> pageByTemplate(@ModelAttribute ActivityDto queryDto, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="100") Integer pageSize) {
        if (null == queryDto.getActivityTemplateId()) {
            throw new BizException("\u6d3b\u52a8\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PageInfo pageInfo = this.activityService.queryActivityPage(queryDto, pageNum, pageSize);
        return new RestResponse((Object)pageInfo);
    }

    @ApiOperation(value="\u5ba1\u6838\u6d3b\u52a8", notes="\u5ba1\u6838\u6d3b\u52a8")
    @PostMapping(value={"/{id}/audit"})
    RestResponse<Void> audit(@PathVariable(value="id") Long id, @RequestBody ActivityAuditReqDto activityAuditReqDto) {
        this.activityService.audit(id, activityAuditReqDto);
        return new RestResponse();
    }

    @ApiOperation(value="\u88c5\u4fee\u9875\u9762\u7ec4\u4ef6\u81ea\u52a8\u83b7\u53d6\u6d3b\u52a8")
    @GetMapping(value={"/pageEdit"})
    RestResponse<ActivityListRespDto> queryActivity(@ModelAttribute PageEditActivityReqDto pageEditActivityReqDto) {
        return new RestResponse((Object)this.activityService.queryActivity(pageEditActivityReqDto));
    }

    @GetMapping(value={"/stock-type"})
    @ApiOperation(value="\u83b7\u53d6\u6d3b\u52a8\u5e93\u5b58\u7b56\u7565", notes="\u83b7\u53d6\u6d3b\u52a8\u5e93\u5b58\u7b56\u7565\uff081\u9884\u5360\u5546\u54c1\u5e93\u5b58 2\u72ec\u7acb\u6d3b\u52a8\u5e93\u5b58 3\u5171\u4eab\u5546\u54c1\u5e93\u5b58\uff09")
    RestResponse<Integer> queryActivityStockType() {
        return new RestResponse((Object)this.activityService.queryActivityStockType());
    }

    @PostMapping(value={"/checkCustomerAuthItemStatus"})
    @ApiOperation(value="\u68c0\u67e5\u5ba2\u6237\u6388\u6743\u5546\u54c1\u72b6\u6001", notes="\u68c0\u67e5\u5ba2\u6237\u6388\u6743\u5546\u54c1\u72b6\u6001")
    RestResponse<List<CustomerNotAuthItemResp>> checkCustomerAuthItemStatus(@RequestBody ActivityAuthItemReqDto activityAuthItemReqDto) {
        return new RestResponse((Object)this.activityService.checkCustomerAuthItemStatus(activityAuthItemReqDto));
    }

    @PutMapping(value={"/ext/pause/{id}"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u6d3b\u52a8id\u6682\u505c\u6d3b\u52a8", notes="\u6682\u505c\u6d3b\u52a8")
    RestResponse<String> pauseExtById(@PathVariable(value="id") Long id) {
        return this.activityService.pauseExtById(id);
    }

    @PutMapping(value={"/enable/{id}"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u6d3b\u52a8id\u6682\u505c\u6d3b\u52a8", notes="\u6682\u505c\u6d3b\u52a8")
    RestResponse<String> enableById(@PathVariable(value="id") Long id) {
        return this.activityService.enableById(id);
    }
}

