/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.biz.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.module.context.api.IAppContext;
import com.dtyunxi.yundt.module.context.biz.impl.CenterRequestPreProcessService;
import com.dtyunxi.yundt.module.context.biz.impl.CenterTokenVerificationService;
import com.dtyunxi.yundt.module.context.common.callback.IAccessTokenCallBack;
import com.dtyunxi.yundt.module.context.common.config.ContextConfig;
import com.dtyunxi.yundt.module.context.common.impl.TokenVerificationService;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AccessTokenInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenInterceptor.class);
    private CenterTokenVerificationService tokenVerificationService;
    private CenterRequestPreProcessService requestPreProcessService;
    private ContextConfig contextConfigProperties;

    public boolean preHandle(final HttpServletRequest request, final HttpServletResponse response, Object handler) throws Exception {
        if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
            return true;
        }
        if (this.contextConfigProperties == null || !this.contextConfigProperties.getValidateAccessToken().booleanValue()) {
            logger.debug("token\u9a8c\u8bc1\u672a\u6253\u5f00");
            return true;
        }
        if (this.requestPreProcessService.serviceCallWhiteList(request.getRemoteHost())) {
            return true;
        }
        IAccessTokenCallBack<Boolean> accessTokenCallBack = new IAccessTokenCallBack<Boolean>(){

            public String getAccessToken() {
                String accessToken = request.getHeader("Access-Token");
                ServiceContext.getContext().setAttachment("Access-Token", accessToken);
                return accessToken;
            }

            public String getRequestURI() {
                return request.getRequestURI();
            }

            public void writeOut() {
                response.setStatus(HttpStatus.UNAUTHORIZED.value());
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                PrintWriter out = null;
                try {
                    out = response.getWriter();
                }
                catch (IOException e) {
                    logger.info("\u8ba4\u8bc1\u54cd\u5e94\u6d41IO\u5f02\u5e38:", (Throwable)e);
                }
                out.append(TokenVerificationService.getRespResult());
            }

            public Boolean isValidRemote(String accessToken) {
                boolean isValid = ((IAppContext)SpringBeanUtil.getBean(IAppContext.class)).isValid(accessToken);
                if (isValid) {
                    logger.debug("\u901a\u8fc7\u8ba4\u8bc1\u4e2d\u5fc3\u6821\u9a8ctoken\u6821\u9a8c\u901a\u8fc7");
                    return true;
                }
                this.writeOut();
                return false;
            }
        };
        return (Boolean)this.tokenVerificationService.verify((IAccessTokenCallBack)accessTokenCallBack);
    }

    public void setTokenVerificationService(CenterTokenVerificationService tokenVerificationService) {
        this.tokenVerificationService = tokenVerificationService;
    }

    public void setRequestPreProcessService(CenterRequestPreProcessService requestPreProcessService) {
        this.requestPreProcessService = requestPreProcessService;
    }

    public void setContextConfig(ContextConfig contextConfigProperties) {
        this.contextConfigProperties = contextConfigProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            super.afterCompletion(request, response, handler, ex);
        }
        finally {
            ServiceContext.getContext().removeAttachmentContext();
            ServiceContext.removeContext();
        }
    }
}

