/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.biz.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.cube.utils.TokenUtil;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.ITokenApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.application.ApplicationBatchQueryDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IApplicationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IAppContext;
import com.dtyunxi.yundt.module.context.biz.impl.CenterRequestPreProcessService;
import com.dtyunxi.yundt.module.context.biz.impl.ContextImpl;
import com.dtyunxi.yundt.module.context.bo.ContextInfo;
import com.dtyunxi.yundt.module.context.bo.Token;
import com.dtyunxi.yundt.module.context.common.dto.RequestApp;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AppContextImpl
extends ContextImpl
implements IAppContext {
    private static final Logger logger = LoggerFactory.getLogger(AppContextImpl.class);
    private static final Map<String, Object> contextInstanceMap = new HashMap<String, Object>();
    @Resource
    private IApplicationQueryApi applicationQueryApi;
    @Resource
    private IAccessQueryApi accessQueryApi;
    @Resource
    private ITokenApi tokenApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Autowired
    private CenterRequestPreProcessService requestPreProcessService;

    public Integer userType() {
        Long userId = this.userId();
        UserDto userDto = (UserDto)this.userQueryApi.queryById(userId, null).getData();
        return userDto.getUserType();
    }

    private AppInstanceDto getAppInstance() {
        ApplicationBatchQueryDto applicationBatchQueryDto;
        ServiceContext context = ServiceContext.getContext();
        String applicationKey = context.getAttachment("Application-Key");
        String hostName = context.getAttachment("X-Real-Hostname");
        logger.debug("-------------getAppInstance, applicationKey:{}, X-Real-Hostname:{} ---------------", (Object)applicationKey, (Object)hostName);
        int getType = 1;
        AppInstanceDto appInstanceDto = null;
        if (StringUtils.isNotBlank((CharSequence)applicationKey)) {
            applicationBatchQueryDto = new ApplicationBatchQueryDto();
            applicationBatchQueryDto.setApplicationKey(applicationKey);
            appInstanceDto = this.getByInstanceKey(applicationKey, applicationBatchQueryDto);
        }
        if (null == appInstanceDto && StringUtils.isNotBlank((CharSequence)hostName)) {
            getType = 2;
            applicationBatchQueryDto = new ApplicationBatchQueryDto();
            applicationBatchQueryDto.setxRealHostname(hostName);
            appInstanceDto = this.getByInstanceKey(hostName, applicationBatchQueryDto);
        }
        if (null != appInstanceDto) {
            logger.debug("-------------\u6839\u636e{}\u83b7\u53d6\u5b9e\u4f8b---------------", (Object)(getType == 1 ? "Application-Key" : "X-Real-Hostname"));
            contextInstanceMap.put(getType == 1 ? applicationKey : hostName, appInstanceDto);
        }
        return appInstanceDto;
    }

    private AppInstanceDto getByInstanceKey(String instanceKey, ApplicationBatchQueryDto applicationBatchQueryDto) {
        AppInstanceDto appInstance = null;
        if (StringUtils.isBlank((CharSequence)instanceKey)) {
            return null;
        }
        appInstance = (AppInstanceDto)contextInstanceMap.get(instanceKey);
        if (null == appInstance) {
            appInstance = (AppInstanceDto)this.applicationQueryApi.findByHostnameInOneTime(applicationBatchQueryDto).getData();
        }
        return appInstance;
    }

    public ContextInfo getByHostName(String hostName) {
        ContextInfo contextInfo = null;
        ApplicationBatchQueryDto applicationBatchQueryDto = new ApplicationBatchQueryDto();
        applicationBatchQueryDto.setxRealHostname(hostName);
        AppInstanceDto appInstance = this.getByInstanceKey(hostName, applicationBatchQueryDto);
        if (null != appInstance) {
            contextInfo = this.getContextInfo(appInstance);
        }
        logger.debug("hostName:{}, contextInfo:{}", (Object)hostName, (Object)contextInfo);
        return contextInfo;
    }

    public ContextInfo getByAppKey(String applicationKey) {
        ContextInfo contextInfo = null;
        ApplicationBatchQueryDto applicationBatchQueryDto = new ApplicationBatchQueryDto();
        applicationBatchQueryDto.setApplicationKey(applicationKey);
        AppInstanceDto appInstance = this.getByInstanceKey(applicationKey, applicationBatchQueryDto);
        if (null != appInstance) {
            contextInfo = this.getContextInfo(appInstance);
        }
        logger.debug("applicationKey:{}, contextInfo:{}", (Object)applicationKey, (Object)contextInfo);
        return contextInfo;
    }

    private ContextInfo getContextInfo(AppInstanceDto appInstanceDto) {
        ContextInfo contextInfo = new ContextInfo();
        contextInfo.setInstanceId(appInstanceDto.getId());
        contextInfo.setTenantId(appInstanceDto.getTenantId());
        contextInfo.setApplicationId(appInstanceDto.getApplicationId());
        return contextInfo;
    }

    public Boolean isValid(String accessToken) {
        Map checkResult = null;
        RestResponse restResponse = this.tokenApi.checkToken(accessToken);
        if (ExceptionCode.SUCCESS.getCode().equals(restResponse.getResultCode())) {
            checkResult = (Map)restResponse.getData();
        }
        return checkResult != null;
    }

    public Token parse(String accessToken) {
        Token token = null;
        Map parseMap = TokenUtil.parse((String)accessToken);
        if (null != parseMap) {
            token = new Token();
            ObjectHelper.mapToBean((Map)parseMap, (Object)token);
            Long userId = (Long)parseMap.get("id");
            Integer expireTime = (Integer)parseMap.get("exp");
            token.setUserId(userId);
            token.setExpireTime(Long.valueOf(expireTime.longValue()));
        }
        return token;
    }

    public UserAccessVo findUserAccess() {
        Long userId = this.userId();
        try {
            RestResponse response;
            AppInstanceDto appInstanceDto = this.getAppInstance();
            if (null != appInstanceDto && null != (response = this.accessQueryApi.queryUserAccess(appInstanceDto.getId(), userId, "{}")) && "0".equals(response.getResultCode())) {
                return (UserAccessVo)response.getData();
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return null;
    }

    public RequestApp recognizeApp(String remoteIp, String requestUrl, String applicationKey, String xRealHostname, String referer, String apiPath) {
        RequestApp requestApp = (RequestApp)this.requestPreProcessService.recognizeRequestApp(ServiceContext.getContext(), remoteIp, requestUrl, applicationKey, xRealHostname, referer, apiPath);
        if (requestApp != null) {
            ServiceContext.getContext().set("yes.req.applicationId", requestApp.getReqAppId() == null ? null : requestApp.getReqAppId().toString());
            ServiceContext.getContext().set("yes.req.instanceId", requestApp.getReqInstanceId() == null ? null : requestApp.getReqInstanceId().toString());
            ServiceContext.getContext().set("yes.req.tenantId", requestApp.getReqTenantId().toString() == null ? null : requestApp.getReqTenantId().toString());
        }
        return requestApp;
    }
}

