/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.credit.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditAccountApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditRecordApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditUsageRecordApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.ConfigAccountSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.ConfigBindAccountReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditCustomerAccountItemReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditCustomerAccountReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRecordReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRecordSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditAccountBaseRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditCustomerAccountDetailRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditRecordPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditUsageRecordRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditAccountQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditRecordQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditUsageRecordQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.DateTimeUtils;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.credit.api.ICreditAccount;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CreditAccountImpl
implements ICreditAccount {
    private static Logger logger = LoggerFactory.getLogger(CreditAccountImpl.class);
    @Resource
    private ICreditAccountQueryApi creditAccountQueryApi;
    @Resource
    private IItemQueryApi iItemQueryApi;
    @Resource
    private ICreditUsageRecordQueryApi iCreditUsageRecordQueryApi;
    @Resource
    private ICreditUsageRecordApi iCreditUsageRecordApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ICreditAccountApi creditAccountApi;
    @Resource
    private ICreditRecordQueryApi iCreditRecordQueryApi;
    @Resource
    private ICreditRecordApi iCreditRecordApi;
    @Resource
    private IContext context;
    @Value(value="${credit.defualt.defaultDirId:1288630386802423099}")
    private String defaultDirId;

    public PageInfo<CreditAccountBaseRespDto> queryConfigByPage(ConfigAccountSearchReqDto searchReqDto) {
        RestResponse restResponse = this.creditAccountQueryApi.queryConfigByPage(searchReqDto);
        if (!"0".equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultMsg());
        }
        return (PageInfo)restResponse.getData();
    }

    public void batchBindConfig(ConfigBindAccountReqDto configBindAccountReqDto) {
        RestResponse restResponse = this.creditAccountApi.batchBindConfig(configBindAccountReqDto);
        if (!"0".equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultMsg());
        }
    }

    public void batchRemoveBindConfig(ConfigBindAccountReqDto configBindAccountReqDto) {
        RestResponse restResponse = this.creditAccountApi.batchRemoveBindConfig(configBindAccountReqDto);
        if (!"0".equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultMsg());
        }
    }

    public void updateAccountStatus(Long id, Integer status) {
        RestResponse restResponse = this.creditAccountApi.updateAccountStatus(id, status);
        if (!"0".equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultMsg());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCreditCountQuotaSecheduler() {
        ArrayList list;
        CreditRecordSearchReqDto creditRecordSearchReqDto = new CreditRecordSearchReqDto();
        Date date = new Date();
        creditRecordSearchReqDto.setNow(DateTimeUtils.convertDateToString((Date)date));
        Long totalNum = 0L;
        int page = 1;
        do {
            RestResponse pageInfoRestResponse;
            PageInfo data;
            list = (data = (PageInfo)(pageInfoRestResponse = this.iCreditRecordQueryApi.pageCreditRecord(creditRecordSearchReqDto, Integer.valueOf(page), Integer.valueOf(100))).getData()) != null && !CollectionUtils.isEmpty((Collection)data.getList()) ? data.getList() : new ArrayList();
            for (CreditRecordPageRespDto creditRecordPageRespDto : list) {
                CreditRecordReqDto creditRecordReqDto = new CreditRecordReqDto();
                BeanUtils.copyProperties((Object)creditRecordPageRespDto, (Object)creditRecordReqDto);
                String cacheKey = "credit_quota_scheduler_creditRecordCode:" + creditRecordPageRespDto.getCreditRecordCode();
                try {
                    boolean isSuccess = this.cacheService.add(cacheKey, (Object)"1", 30);
                    if (!isSuccess) {
                        logger.info("\u65e0\u6cd5\u83b7\u53d6\u62c9\u53d6\u4fe1\u7528\u91d1\u989d\u914d\u7f6e\u9501");
                        return;
                    }
                    this.iCreditRecordApi.dealQuotaOver(creditRecordReqDto);
                }
                catch (Exception e) {
                    logger.info("\u4fe1\u7528\u91d1\u989d\u8ba1\u7b97\u5931\u8d25,data----:" + JSONObject.toJSONString((Object)creditRecordReqDto));
                    logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
                }
                finally {
                    this.cacheService.delCache(cacheKey);
                }
            }
            ++page;
            totalNum = totalNum + (long)list.size();
        } while (list.size() > 0);
        logger.info("\u672c\u6b21\u626b\u63cf\u8ba2\u5355\u603b\u6570\uff1a{}", (Object)totalNum);
    }

    public void releaseFailOrderQuota() {
        List list;
        Long totalNum = 0L;
        int page = 1;
        do {
            RestResponse listRestResponse;
            list = !CollectionUtils.isEmpty((Collection)(list = (List)(listRestResponse = this.iCreditUsageRecordQueryApi.queryFailRecordList()).getData())) ? list : new ArrayList();
            for (CreditUsageRecordRespDto creditRecordPageRespDto : list) {
                try {
                    this.iCreditUsageRecordApi.dealQuotaOver(creditRecordPageRespDto);
                }
                catch (Exception e) {
                    logger.info("\u4fe1\u7528\u91d1\u989d\u8ba1\u7b97\u5931\u8d25,data----:" + JSONObject.toJSONString((Object)creditRecordPageRespDto));
                    logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
                }
            }
            ++page;
            totalNum = totalNum + (long)list.size();
        } while (list.size() > 0);
        logger.info("\u672c\u6b21\u626b\u63cf\u8ba2\u5355\u603b\u6570\uff1a{}", (Object)totalNum);
    }

    public CreditCustomerAccountDetailRespDto findCustomerAccount(CreditCustomerAccountReqDto creditCustomerAccountReqDto) {
        CreditCustomerAccountDetailRespDto creditCustomerAccountDetailRespDto = new CreditCustomerAccountDetailRespDto();
        if (CollectionUtils.isEmpty((Collection)creditCustomerAccountReqDto.getCreditCustomerAccountItemReqDtoList())) {
            creditCustomerAccountDetailRespDto.setMessage("\u7f3a\u5c11\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
            return creditCustomerAccountDetailRespDto;
        }
        List collect = creditCustomerAccountReqDto.getCreditCustomerAccountItemReqDtoList().stream().map(CreditCustomerAccountItemReqDto::getItemId).collect(Collectors.toList());
        for (CreditCustomerAccountItemReqDto creditCustomerAccountItemReqDto : creditCustomerAccountReqDto.getCreditCustomerAccountItemReqDtoList()) {
            creditCustomerAccountItemReqDto.setDim2IdValue(this.defaultDirId);
        }
        RestResponse customerAccount = this.creditAccountQueryApi.findCustomerAccount(creditCustomerAccountReqDto);
        return (CreditCustomerAccountDetailRespDto)RestResponseHelper.extractData((RestResponse)customerAccount);
    }
}

