/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.credit.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditDimValueApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditDimValueReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditDimValueSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.PageDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditDimValueInfoRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditDimValueRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditDimValueQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfSkuSearchReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirShelfItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvTreeReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvTreeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.credit.api.ICreditDim;
import com.dtyunxi.yundt.module.credit.dto.CreditDimPropDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CreditDimImpl
implements ICreditDim {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private ICreditDimValueApi creditDimValueApi;
    @Resource
    private ICreditDimValueQueryApi creditDimValueQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IContext context;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    private static final int LAYER = 8;

    public List<CreditDimPropDto> queryDirPropByIds(List<String> ids) {
        this.logger.info("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u7c7b\u76ee\u672b\u7ea7\u8282\u70b9\u7684\u7c7b\u76ee\u4fe1\u606f\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(ids));
        ArrayList list = Lists.newArrayList();
        JSONObject sjon = new JSONObject();
        sjon.put("instanceId", (Object)this.context.instanceId());
        sjon.put("tenantId", (Object)this.context.tenantId());
        List data = (List)this.directoryQueryApi.queryDirectoryItem(sjon.toJSONString()).getData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            return list;
        }
        this.logger.info("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u7c7b\u76ee\u672b\u7ea7\u8282\u70b9\u7684\u7c7b\u76ee\u4fe1\u606f\uff0c\u7c7b\u76ee\u6570\u91cf\uff1a{}", (Object)data.size());
        Iterator<String> iterator = ids.iterator();
        block0: while (iterator.hasNext()) {
            String id = iterator.next();
            for (DirectoryItemRespDto directoryItemRespDto : data) {
                if (!id.equals(directoryItemRespDto.getParentId().toString())) continue;
                iterator.remove();
                continue block0;
            }
        }
        this.logger.info("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u7c7b\u76ee\u672b\u7ea7\u8282\u70b9\u7684\u7c7b\u76ee\u4fe1\u606f\uff0c\u672b\u7ea7\u7c7b\u76eeid\uff1a{}", (Object)JSON.toJSONString(ids));
        if (CollectionUtils.isEmpty(ids)) {
            return list;
        }
        this.joinDirName(ids, list, data);
        return list;
    }

    private void joinDirName(List<String> ids, List<CreditDimPropDto> list, List<DirectoryItemRespDto> data) {
        CreditDimPropDto creditDimPropDto;
        HashMap<String, CreditDimPropDto> map = new HashMap<String, CreditDimPropDto>(ids.size());
        for (String id : ids) {
            map.put(id, null);
        }
        for (DirectoryItemRespDto directoryItemRespDto : data) {
            if (!map.containsKey(directoryItemRespDto.getId().toString())) continue;
            creditDimPropDto = new CreditDimPropDto();
            BeanUtils.copyProperties((Object)directoryItemRespDto, (Object)creditDimPropDto);
            map.put(directoryItemRespDto.getId().toString(), creditDimPropDto);
        }
        for (String id : map.keySet()) {
            creditDimPropDto = (CreditDimPropDto)map.get(id);
            if (null == creditDimPropDto) continue;
            Long parentId = creditDimPropDto.getParentId();
            StringBuilder name = new StringBuilder();
            name.append(creditDimPropDto.getName());
            int i = 0;
            while (!parentId.equals(0L) && i < 8) {
                for (DirectoryItemRespDto directoryItemRespDto : data) {
                    if (!parentId.equals(directoryItemRespDto.getId())) continue;
                    name.insert(0, directoryItemRespDto.getName() + ">");
                    parentId = directoryItemRespDto.getParentId();
                    break;
                }
                this.logger.info("\u904d\u5386\u6b21\u6570\uff1a{}", (Object)(++i));
            }
            creditDimPropDto.setName(String.valueOf(name));
            list.add(creditDimPropDto);
        }
    }

    public Collection<CreditDimPropDto> queryOrganizationPropByIds(List<String> ids) {
        this.logger.info("\u6279\u91cf\u67e5\u8be2\u7ec4\u7ec7\u7c7b\u76ee\u672b\u7ea7\u8282\u70b9\u7684\u7c7b\u76ee\u4fe1\u606f\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(ids));
        OrgAdvTreeReqDto orgAdvTreeReqDto = new OrgAdvTreeReqDto();
        orgAdvTreeReqDto.setType("2");
        orgAdvTreeReqDto.setTenantId(this.context.tenantId());
        RestResponse orgAdvTreeRespDtoRestResponse = this.organizationQueryExtApi.queryTree(orgAdvTreeReqDto);
        OrgAdvTreeRespDto orgAdvTreeRespDto = (OrgAdvTreeRespDto)RestResponseHelper.extractData((RestResponse)orgAdvTreeRespDtoRestResponse);
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u6811\u4fe1\u606f\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)orgAdvTreeRespDto));
        HashMap<Long, CreditDimPropDto> result = new HashMap<Long, CreditDimPropDto>();
        if (orgAdvTreeRespDto != null) {
            this.getOrgDimProps(ids, orgAdvTreeRespDto, result);
        }
        return result.values();
    }

    private void getOrgDimProps(List<String> ids, OrgAdvTreeRespDto orgAdvTreeRespDto, Map<Long, CreditDimPropDto> result) {
        if (result == null) {
            result = new HashMap<Long, CreditDimPropDto>();
        }
        List children = orgAdvTreeRespDto.getChildren();
        if (ids.contains(orgAdvTreeRespDto.getId().toString())) {
            if (orgAdvTreeRespDto.getParentId() != null && result.keySet().contains(orgAdvTreeRespDto.getParentId())) {
                result.remove(orgAdvTreeRespDto.getParentId());
            }
            CreditDimPropDto creditDimPropDto = new CreditDimPropDto();
            creditDimPropDto.setId(orgAdvTreeRespDto.getId());
            creditDimPropDto.setCode(orgAdvTreeRespDto.getCode());
            creditDimPropDto.setName(orgAdvTreeRespDto.getName());
            creditDimPropDto.setStatus(Integer.valueOf(1));
            creditDimPropDto.setIsLastStage(Integer.valueOf(CollectionUtils.isNotEmpty((Collection)children) ? 1 : 0));
            if (orgAdvTreeRespDto.getParentId() != null) {
                creditDimPropDto.setParentId(orgAdvTreeRespDto.getParentId());
            } else {
                creditDimPropDto.setParentId(Long.valueOf(-1L));
            }
            result.put(orgAdvTreeRespDto.getId(), creditDimPropDto);
            ids.remove(orgAdvTreeRespDto.getId().toString());
        }
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            for (OrgAdvTreeRespDto child : children) {
                child.setParentId(orgAdvTreeRespDto.getId());
                child.setName(orgAdvTreeRespDto.getName() + ">" + child.getName());
                this.getOrgDimProps(ids, child, result);
            }
        }
    }

    public List<DirShelfItemRespDto> queryByDirId(Long dirId, String name) {
        this.logger.info("\u6839\u636e\u540e\u53f0\u7c7b\u76eeid\uff0c\u67e5\u8be2\u7c7b\u76ee\u4e0b\u7684\u4e0a\u67b6\u5546\u54c1sku\u57fa\u7840\u4fe1\u606f\uff0c\u5165\u53c2\uff1adirId\uff1a{}\uff0cname:{}", (Object)dirId, (Object)name);
        RestResponse restResponse = this.itemSkuQueryApi.queryByDirId(dirId, name);
        this.logger.info("\u6839\u636e\u540e\u53f0\u7c7b\u76eeid\uff0c\u67e5\u8be2\u7c7b\u76ee\u4e0b\u7684\u4e0a\u67b6\u5546\u54c1sku\u57fa\u7840\u4fe1\u606f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
        if (!"0".equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultMsg());
        }
        return (List)restResponse.getData();
    }

    public PageInfo<DirShelfItemRespDto> querySkuPageByDirId(ItemShelfSkuSearchReqDto itemShelfSkuSearchReqDto) {
        this.logger.info("\u6839\u636e\u540e\u53f0\u7c7b\u76eeid\uff0c\u5206\u9875\u67e5\u8be2\u7c7b\u76ee\u4e0b\u7684\u4e0a\u67b6\u5546\u54c1sku\u57fa\u7840\u4fe1\u606f\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)itemShelfSkuSearchReqDto));
        RestResponse restResponse = this.itemSkuQueryApi.querySkuPageByDirId(itemShelfSkuSearchReqDto);
        this.logger.info("\u6839\u636e\u540e\u53f0\u7c7b\u76eeid\uff0c\u5206\u9875\u67e5\u8be2\u7c7b\u76ee\u4e0b\u7684\u4e0a\u67b6\u5546\u54c1sku\u57fa\u7840\u4fe1\u606f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
        if (!"0".equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultMsg());
        }
        return (PageInfo)restResponse.getData();
    }

    public OrgAdvTreeRespDto queryOrganizationTree() {
        OrgAdvTreeReqDto orgAdvTreeReqDto = new OrgAdvTreeReqDto();
        orgAdvTreeReqDto.setType("2");
        orgAdvTreeReqDto.setTenantId(this.context.tenantId());
        RestResponse orgAdvTreeRespDtoRestResponse = this.organizationQueryExtApi.queryTree(orgAdvTreeReqDto);
        OrgAdvTreeRespDto orgAdvTreeRespDto = (OrgAdvTreeRespDto)RestResponseHelper.extractData((RestResponse)orgAdvTreeRespDtoRestResponse);
        return orgAdvTreeRespDto;
    }

    private CreditDimPropDto buildData(OrganizationDto data) {
        CreditDimPropDto creditDimPropDto = new CreditDimPropDto();
        BeanUtils.copyProperties((Object)data, (Object)creditDimPropDto);
        return creditDimPropDto;
    }

    public Long add(CreditDimValueReqDto dto) {
        this.logger.info("\u65b0\u589e\u6388\u4fe1\u7ef4\u5ea6\u503c\u5185\u5bb9\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        RestResponse restResponse = this.creditDimValueApi.add((Object)dto);
        this.validBack(restResponse.getResultCode(), restResponse.getResultMsg());
        return (Long)restResponse.getData();
    }

    public void enable(Long aLong) {
    }

    public void disable(Long aLong) {
    }

    public void edit(Long id, CreditDimValueReqDto dto) {
        RestResponse restResponse = this.creditDimValueApi.edit((Object)id, (Object)dto);
        this.validBack(restResponse.getResultCode(), restResponse.getResultMsg());
    }

    public void delete(Long id) {
        RestResponse restResponse = this.creditDimValueApi.delete((Object)id);
        this.validBack(restResponse.getResultCode(), restResponse.getResultMsg());
    }

    private void validBack(String resultCode, String resultMsg) {
        if (!"0".equals(resultCode)) {
            throw new BizException(resultMsg);
        }
    }

    public PageInfo<CreditDimValueRespDto> queryPage(CreditDimValueSearchReqDto creditDimValueSearchReqDto) {
        RestResponse restResponse = this.creditDimValueQueryApi.queryPage((PageDto)creditDimValueSearchReqDto);
        this.validBack(restResponse.getResultCode(), restResponse.getResultMsg());
        return (PageInfo)restResponse.getData();
    }

    public CreditDimValueInfoRespDto getDetail(Long id) {
        RestResponse restResponse = this.creditDimValueQueryApi.getDetail(id);
        this.validBack(restResponse.getResultCode(), restResponse.getResultMsg());
        return (CreditDimValueInfoRespDto)restResponse.getData();
    }
}

