/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.credit.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditEntityApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditEntityDetailApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditAccountSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntityCustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntityDetailSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntitySaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntitySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditAccountPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditApplyPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditEntityCustomerPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditEntityPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditAccountStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditApplyStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.EntityStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.EntityTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditAccountQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditApplyQueryApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditEntityQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.credit.api.ICreditEntityService;
import com.dtyunxi.yundt.module.credit.api.dto.request.MgmtCreditEntitySaveReqDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ICreditEntityImpl
implements ICreditEntityService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICustomerQueryApi iCustomerQueryApi;
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private ICreditEntityQueryApi iCreditEntityQueryApi;
    @Resource
    private IContext iContext;
    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;
    @Resource
    private ICreditEntityApi creditEntityApi;
    @Resource
    private ICreditEntityDetailApi iCreditEntityDetailApi;
    @Resource
    private ICreditApplyQueryApi iCreditApplyQueryApi;
    @Resource
    private ICreditAccountQueryApi iCreditAccountQueryApi;

    public RestResponse<PageInfo<CreditEntityPageRespDto>> pageCreditEntity(CreditEntitySearchReqDto pageRequest, Integer pageNum, Integer pageSize) {
        pageRequest.setInstanceId(this.iContext.instanceId());
        pageRequest.setTenantId(this.iContext.tenantId());
        RestResponse pageInfoRestResponse = this.iCreditEntityQueryApi.pageCreditEntity(pageRequest, pageNum, pageSize);
        PageInfo creditEntityPageRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        return new RestResponse((Object)creditEntityPageRespDtoPageInfo);
    }

    public void addCreditEntity(List<MgmtCreditEntitySaveReqDto> mgmtCreditEntitySaveReqDtos) {
        for (MgmtCreditEntitySaveReqDto mgmtCreditEntitySaveReqDto : mgmtCreditEntitySaveReqDtos) {
            CreditEntitySaveReqDto creditEntitySaveReqDto = new CreditEntitySaveReqDto();
            BeanUtils.copyProperties((Object)mgmtCreditEntitySaveReqDto, (Object)creditEntitySaveReqDto);
            creditEntitySaveReqDto.setName(StringUtils.isBlank((CharSequence)mgmtCreditEntitySaveReqDto.getName()) ? mgmtCreditEntitySaveReqDto.getCustomerName() : mgmtCreditEntitySaveReqDto.getName());
            creditEntitySaveReqDto.setEntityStatus(EntityStatusEnum.ENABLED.getCode());
            creditEntitySaveReqDto.setType(EntityTypeEnum.CUSTOMER.getCode());
            creditEntitySaveReqDto.setId(mgmtCreditEntitySaveReqDto.getCustomerId());
            CreditEntityDetailSaveReqDto creditEntityDetailSaveReqDto = this.getCreditEntityDetailSaveReqDto(mgmtCreditEntitySaveReqDto);
            ArrayList<CreditEntityDetailSaveReqDto> list = new ArrayList<CreditEntityDetailSaveReqDto>();
            list.add(creditEntityDetailSaveReqDto);
            creditEntitySaveReqDto.setCreditList(list);
            RestResponse longRestResponse = this.creditEntityApi.addCustomerCreditEntity(creditEntitySaveReqDto);
            RestResponseHelper.extractData((RestResponse)longRestResponse);
        }
    }

    public RestResponse<PageInfo<CreditEntityCustomerPageRespDto>> pageCreditEntityCustomer(CreditEntityCustomerSearchReqDto pageRequest, Integer pageNum, Integer pageSize) {
        pageRequest.setInstanceId(this.iContext.instanceId());
        pageRequest.setTenantId(this.iContext.tenantId());
        RestResponse pageInfoRestResponse = this.iCreditEntityQueryApi.pageCreditEntityCustomer(pageRequest, pageNum, pageSize);
        PageInfo creditEntityCustomerPageRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)creditEntityCustomerPageRespDtoPageInfo.getList())) {
            return new RestResponse((Object)new PageInfo(new ArrayList()));
        }
        List<Long> customerIds = creditEntityCustomerPageRespDtoPageInfo.getList().stream().map(CreditEntityCustomerPageRespDto::getCustomerId).collect(Collectors.toList());
        Map<Long, List<CreditAccountPageRespDto>> group = this.getCustomerAccount(customerIds);
        Map<Long, List<CreditAccountPageRespDto>> creditAccountGroup = this.getCustomerAccount(pageRequest, (PageInfo<CreditEntityCustomerPageRespDto>)creditEntityCustomerPageRespDtoPageInfo);
        for (CreditEntityCustomerPageRespDto creditEntityCustomerPageRespDto : creditEntityCustomerPageRespDtoPageInfo.getList()) {
            if (EntityTypeEnum.CREDIT_GROUP.getCode().equals(creditEntityCustomerPageRespDto.getType()) || EntityTypeEnum.SHARE_GROUP.getCode().equals(creditEntityCustomerPageRespDto.getType())) {
                creditEntityCustomerPageRespDto.setQuotaPlan(BigDecimal.ZERO);
                creditEntityCustomerPageRespDto.setQuotaUpper(BigDecimal.ZERO);
                creditEntityCustomerPageRespDto.setCustomerNum(Integer.valueOf(0));
                creditEntityCustomerPageRespDto.setQuotaPlan(BigDecimal.ZERO);
            }
            if (!EntityTypeEnum.CUSTOMER.getCode().equals(creditEntityCustomerPageRespDto.getType())) continue;
            creditEntityCustomerPageRespDto.setQuotaPlan(BigDecimal.ZERO);
            List<CreditAccountPageRespDto> creditApplyPageRespDtos = group.get(creditEntityCustomerPageRespDto.getCustomerId());
            List<CreditAccountPageRespDto> creditAccountPageRespDtos = creditAccountGroup.get(creditEntityCustomerPageRespDto.getId());
            creditEntityCustomerPageRespDto.setIsCredit(Integer.valueOf(!org.apache.commons.collections.CollectionUtils.isEmpty(creditApplyPageRespDtos) ? 1 : 2));
            creditEntityCustomerPageRespDto.setCreditAccountCode(!org.apache.commons.collections.CollectionUtils.isEmpty(creditAccountPageRespDtos) ? creditAccountPageRespDtos.get(0).getCreditAccountCode() : null);
            creditEntityCustomerPageRespDto.setCreditAccountStatus(!org.apache.commons.collections.CollectionUtils.isEmpty(creditAccountPageRespDtos) ? creditAccountPageRespDtos.get(0).getCreditAccountStatus() : null);
            creditEntityCustomerPageRespDto.setCreditAccountStatusName(!org.apache.commons.collections.CollectionUtils.isEmpty(creditAccountPageRespDtos) ? CreditAccountStatusEnum.toName((Integer)creditAccountPageRespDtos.get(0).getCreditAccountStatus()) : null);
        }
        return new RestResponse((Object)creditEntityCustomerPageRespDtoPageInfo);
    }

    private Map<Long, List<CreditAccountPageRespDto>> getCustomerAccount(CreditEntityCustomerSearchReqDto pageRequest, PageInfo<CreditEntityCustomerPageRespDto> creditEntityCustomerPageRespDtoPageInfo) {
        Map<Long, List<Object>> creditAccountGroup = new HashMap<Long, List<CreditAccountPageRespDto>>();
        if (EntityTypeEnum.CUSTOMER.getCode().equals(pageRequest.getType()) && pageRequest.getNeedFilterDim() != null && 1 == pageRequest.getNeedFilterDim()) {
            List entityIds = creditEntityCustomerPageRespDtoPageInfo.getList().stream().map(CreditEntityCustomerPageRespDto::getId).collect(Collectors.toList());
            CreditAccountSearchReqDto creditAccountSearchReqDto = new CreditAccountSearchReqDto();
            creditAccountSearchReqDto.setCreditEntityIds(entityIds);
            creditAccountSearchReqDto.setDim1Id(pageRequest.getDim1Id());
            creditAccountSearchReqDto.setDim2Id(pageRequest.getDim2Id());
            creditAccountSearchReqDto.setDim3Id(pageRequest.getDim3Id());
            RestResponse account = this.iCreditAccountQueryApi.findAccount(creditAccountSearchReqDto);
            if ("0".equals(account.getResultCode()) && !((List)account.getData()).isEmpty()) {
                List data = (List)account.getData();
                creditAccountGroup = data.stream().collect(Collectors.groupingBy(CreditAccountPageRespDto::getCreditEntityId, Collectors.toList()));
            }
        }
        return creditAccountGroup;
    }

    private Map<String, List<CreditApplyPageRespDto>> getCustomerNotFailApplyRecord(List<String> customerCodes) {
        CreditApplySearchReqDto creditApplySearchReqDto = new CreditApplySearchReqDto();
        creditApplySearchReqDto.setCreditEntityCodes(customerCodes);
        RestResponse creditApply = this.iCreditApplyQueryApi.findCreditApply(creditApplySearchReqDto);
        Map<String, List<Object>> group = new HashMap<String, List<CreditApplyPageRespDto>>();
        if ("0".equals(creditApply.getResultCode()) && !((List)creditApply.getData()).isEmpty()) {
            List data = (List)creditApply.getData();
            List creditApplyNoFail = data.stream().filter(data1 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{data1.getCreditEntityCode()}) && !CreditApplyStatusEnum.FAIL.getCode().equals(data1.getCreditApplyStatus()) && !CreditApplyStatusEnum.WAIT.getCode().equals(data1.getCreditApplyStatus())).collect(Collectors.toList());
            group = creditApplyNoFail.stream().collect(Collectors.groupingBy(CreditApplyPageRespDto::getCreditEntityCode, Collectors.toList()));
        }
        return group;
    }

    private Map<Long, List<CreditAccountPageRespDto>> getCustomerAccount(List<Long> customerIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(customerIds)) {
            return new HashMap<Long, List<CreditAccountPageRespDto>>();
        }
        CreditAccountSearchReqDto creditAccountSearchReqDto = new CreditAccountSearchReqDto();
        creditAccountSearchReqDto.setAccountIds(customerIds);
        RestResponse account = this.iCreditAccountQueryApi.queryAccountByEntityIds(creditAccountSearchReqDto);
        Map<Long, List<Object>> group = new HashMap<Long, List<CreditAccountPageRespDto>>();
        if ("0".equals(account.getResultCode()) && !((List)account.getData()).isEmpty()) {
            List data = (List)account.getData();
            group = data.stream().collect(Collectors.groupingBy(CreditAccountPageRespDto::getCreditEntityId, Collectors.toList()));
        }
        return group;
    }

    public RestResponse<PageInfo<CreditEntityCustomerPageRespDto>> pageCreditEntityGroup(CreditEntityCustomerSearchReqDto pageRequest, Integer pageNum, Integer pageSize) {
        pageRequest.setInstanceId(this.iContext.instanceId());
        pageRequest.setTenantId(this.iContext.tenantId());
        RestResponse customerIdsRestResponse = this.iCustomerExtQueryApi.queryCustomerIdsByUserId(this.iContext.userId());
        List customerIds = (List)customerIdsRestResponse.getData();
        if (CollectionUtils.isEmpty((Collection)customerIds)) {
            return null;
        }
        pageRequest.setIds(customerIds);
        RestResponse pageInfoRestResponse = this.iCreditEntityQueryApi.pageCreditEntityGroup(pageRequest, pageNum, pageSize);
        PageInfo creditEntityCustomerPageRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)creditEntityCustomerPageRespDtoPageInfo.getList())) {
            return new RestResponse((Object)new PageInfo(new ArrayList()));
        }
        try {
            for (CreditEntityCustomerPageRespDto creditEntityCustomerPageRespDto : creditEntityCustomerPageRespDtoPageInfo.getList()) {
                if (!EntityTypeEnum.CREDIT_GROUP.getCode().equals(creditEntityCustomerPageRespDto.getType())) continue;
                creditEntityCustomerPageRespDto.setQuotaPlan(BigDecimal.ZERO);
                creditEntityCustomerPageRespDto.setQuotaUpper(BigDecimal.ZERO);
                creditEntityCustomerPageRespDto.setQuotaShare(BigDecimal.ZERO);
            }
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25" + e.getMessage());
        }
        return new RestResponse((Object)creditEntityCustomerPageRespDtoPageInfo);
    }

    private CreditEntityDetailSaveReqDto getCreditEntityDetailSaveReqDto(MgmtCreditEntitySaveReqDto mgmtCreditEntitySaveReqDto) {
        CreditEntityDetailSaveReqDto creditEntityDetailSaveReqDto = new CreditEntityDetailSaveReqDto();
        BeanUtils.copyProperties((Object)mgmtCreditEntitySaveReqDto, (Object)creditEntityDetailSaveReqDto);
        return creditEntityDetailSaveReqDto;
    }

    @Nullable
    private List<CustomerRespDto> getCustomer(CreditEntityCustomerSearchReqDto creditEntityCustomerSearchReqDto) {
        List<Object> customerRespDtos = new ArrayList<CustomerRespDto>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)creditEntityCustomerSearchReqDto.getEntityIds()) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{creditEntityCustomerSearchReqDto.getKeyword()}) || !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)creditEntityCustomerSearchReqDto.getRegionCodes()) || creditEntityCustomerSearchReqDto.getStatusId() != null || !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)creditEntityCustomerSearchReqDto.getRegionIds())) {
            String s = "";
            try {
                CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
                BeanUtils.copyProperties((Object)creditEntityCustomerSearchReqDto, (Object)customerSearchReqDto);
                customerSearchReqDto.setIdList(creditEntityCustomerSearchReqDto.getEntityIds());
                s = JSON.toJSONString((Object)customerSearchReqDto);
                RestResponse listRestResponse1 = this.iCustomerQueryApi.queryByList(s);
                customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse1);
                if (org.apache.commons.collections.CollectionUtils.isEmpty(customerRespDtos)) {
                    return null;
                }
            }
            catch (Exception e) {
                this.logger.info("\u83b7\u53d6\u4fe1\u606f\u8f6c\u5316\u5931\u8d25,data----:" + JSONObject.toJSONString((Object)s));
                this.logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
            }
        }
        return customerRespDtos;
    }

    @NotNull
    private Map<String, String> getStringStringMap(List<String> regionCodeList) {
        Map<String, String> regionNameMap = new HashMap<String, String>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(regionCodeList)) {
            try {
                ArrayList sqlFilterList = Lists.newArrayList();
                sqlFilterList.add(SqlFilter.in((String)"code", (Object)StringUtils.join(regionCodeList, (String)",")));
                HashMap<String, Serializable> filterMap = new HashMap<String, Serializable>();
                filterMap.put("sqlFilters", sqlFilterList);
                filterMap.put("tenantId", this.iContext.tenantId());
                filterMap.put("instanceId", this.iContext.instanceId());
                RestResponse areaGroupRestResp = this.areaGroupQueryApi.queryByPage(JSONObject.toJSONString(filterMap), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
                PageInfo areaGroupPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)areaGroupRestResp);
                if (Objects.nonNull(areaGroupPageInfo)) {
                    regionNameMap = areaGroupPageInfo.getList().stream().collect(Collectors.toMap(AreaGroupRespDto::getCode, AreaGroupRespDto::getName));
                }
            }
            catch (Exception e) {
                this.logger.info("\u8f6c\u5316\u5931\u8d25,data----:" + JSONObject.toJSONString(regionCodeList));
                this.logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
                return regionNameMap;
            }
        }
        return regionNameMap;
    }
}

