/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.credit.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditEntityDetailApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntityDetailReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import java.lang.reflect.Type;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="CUSTOMER_UPDATE")
public class CustomerUpdateProcess
implements IMessageProcessor<CustomerRespDto> {
    private Logger logger = LoggerFactory.getLogger(CustomerUpdateProcess.class);
    @Resource
    private ICreditEntityDetailApi iCreditEntityDetailApi;

    public MessageResponse process(CustomerRespDto message) {
        this.logger.info("\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u7f16\u8f91mq\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)message));
        try {
            CreditEntityDetailReqDto creditEntityDetailReqDto = this.getCreditEntityDetailReqDto(message);
            this.iCreditEntityDetailApi.updateCreditEntityDetail(creditEntityDetailReqDto);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.info("\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u7f16\u8f91mq\u6d88\u606f\u5931\u8d25:{}", (Object)e.getMessage());
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    private CreditEntityDetailReqDto getCreditEntityDetailReqDto(CustomerRespDto message) {
        CreditEntityDetailReqDto creditEntityDetailReqDto = new CreditEntityDetailReqDto();
        creditEntityDetailReqDto.setId(message.getId());
        creditEntityDetailReqDto.setCode(message.getCode());
        creditEntityDetailReqDto.setName(message.getName());
        creditEntityDetailReqDto.setCustomerTypeName(message.getCustomerTypeName());
        creditEntityDetailReqDto.setCustomerTypeId(message.getCustomerTypeId());
        creditEntityDetailReqDto.setRegionCode(message.getRegionCode());
        creditEntityDetailReqDto.setRegion(message.getRegion());
        creditEntityDetailReqDto.setStatusId(message.getStatusId());
        creditEntityDetailReqDto.setStatusName(message.getStatusName());
        creditEntityDetailReqDto.setCustomerId(message.getId());
        creditEntityDetailReqDto.setId(message.getId());
        creditEntityDetailReqDto.setExtFields(message.getExtFields());
        return creditEntityDetailReqDto;
    }

    public boolean isDuplicationMessage(String msgId, CustomerRespDto message) {
        return false;
    }

    public Type getMsgType() {
        return null;
    }
}

