/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.credit.biz.impl.scheduler;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.DateTimeUtils;
import com.dtyunxi.yundt.module.credit.api.ICreditAccount;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class CreditQuotaScheduler {
    private static final Logger logger = LoggerFactory.getLogger(CreditQuotaScheduler.class);
    @Resource
    private ICreditAccount creditAccount;
    @Resource
    private ICacheService cacheService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRate=100000L)
    public void creditCountQuota() {
        logger.info("\u6267\u884c\u6bcf\u5929\u62c9\u53d6\u4fe1\u7528\u91d1\u989d\u4efb\u52a1\u5f00\u59cb-\u5904\u7406\u8bb0\u5f55\u8fc7\u671f\u6216\u5373\u5c06\u751f\u6548");
        Date date = new Date();
        String cacheKey = "credit_quota_scheduler" + DateTimeUtils.convertDateTimeToHoursString((Date)date);
        boolean isSuccess = this.cacheService.add(cacheKey, (Object)"1", 30);
        if (!isSuccess) {
            logger.info("\u65e0\u6cd5\u83b7\u53d6\u62c9\u53d6\u4fe1\u7528\u91d1\u989d\u914d\u7f6e\u9501");
            return;
        }
        try {
            this.creditAccount.createCreditCountQuotaSecheduler();
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u4fe1\u7528\u91d1\u989d\u5f02\u5e38{}", (Object)e.getMessage());
            logger.error("\u6267\u884c\u91d1\u989d\u914d\u7f6e\u51fa\u9519,\u9519\u8bef\u4fe1\u606f{}" + e);
        }
        finally {
            logger.info("\u5904\u7406\u4fe1\u7528\u91d1\u989d\u5b8c\u6210");
            this.cacheService.delCache(cacheKey);
        }
    }

    @Scheduled(fixedRate=180000L)
    public void releaseFailOrderQuota() {
        logger.info("\u6267\u884c\u91ca\u653e\u521b\u5efa\u5931\u8d25\u7684\u8ba2\u5355\u4fe1\u7528\u91d1\u989d\u4efb\u52a1\u5f00\u59cb-\u91ca\u653e\u521b\u5efa\u5931\u8d25\u7684\u8ba2\u5355\u5360\u7528\u7684\u989d\u5ea6");
        try {
            this.creditAccount.releaseFailOrderQuota();
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u91ca\u653e\u521b\u5efa\u5931\u8d25\u7684\u8ba2\u5355\u4fe1\u7528\u91d1\u989d\u5f02\u5e38{}", (Object)e.getMessage());
            logger.error("\u6267\u884c\u91ca\u653e\u521b\u5efa\u5931\u8d25\u7684\u8ba2\u5355\u4fe1\u7528\u91d1\u989d\u51fa\u9519,\u9519\u8bef\u4fe1\u606f{}" + e);
        }
        finally {
            logger.info("\u5904\u7406\u91ca\u653e\u521b\u5efa\u5931\u8d25\u7684\u8ba2\u5355\u4fe1\u7528\u91d1\u989d\u5b8c\u6210");
        }
    }
}

