/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.StoreReqTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.CustomerExtReqDto;
import com.dtyunxi.tcbj.api.dto.request.CustomerStoreReqDto;
import com.dtyunxi.tcbj.api.dto.request.TbPersonPartnerRelReqDto;
import com.dtyunxi.tcbj.api.dto.response.CustomerExtRespDto;
import com.dtyunxi.tcbj.api.dto.response.CustomerStoreResponseDto;
import com.dtyunxi.tcbj.api.dto.response.StoreSalesmanRelationRespDto;
import com.dtyunxi.tcbj.api.dto.response.TbPersonPartnerRelRespDto;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.tcbj.api.query.ITbPersonPartnerRelQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.ICustomerCheckRelationApi;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckRelationShowHistoryFlagEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckRelationSourceOperateTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerStatusExtEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerCheckPatternQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerCheckRelationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.PersonPartnerReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.BizImportRespDto;
import com.dtyunxi.yundt.module.customer.biz.service.IStoreCheckService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.module.customer.biz.vo.CustomerCheckRelationExportVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class IStoreCheckServiceImpl
implements IStoreCheckService {
    private static final Logger log = LoggerFactory.getLogger(IStoreCheckServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;
    @Resource
    private ICustomerCheckRelationQueryApi customerCheckRelationQueryApi;
    @Resource
    private ICustomerCheckPatternQueryApi customerCheckPatternQueryApi;
    @Resource
    private ITbPersonPartnerRelQueryApi tbPersonPartnerRelQueryApi;
    @Resource
    private ICustomerCheckRelationApi customerCheckRelationApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IContext context;

    @Override
    public PageInfo<CustomerStoreResponseDto> queryCustomerStorePage(String filter, Integer pageNum, Integer pageSize) {
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOneByOrgId(orgId));
        CustomerStoreReqDto customerStoreReqDto = (CustomerStoreReqDto)JSON.parseObject((String)filter, CustomerStoreReqDto.class);
        customerStoreReqDto.setOrgId(orgId);
        customerStoreReqDto.setMerchantId(customerRespDto.getMerchantId());
        log.info("\u67e5\u8be2\u95e8\u5e97\u5217\u8868 params => {} ", (Object)JSON.toJSONString((Object)customerStoreReqDto));
        PageInfo customerStoreResponseDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomerStorePage(JSON.toJSONString((Object)customerStoreReqDto), pageNum, pageSize));
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)customerStoreResponseDtoPageInfo.getList())) {
            return customerStoreResponseDtoPageInfo;
        }
        List storeIds = customerStoreResponseDtoPageInfo.getList().stream().map(c -> c.getStoreId()).collect(Collectors.toList());
        CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
        customerCheckRelationReqDto.setStoreIds(storeIds);
        customerCheckRelationReqDto.setOrgId(orgId);
        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        List customerCheckRelationRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerCheckRelationQueryApi.queryByStoreIds(customerCheckRelationReqDto));
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckRelationRespDtos)) {
            List salesmanIds = customerCheckRelationRespDtos.stream().map(c -> c.getSalesmanId()).collect(Collectors.toList());
            TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
            tbPersonPartnerRelReqDto.setRowIds(salesmanIds);
            tbPersonPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
            PageInfo tbPersonPartnerRelRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
            List rowIds = tbPersonPartnerRelRespDtoPageInfo.getList().stream().map(c -> c.getRowId() + c.getCustomerId()).collect(Collectors.toList());
            log.info("\u7ecf\u9500\u5546ID => {} \u5168\u91cf\u4e1a\u52a1\u5458\u6821\u9a8c\u7ed3\u679c => {}", (Object)customerRespDto.getThirdPartyId(), (Object)JSON.toJSONString(rowIds));
            Map<String, String> personMessageMap = tbPersonPartnerRelRespDtoPageInfo.getList().stream().collect(Collectors.toMap(TbPersonPartnerRelRespDto::getRowId, TbPersonPartnerRelRespDto::getFullName, (k1, k2) -> k1));
            Map<String, CustomerCheckRelationRespDto> customerCheckRelationRespDtoMap = customerCheckRelationRespDtos.stream().collect(Collectors.toMap(key -> key.getStoreId(), val -> val, (k1, k2) -> k1.getCreateTime().compareTo(k2.getCreateTime()) != 0 ? k1 : k2));
            customerStoreResponseDtoPageInfo.getList().stream().forEach(c -> {
                CustomerCheckRelationRespDto orDefault = customerCheckRelationRespDtoMap.getOrDefault(c.getStoreId(), null);
                if (null != orDefault) {
                    orDefault.setStatus(rowIds.contains(orDefault.getSalesmanId() + c.getCustomerId()) ? CustomerCheckStatusEnum.BOUND.getStatus() : CustomerCheckStatusEnum.DISABLE.getStatus());
                    orDefault.setSalesmanName(personMessageMap.getOrDefault(orDefault.getSalesmanId(), orDefault.getSalesmanName()));
                    c.setCustomerCheckRelationRespDto(orDefault);
                }
            });
        }
        CustomerCheckRelationReqDto reqDto = new CustomerCheckRelationReqDto();
        reqDto.setOrgId(orgId);
        reqDto.setStoreIds(storeIds);
        reqDto.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
        List historyList = (List)RestResponseHelper.extractData((RestResponse)this.customerCheckRelationQueryApi.queryByStoreIds(reqDto));
        if (CollectionUtils.isNotEmpty((Collection)historyList)) {
            Map<String, List<CustomerCheckRelationRespDto>> storeIdHistoryMap = historyList.stream().collect(Collectors.groupingBy(h -> h.getStoreId()));
            customerStoreResponseDtoPageInfo.getList().stream().forEach(c -> {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)storeIdHistoryMap.get(c.getStoreId())))) {
                    c.setShowHistoryFlag(CustomerCheckRelationShowHistoryFlagEnum.YES_SHOW.getType());
                }
            });
        }
        return customerStoreResponseDtoPageInfo;
    }

    @Override
    public PageInfo<StoreSalesmanRelationRespDto> queryPersonPartnerPage(String filter, Integer pageNum, Integer pageSize) {
        log.info("\u67e5\u8be2\u4e1a\u52a1\u5458\u5217\u8868 req params : {} .", (Object)filter);
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
        PersonPartnerReqDto personPartnerReqDto = (PersonPartnerReqDto)JSON.parseObject((String)filter, PersonPartnerReqDto.class);
        TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOneByOrgId(orgId));
        StoreReqTypeEnum storeReqTypeEnum = StoreReqTypeEnum.enumOfCode((Integer)personPartnerReqDto.getCustomerType());
        switch (storeReqTypeEnum) {
            case STORE: 
            case PARENT_STORE: {
                CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
                customerExtReqDto.setCreditCode(personPartnerReqDto.getCustomerCommon());
                List customerExtRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomer(customerExtReqDto));
                Optional<CustomerExtRespDto> optionalCustomerExtRespDto = customerExtRespDtos.stream().filter(c -> c.getMerchantId().equals(orgId) && CustomerStatusExtEnum.ENABLED.getCode().equals(c.getStatusId())).findAny();
                Assert.isTrue((boolean)optionalCustomerExtRespDto.isPresent(), (String)"0001", (String)"\u5f53\u524d\u95e8\u5e97\u4e0d\u5b58\u5728");
                CustomerExtRespDto customerExtRespDto = optionalCustomerExtRespDto.get();
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)customerExtRespDto.getThirdPartyId()), (String)"0001", (String)"\u5ba2\u6237\u6570\u636e\u5b58\u5728\u5f02\u5e38");
                tbPersonPartnerRelReqDto.setCustomerId(customerExtRespDto.getThirdPartyId());
                break;
            }
            case DISTRIBUTION: {
                CustomerRespDto distribution = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByCode(personPartnerReqDto.getCustomerCommon()));
                Assert.isTrue((!ObjectUtils.isEmpty((Object)distribution) ? 1 : 0) != 0, (String)"0001", (String)"\u5206\u9500\u5546\u6570\u636e\u4e0d\u5b58\u5728");
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)distribution.getThirdPartyId()), (String)"0001", (String)"\u5ba2\u6237\u6570\u636e\u5b58\u5728\u5f02\u5e38");
                Assert.isTrue((boolean)CustomerStatusExtEnum.ENABLED.getCode().equals(distribution.getStatusId()), (String)"0001", (String)"\u5ba2\u6237\u975e\u5408\u6cd5\u72b6\u6001");
                tbPersonPartnerRelReqDto.setCustomerId(distribution.getThirdPartyId());
            }
        }
        tbPersonPartnerRelReqDto.setStoreId(personPartnerReqDto.getStoreId());
        tbPersonPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
        tbPersonPartnerRelReqDto.setOrgId(orgId);
        PageInfo storeSalesmanRelationRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.querySalesmanByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), pageNum, pageSize));
        return storeSalesmanRelationRespDtoPageInfo;
    }

    @Override
    public void bindStoreAndSalesmanRelation(CustomerCheckRelationReqDto customerCheckRelationReqDto) {
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
        customerCheckRelationReqDto.setOrgId(orgId);
        RestResponseHelper.extractData((RestResponse)this.customerCheckRelationApi.bindStoreAndSalesmanRelation(customerCheckRelationReqDto));
    }

    @Override
    public RestResponse<BizImportRespDto> exportCustomerCheckRelationByExcel(MultipartFile file) throws Exception {
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        String userName = this.context.userName();
        ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), CustomerCheckRelationExportVo.class, (ImportParams)importParams);
        this.logger.info("\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)result.getList()));
        List<CustomerCheckRelationExportVo> importList = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(importList)) {
            return new RestResponse((Object)new BizImportRespDto());
        }
        ArrayList errorList = Lists.newArrayList();
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOneByOrgId(orgId));
        Assert.isTrue((boolean)org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)customerRespDto), (String)"0001", (String)"\u5f53\u524d\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        List<CustomerCheckRelationExportVo> list = this.checkBeforeImportList(customerRespDto, importList, errorList);
        List<CustomerCheckRelationReqDto> addDtoList = this.getAddDtoAndErrorList(orgId, customerRespDto, errorList, list);
        if (CollectionUtils.isNotEmpty(addDtoList)) {
            this.logger.info("\u3010{}\u3011\u89e6\u53d1\u5206\u6279\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u6570\u636e\u5bfc\u5165 count:{},content:{}", new Object[]{userName, list.size(), JSON.toJSONString(addDtoList)});
            for (CustomerCheckRelationReqDto addReqDto : addDtoList) {
                RestResponse response;
                if (CustomerCheckStatusEnum.NOT_BOUND.getStatus().equals(addReqDto.getStatus())) {
                    addReqDto.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.EXCEL.getType());
                } else {
                    addReqDto.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.MANUAL.getType());
                }
                if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)(response = this.customerCheckRelationApi.bindStoreAndSalesmanRelation(addReqDto))) || "0".equals(response.getResultCode()) || "success".equals(response.getResultMsg())) continue;
                CustomerCheckRelationExportVo errorVo = new CustomerCheckRelationExportVo();
                errorVo.setStoreNo(addReqDto.getStoreNo());
                errorVo.setSalesmanCode(addReqDto.getSalesmanCode());
                errorVo.setReason(response.getResultMsg());
                errorList.add(errorVo);
            }
        }
        this.logger.info("\u3010\u5bfc\u5165->\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u6570\u636e\u5bfc\u5165\u7ed3\u679c\u3011 \u603b\u6761\u6570\uff1a{}\uff0c\u5bfc\u5165\u5931\u8d25{}\u6761\uff0c\u5bfc\u5165\u6210\u529f{}\u6761", new Object[]{list.size(), errorList.size(), list.size() - errorList.size()});
        Integer importFailTotal = errorList.size();
        Integer importSuccessTotal = list.size() - errorList.size();
        Integer total = list.size();
        String url = "";
        this.logger.info("\u6821\u9a8c\u5f02\u5e38\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)errorList));
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            String excelName = "cube/\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u6570\u636e\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            url = EasyPoiExportUtil.getExportUrl((List)errorList, CustomerCheckRelationExportVo.class, (String)null, (String)excelName, (String)"xls");
        }
        return new RestResponse((Object)new BizImportRespDto(total, importSuccessTotal, importFailTotal, url));
    }

    private List<CustomerCheckRelationReqDto> getAddDtoAndErrorList(Long orgId, CustomerRespDto customerRespDto, List<CustomerCheckRelationExportVo> errorList, List<CustomerCheckRelationExportVo> list) {
        ArrayList addDtoList = Lists.newArrayList();
        List<CustomerCheckRelationExportVo> exportVoList = list.stream().filter(a -> StringUtils.isEmpty((CharSequence)a.getReason()) && StringUtils.isNotBlank((CharSequence)a.getStoreNo()) && StringUtils.isNotBlank((CharSequence)a.getSalesmanCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(exportVoList)) {
            List<CustomerStoreResponseDto> customerStoreResponseDtoList = this.queryCustomerStoreList(orgId, exportVoList, customerRespDto);
            if (CollectionUtils.isNotEmpty(customerStoreResponseDtoList)) {
                Map<String, List<CustomerStoreResponseDto>> customerMap = customerStoreResponseDtoList.stream().collect(Collectors.groupingBy(CustomerStoreResponseDto::getStoreNo));
                Map<String, List<TbPersonPartnerRelRespDto>> personPartnerMap = this.queryPersonPartnerMap(customerRespDto, exportVoList, errorList);
                List<CustomerCheckRelationRespDto> customerCheckRelationRespDtoList = this.getCustomerCheckRelationRespDtoList(orgId, customerStoreResponseDtoList);
                List<CustomerCheckRelationReqDto> doHandleImportList = this.doHandleImportList(errorList, orgId, exportVoList, customerMap, personPartnerMap, customerCheckRelationRespDtoList);
                addDtoList.addAll(doHandleImportList);
            } else {
                for (CustomerCheckRelationExportVo exportVo : exportVoList) {
                    exportVo.setReason("\u65e0\u5f53\u524d\u95e8\u5e97\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4");
                    errorList.add(exportVo);
                }
            }
        }
        return addDtoList;
    }

    private List<CustomerCheckRelationReqDto> doHandleImportList(List<CustomerCheckRelationExportVo> errorList, Long orgId, List<CustomerCheckRelationExportVo> exportVoList, Map<String, List<CustomerStoreResponseDto>> customerMap, Map<String, List<TbPersonPartnerRelRespDto>> personPartnerMap, List<CustomerCheckRelationRespDto> customerCheckRelationRespDtoList) {
        ArrayList addDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(customerCheckRelationRespDtoList)) {
            for (CustomerCheckRelationExportVo exportVo : exportVoList) {
                if (!StringUtils.isEmpty((CharSequence)exportVo.getReason()) || !StringUtils.isNotBlank((CharSequence)exportVo.getStoreNo()) || !StringUtils.isNotBlank((CharSequence)exportVo.getSalesmanCode())) continue;
                List<CustomerStoreResponseDto> customerStoreInfoList = customerMap.get(exportVo.getStoreNo());
                if (CollectionUtils.isEmpty(customerStoreInfoList)) {
                    exportVo.setReason("\u65e0\u5f53\u524d\u95e8\u5e97\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4");
                    errorList.add(exportVo);
                    continue;
                }
                List<TbPersonPartnerRelRespDto> personPartnerInfoList = personPartnerMap.get(exportVo.getSalesmanCode() + "-" + customerStoreInfoList.get(0).getCustomerId());
                if (CollectionUtils.isEmpty(personPartnerInfoList)) {
                    exportVo.setReason("\u672a\u7ef4\u62a4\u8be5\u4e1a\u52a1\u5458\u4eba\u5e97\u5173\u7cfb\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u505a\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u7ed1\u5b9a");
                    errorList.add(exportVo);
                    continue;
                }
                CustomerStoreResponseDto customerStoreInfo = customerStoreInfoList.get(0);
                TbPersonPartnerRelRespDto personPartnerInfo = personPartnerInfoList.get(0);
                addDtoList.add(this.getCustomerCheckRelationReqDto(orgId, customerStoreInfo, personPartnerInfo));
            }
        } else {
            Map<String, List<CustomerCheckRelationRespDto>> orgIdStoreIdRelMap = customerCheckRelationRespDtoList.stream().collect(Collectors.groupingBy(c -> c.getOrgId() + "|" + c.getStoreId()));
            for (CustomerCheckRelationExportVo exportVo : exportVoList) {
                if (!StringUtils.isEmpty((CharSequence)exportVo.getReason()) || !StringUtils.isNotBlank((CharSequence)exportVo.getStoreNo()) || !StringUtils.isNotBlank((CharSequence)exportVo.getSalesmanCode())) continue;
                List<CustomerStoreResponseDto> customerStoreInfoList = customerMap.get(exportVo.getStoreNo());
                if (CollectionUtils.isEmpty(customerStoreInfoList)) {
                    exportVo.setReason("\u65e0\u5f53\u524d\u95e8\u5e97\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4");
                    errorList.add(exportVo);
                    continue;
                }
                List<TbPersonPartnerRelRespDto> personPartnerInfoList = personPartnerMap.get(exportVo.getSalesmanCode() + "-" + customerStoreInfoList.get(0).getCustomerId());
                if (CollectionUtils.isEmpty(personPartnerInfoList)) {
                    exportVo.setReason("\u672a\u7ef4\u62a4\u8be5\u4e1a\u52a1\u5458\u4eba\u5e97\u5173\u7cfb\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u505a\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u7ed1\u5b9a ");
                    errorList.add(exportVo);
                    continue;
                }
                CustomerStoreResponseDto customerStoreInfo = customerStoreInfoList.get(0);
                TbPersonPartnerRelRespDto personPartnerInfo = personPartnerInfoList.get(0);
                List<CustomerCheckRelationRespDto> orgStoreSaleRelationList = orgIdStoreIdRelMap.get(orgId + "|" + customerStoreInfo.getStoreId());
                if (CollectionUtils.isNotEmpty(orgStoreSaleRelationList)) {
                    for (CustomerCheckRelationRespDto dto : orgStoreSaleRelationList) {
                        CustomerCheckRelationReqDto notBoundReqDto = new CustomerCheckRelationReqDto();
                        notBoundReqDto.setOrgId(orgId);
                        notBoundReqDto.setStoreId(dto.getStoreId());
                        notBoundReqDto.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
                        notBoundReqDto.setSalesmanId(dto.getSalesmanId());
                        notBoundReqDto.setThirdPartyId(customerStoreInfo.getCustomerId());
                        notBoundReqDto.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.EXCEL.getType());
                        log.info("\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u6570\u636e\u5bfc\u5165,\u5f53\u524dorgId+\u95e8\u5e97id, \u5b58\u5728\u5219\u8986\u76d6.\u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString((Object)notBoundReqDto));
                        this.customerCheckRelationApi.bindStoreAndSalesmanRelation(notBoundReqDto);
                        addDtoList.add(this.getCustomerCheckRelationReqDto(orgId, customerStoreInfo, personPartnerInfo));
                    }
                    continue;
                }
                List<TbPersonPartnerRelRespDto> personList = personPartnerMap.get(exportVo.getSalesmanCode() + "-" + customerStoreInfoList.get(0).getCustomerId());
                if (CollectionUtils.isNotEmpty(personList)) {
                    addDtoList.add(this.getCustomerCheckRelationReqDto(orgId, customerStoreInfo, personPartnerInfo));
                    continue;
                }
                exportVo.setReason("\u4eba\u5458\u4fe1\u606f\u5df2\u7ecf\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4;");
                errorList.add(exportVo);
            }
        }
        return addDtoList;
    }

    private Map<String, List<TbPersonPartnerRelRespDto>> queryPersonPartnerMap(CustomerRespDto customerRespDto, List<CustomerCheckRelationExportVo> exportVoList, List<CustomerCheckRelationExportVo> errorList) {
        List salesmanCodeList = exportVoList.stream().map(CustomerCheckRelationExportVo::getSalesmanCode).collect(Collectors.toList());
        TbPersonPartnerRelReqDto personPartnerRelReqDto = new TbPersonPartnerRelReqDto();
        personPartnerRelReqDto.setEmpNos(salesmanCodeList);
        personPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
        RestResponse personPartnerRestResponse = this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)personPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        List personPartnerList = ((PageInfo)RestResponseHelper.extractData((RestResponse)personPartnerRestResponse)).getList();
        if (CollectionUtils.isNotEmpty((Collection)personPartnerList)) {
            return personPartnerList.stream().collect(Collectors.groupingBy(p -> p.getEmpNo() + "-" + p.getCustomerId()));
        }
        for (CustomerCheckRelationExportVo exportVo : exportVoList) {
            exportVo.setReason("\u672a\u7ef4\u62a4\u8be5\u4e1a\u52a1\u5458\u4eba\u5e97\u5173\u7cfb\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u505a\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u7ed1\u5b9a");
            errorList.add(exportVo);
        }
        return new HashMap<String, List<TbPersonPartnerRelRespDto>>(16);
    }

    private List<CustomerStoreResponseDto> queryCustomerStoreList(Long orgId, List<CustomerCheckRelationExportVo> exportVoList, CustomerRespDto customerRespDto) {
        List storeNoList = exportVoList.stream().map(CustomerCheckRelationExportVo::getStoreNo).collect(Collectors.toList());
        CustomerStoreReqDto customerStoreReqDto = new CustomerStoreReqDto();
        customerStoreReqDto.setStoreNos(storeNoList);
        customerStoreReqDto.setOrgId(orgId);
        customerStoreReqDto.setMerchantId(customerRespDto.getMerchantId());
        RestResponse customerStoreResponse = this.customerDistributorsQueryApi.queryCustomerStorePage(JSON.toJSONString((Object)customerStoreReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        return ((PageInfo)RestResponseHelper.extractData((RestResponse)customerStoreResponse)).getList();
    }

    private List<CustomerCheckRelationExportVo> checkBeforeImportList(CustomerRespDto customerRespDto, List<CustomerCheckRelationExportVo> importList, List<CustomerCheckRelationExportVo> errorList) {
        CustomerCheckPatternReqDto customerCheckPatternReqDto = new CustomerCheckPatternReqDto();
        customerCheckPatternReqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerRespDto.getCode()}));
        List customerCheckPatternEos = (List)RestResponseHelper.extractData((RestResponse)this.customerCheckPatternQueryApi.selectCustomerCheckPatternByCode(customerCheckPatternReqDto));
        Assert.isTrue((!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckPatternEos) ? 1 : 0) != 0, (String)"0001", (String)"\u5f53\u524d\u5ba2\u6237\u672a\u6307\u5b9a\u8003\u6838\u65b9\u5f0f\uff01");
        for (CustomerCheckRelationExportVo vo : importList) {
            if (StringUtils.isNotBlank((CharSequence)vo.getStoreNo())) {
                vo.setStoreNo(vo.getStoreNo().trim());
            } else {
                vo.setReason("\u8bf7\u586b\u5199\u95e8\u5e97\u7f16\u7801");
                errorList.add(vo);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getSalesmanCode())) {
                vo.setSalesmanCode(vo.getSalesmanCode().trim());
                continue;
            }
            vo.setReason("\u8bf7\u586b\u5199\u4eba\u5458\u7f16\u7801");
            errorList.add(vo);
        }
        Map<String, List<CustomerCheckRelationExportVo>> importListMap = importList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getStoreNo()) && StringUtils.isNotBlank((CharSequence)a.getSalesmanCode())).collect(Collectors.groupingBy(CustomerCheckRelationExportVo::getStoreNo));
        if (importListMap.entrySet().size() > 0) {
            importListMap.forEach((key, value) -> {
                if (value.size() > 1) {
                    for (CustomerCheckRelationExportVo exportVo : value) {
                        exportVo.setReason("\u5bfc\u5165\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4");
                        errorList.add(exportVo);
                    }
                }
            });
        }
        return importList;
    }

    private List<CustomerCheckRelationRespDto> getCustomerCheckRelationRespDtoList(Long orgId, List<CustomerStoreResponseDto> customerList) {
        if (CollectionUtils.isNotEmpty(customerList)) {
            CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
            List storeIds = customerList.stream().map(CustomerStoreResponseDto::getStoreId).collect(Collectors.toList());
            customerCheckRelationReqDto.setStoreIds(storeIds);
            customerCheckRelationReqDto.setOrgId(orgId);
            customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
            return (List)RestResponseHelper.extractData((RestResponse)this.customerCheckRelationQueryApi.queryByStoreIds(customerCheckRelationReqDto));
        }
        return Lists.newArrayList();
    }

    private CustomerCheckRelationReqDto getCustomerCheckRelationReqDto(Long orgId, CustomerStoreResponseDto customerStoreInfo, TbPersonPartnerRelRespDto personPartnerInfo) {
        CustomerCheckRelationReqDto addDto = new CustomerCheckRelationReqDto();
        addDto.setStoreId(customerStoreInfo.getStoreId());
        addDto.setStoreNo(customerStoreInfo.getStoreNo());
        addDto.setSalesmanId(personPartnerInfo.getRowId());
        addDto.setSalesmanName(personPartnerInfo.getFullName());
        addDto.setSalesmanCode(personPartnerInfo.getEmpNo());
        addDto.setSalesmanType(personPartnerInfo.getRoleTypeName());
        addDto.setSalesmanPhone(personPartnerInfo.getPhoneNumber());
        addDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        addDto.setOrgId(orgId);
        addDto.setThirdPartyId(personPartnerInfo.getCustomerId());
        return addDto;
    }

    @Override
    public PageInfo<CustomerCheckRelationRespDto> queryStoreAndSalesmanRelationBindHistoryPage(String filter, Integer pageNum, Integer pageSize) {
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOneByOrgId(orgId));
        Assert.isTrue((boolean)org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)customerRespDto), (String)"0001", (String)"\u5f53\u524d\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        CustomerCheckRelationReqDto reqDto = (CustomerCheckRelationReqDto)JSON.parseObject((String)filter, CustomerCheckRelationReqDto.class);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getStoreId()), (String)"0001", (String)"\u5f53\u524d\u95e8\u5e97ID\u4e3a\u7a7a\uff01");
        reqDto.setOrgId(orgId);
        reqDto.setStoreId(reqDto.getStoreId());
        reqDto.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
        log.info("\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u5386\u53f2\u7ed1\u5b9a\u5217\u8868\u67e5\u8be2 req params : {} .", (Object)JSON.toJSONString((Object)reqDto));
        return (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerCheckRelationQueryApi.queryByPage(JSON.toJSONString((Object)reqDto), pageNum, pageSize));
    }
}

