/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CustomerExtReqDto;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.tcbj.api.query.ISaleOrderReportQueryApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.company.CompanyVerifyReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyResultDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyResultInfoDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.tcbj.center.openapi.api.query.ICompanyQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.IStoreSellerGovernApi;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsCustomerEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsDealEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreAreaLevelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreDataOriginEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreIsFirstParentEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.SettleStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerAddResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerStatusRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerStatusQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReqExtDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryProvinceReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerGovernReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerCheckPatternQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreAreaQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.ISellerExtApi;
import com.dtyunxi.yundt.cube.center.shop.api.IShopExtApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerToBReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.StatusReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationThreeApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ModifyOrganizationReqDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerExtService;
import com.dtyunxi.yundt.module.customer.api.dto.MerchantDetailRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.MerchantSearchReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.MerchantListRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.CompanyVerifyEnum;
import com.dtyunxi.yundt.module.customer.api.enums.SellerStatusEnum;
import com.dtyunxi.yundt.module.customer.biz.constant.TianyanchaProvinceEnum;
import com.dtyunxi.yundt.module.customer.biz.service.IStoreService;
import com.dtyunxi.yundt.module.customer.biz.util.BeanPropertyNullUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.ICustomerExtThreeApi;
import com.yx.tcbj.center.customer.api.dto.request.CustomerBatchUpReqDto;
import com.yx.tcbj.center.customer.api.dto.request.DrCustomersReqDto;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.customer.api.query.IStoreQueryApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="customerExtService")
public class CustomerExtServiceImpl
implements ICustomerExtService {
    private static final Logger log = LoggerFactory.getLogger(CustomerExtServiceImpl.class);
    private static Logger logger = LoggerFactory.getLogger(CustomerExtServiceImpl.class);
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;
    @Resource
    private ICustomerExtThreeApi customerExtThreeApi;
    @Resource
    private ICustomerStatusQueryApi customerStatusQueryApi;
    @Resource
    private ISellerExtApi sellerExtApi;
    @Resource
    private IStoreQueryApi storeQueryApi;
    @Resource
    private ICompanyQueryApi companyQueryApi;
    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    @Resource
    private ISaleOrderReportQueryApi saleOrderReportQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IStoreAreaQueryApi storeAreaQueryApi;
    @Resource
    private IStoreService storeService;
    @Resource
    private ICustomerCheckPatternQueryApi customerCheckPatternQueryApi;
    @Resource
    private IOrganizationThreeApi organizationThreeApi;
    @Resource
    private IShopExtApi shopExtApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IStoreSellerGovernApi storeSellerGovernApi;
    private static final List<String> VERIFY_STATE = Lists.newArrayList((Object[])new String[]{"\u6ce8\u9500", "\u540a\u9500", "\u64a4\u9500", "\u6b47\u4e1a", "\u505c\u4e1a", "\u540a\u9500\uff0c\u672a\u6ce8\u9500\u529e\u7406\u540a\u9500\u8f6c\u6ce8\u9500", "\u540a\u9500\uff0c\u5df2\u6ce8\u9500\u529e\u7406\u540a\u9500\u8f6c\u6ce8\u9500", "\u540a\u9500\uff0c\u672a\u6ce8\u9500", "\u540a\u9500\uff0c\u5df2\u6ce8\u9500"});

    public CustomerExtDetailRespDto queryById(Long id) {
        RestResponse customerRestResp = this.customerExtQueryApi.queryById(id);
        CustomerExtDetailRespDto customerRespDto = (CustomerExtDetailRespDto)RestResponseHelper.extractData((RestResponse)customerRestResp);
        if (CustomerTypeEnum.RETAILER.getCode().equals(customerRespDto.getType())) {
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setOrganizationId(customerRespDto.getMerchantId());
            RestResponse listRestResponse = this.sellerQueryApi.queryList(sellerQueryReqDto);
            List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            if (CollectionUtils.isNotEmpty((Collection)sellerRespDtos)) {
                customerRespDto.setMerchantName(((SellerRespDto)sellerRespDtos.get(0)).getName());
            }
        }
        return customerRespDto;
    }

    public PageInfo<MerchantListRespDto> queryMerchantByPage(String filter, Integer pageNum, Integer pageSize) {
        MerchantSearchReqDto searchReqDto = new MerchantSearchReqDto();
        logger.info("queryMerchantByPage params:{}", (Object)filter);
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (MerchantSearchReqDto)JSONObject.parseObject((String)filter, MerchantSearchReqDto.class);
        }
        boolean merchantSearchFlag = false;
        Map<Object, Object> sellerMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getMerchantCode()) || StringUtils.isNotEmpty((CharSequence)searchReqDto.getMerchantName())) {
            merchantSearchFlag = true;
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setCode(searchReqDto.getMerchantCode());
            sellerQueryReqDto.setName(searchReqDto.getMerchantName());
            sellerQueryReqDto.setTenantId(this.context.tenantId());
            sellerQueryReqDto.setInstanceId(this.context.instanceId());
            RestResponse listRestResponse = this.sellerQueryApi.queryList(sellerQueryReqDto);
            List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            if (CollectionUtils.isEmpty((Collection)sellerRespDtos)) {
                return new PageInfo();
            }
            List orgIds = sellerRespDtos.stream().map(SellerRespDto::getOrganizationId).collect(Collectors.toList());
            searchReqDto.setOrgInfoIds(orgIds);
            sellerMap = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getOrganizationId, o -> o, (v1, v2) -> v2));
        }
        if (Objects.isNull(searchReqDto.getSettleStatus())) {
            searchReqDto.setSettleStatusList(Arrays.asList(SettleStatusEnum.SETTLED.getCode(), SettleStatusEnum.DISABLED.getCode()));
        }
        searchReqDto.setType(CustomerTypeEnum.DEALER.getCode());
        searchReqDto.setChannel(CustomerTypeEnum.BRAND.getCode());
        RestResponse pageInfoRestResponse = this.customerExtQueryApi.queryByPage(JSON.toJSONString((Object)searchReqDto), pageNum, pageSize);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        PageInfo listRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)listRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList listRespDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            if (!merchantSearchFlag) {
                List orgIds = pageInfo.getList().stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
                SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
                sellerQueryReqDto.setOrganizationIds(orgIds);
                sellerQueryReqDto.setTenantId(this.context.tenantId());
                sellerQueryReqDto.setInstanceId(this.context.instanceId());
                RestResponse listRestResponse = this.sellerQueryApi.queryListOnPost(sellerQueryReqDto);
                List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
                if (CollectionUtils.isNotEmpty((Collection)sellerRespDtos)) {
                    sellerMap = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getOrganizationId, o -> o, (v1, v2) -> v2));
                }
            }
            for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                MerchantListRespDto merchantListRespDto = new MerchantListRespDto();
                SellerRespDto sellerRespDto = (SellerRespDto)sellerMap.get(customerRespDto.getOrgInfoId());
                if (Objects.nonNull(sellerRespDto)) {
                    merchantListRespDto.setMerchantCode(sellerRespDto.getCode());
                    merchantListRespDto.setMerchantName(sellerRespDto.getName());
                    merchantListRespDto.setMerchantId(sellerRespDto.getId());
                }
                merchantListRespDto.setOrgInfoId(customerRespDto.getOrgInfoId());
                merchantListRespDto.setSettleStatus(customerRespDto.getSettleStatus());
                merchantListRespDto.setCompanyName(customerRespDto.getOrgName());
                listRespDtoList.add(merchantListRespDto);
            }
        }
        listRespDtoPageInfo.setList((List)listRespDtoList);
        return listRespDtoPageInfo;
    }

    public PageInfo<CustomerExtRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        RestResponse pageInfoRestResponse = this.customerExtThreeQueryApi.queryByPage(filter, pageNum, pageSize);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            Map<Object, Object> sellerMap = new HashMap();
            Set orgIds = pageInfo.getList().stream().map(CustomerRespDto::getMerchantId).collect(Collectors.toSet());
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setOrganizationIds((List)Lists.newArrayList(orgIds));
            sellerQueryReqDto.setTenantId(this.context.tenantId());
            sellerQueryReqDto.setInstanceId(this.context.instanceId());
            RestResponse listRestResponse = this.sellerQueryApi.queryList(sellerQueryReqDto);
            List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            if (CollectionUtils.isNotEmpty((Collection)sellerRespDtos)) {
                sellerMap = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getOrganizationId, o -> o, (v1, v2) -> v2));
            }
            List customerCodes = pageInfo.getList().stream().map(c -> c.getCode()).collect(Collectors.toList());
            CustomerCheckPatternReqDto customerCheckPatternReqDto = new CustomerCheckPatternReqDto();
            customerCheckPatternReqDto.setCustomerCodes(customerCodes);
            List customerCheckPatternRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerCheckPatternQueryApi.selectCustomerCheckPatternByCode(customerCheckPatternReqDto));
            Map<String, List<CustomerCheckPatternRespDto>> customerCodeGroupByMap = customerCheckPatternRespDtos.stream().collect(Collectors.groupingBy(key -> key.getCustomerCode()));
            Map<String, List<CustomerCheckPatternRespDto>> mergeCustomerCodeGroupByMap = customerCheckPatternRespDtos.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getMergeCustomerCode())).collect(Collectors.groupingBy(val -> val.getMergeCustomerCode()));
            for (CustomerExtRespDto customerExtRespDto : pageInfo.getList()) {
                SellerRespDto sellerRespDto = (SellerRespDto)sellerMap.get(customerExtRespDto.getMerchantId());
                if (Objects.nonNull(sellerRespDto)) {
                    customerExtRespDto.setMerchantName(sellerRespDto.getName());
                }
                Integer ifWholeCasePurchase = customerExtRespDto.getIfWholeCasePurchase() == null ? 0 : customerExtRespDto.getIfWholeCasePurchase();
                customerExtRespDto.setIfWholeCasePurchase(ifWholeCasePurchase);
                ArrayList customerCheckPatternRespDtoList = Lists.newArrayList();
                customerCheckPatternRespDtoList.addAll((Collection)customerCodeGroupByMap.getOrDefault(customerExtRespDto.getCode(), Lists.newArrayList()));
                customerCheckPatternRespDtoList.addAll((Collection)mergeCustomerCodeGroupByMap.getOrDefault(customerExtRespDto.getCode(), Lists.newArrayList()));
                if (!CollectionUtils.isNotEmpty((Collection)customerCheckPatternRespDtoList)) continue;
                CustomerCheckPatternRespDto customerCheckPatternRespDto = (CustomerCheckPatternRespDto)customerCheckPatternRespDtoList.stream().findFirst().get();
                customerExtRespDto.setPatternType(customerCheckPatternRespDto.getPatternType());
                ArrayList customerNames = Lists.newArrayList();
                customerNames.addAll(customerCheckPatternRespDtoList);
                customerNames.addAll(customerCheckPatternRespDtoList.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getMergeCustomerName())).map(c -> {
                    CustomerCheckPatternRespDto checkPatternRespDto = new CustomerCheckPatternRespDto();
                    checkPatternRespDto.setCustomerCode(c.getMergeCustomerCode());
                    checkPatternRespDto.setCustomerName(c.getMergeCustomerName());
                    return checkPatternRespDto;
                }).collect(Collectors.toList()));
                Map<String, CustomerCheckPatternRespDto> collect = customerNames.stream().collect(Collectors.toMap(key -> key.getCustomerCode(), val -> val, (k1, k2) -> k1));
                if (!CollectionUtils.isNotEmpty(collect.values())) continue;
                customerExtRespDto.setCustomerCheckList(collect.values().stream().filter(c -> !customerExtRespDto.getCode().equals(c.getCustomerCode())).collect(Collectors.toList()));
            }
        }
        return pageInfo;
    }

    public MerchantDetailRespDto queryMerchantByCurrentUser() {
        RestResponse restResponse = this.customerExtQueryApi.queryCompanyByCurrentUser();
        CompanyInfoDto companyInfoDto = (CompanyInfoDto)RestResponseHelper.extractData((RestResponse)restResponse);
        if (Objects.isNull(companyInfoDto)) {
            return null;
        }
        RestResponse sellerRestResp = this.sellerExtQueryApi.querySellerByOrganizationId(companyInfoDto.getOrgInfoId());
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)sellerRestResp);
        if (Objects.isNull(sellerRespDto)) {
            return null;
        }
        MerchantDetailRespDto merchantDetailRespDto = new MerchantDetailRespDto();
        CubeBeanUtils.copyProperties((Object)merchantDetailRespDto, (Object)sellerRespDto, (String[])new String[0]);
        merchantDetailRespDto.setCompanyInfoDto(companyInfoDto);
        return merchantDetailRespDto;
    }

    public StoreRespDto queryCompanyByCreditCode(String creditCode, String customerCode) {
        RestResponse customer = this.customerQueryApi.queryCustomerByCode(customerCode);
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customer);
        logger.info("\u5f53\u524d\u6821\u9a8c\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)customerRespDto));
        RestResponse storeRespDtoRestResponse = this.storeQueryApi.queryStoreRespDtoByCreditNum(creditCode);
        StoreRespDto storeRespDto = (StoreRespDto)RestResponseHelper.extractData((RestResponse)storeRespDtoRestResponse);
        logger.info("\u836f\u5e97\u3010{}\u3011\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)creditCode, (Object)JSON.toJSONString((Object)storeRespDto));
        if (CustomerTypeEnum.RETAILER.getCode().equals(customerRespDto.getType())) {
            if (!BeanPropertyNullUtil.isAllFieldNull(storeRespDto)) {
                Assert.isTrue((boolean)storeRespDto.getIsCustomer().equals(IsCustomerEnum.NOT_CUSTOMER.getCode()), (String)"0001", (String)"\u5f53\u524d\u4fe1\u7528\u4ee3\u7801\u4e3a\u5927\u5ba2\u6237!!!");
                Assert.isTrue((!VERIFY_STATE.contains(storeRespDto.getState()) ? 1 : 0) != 0, (String)"0001", (String)"\u5f53\u524d\u4fe1\u7528\u4ee3\u7801\u5df2\u6ce8\u9500!!!");
                Assert.isTrue((boolean)storeRespDto.getIsFirstPartner().equals(StoreIsFirstParentEnum.NOT_FIRST_PARENT.getCode()), (String)"0001", (String)"\u5f53\u524d\u4fe1\u7528\u4ee3\u7801\u4e3a\u4e00\u7ea7\u7ecf\u9500\u5546!!!");
            }
            CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
            customerExtReqDto.setCreditCode(creditCode);
            customerExtReqDto.setMerchantId(customerRespDto.getMerchantId());
            List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomerList(customerExtReqDto));
            List customerCodes = customerRespDtoList.stream().filter(c -> c.getType().equals(CustomerTypeEnum.RETAILER.getCode())).filter(c -> !c.getCode().equals(customerCode)).map(c -> c.getCode()).collect(Collectors.toList());
            logger.info("\u6821\u9a8c\u4fe1\u7528\u4ee3\u7801\u67e5\u8be2\u5ba2\u6237\u7ed3\u679c\u96c6\uff1a{}", (Object)JSON.toJSONString(customerCodes));
            Assert.isTrue((boolean)CollectionUtils.isEmpty(customerCodes), (String)"0001", (String)("\u5546\u5bb6\u5df2\u5b58\u5728\u8be5\u96f6\u552e\u5546\u5ba2\u6237[" + StringUtils.join(customerCodes, (String)" | ") + "],\u8bf7\u68c0\u67e5\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801"));
        }
        if (BeanPropertyNullUtil.isAllFieldNull(storeRespDto)) {
            RestResponse companyResultDtoRestResponse = this.companyQueryApi.queryCompanyByDesc(creditCode);
            CompanyResultDto companyResultDto = (CompanyResultDto)RestResponseHelper.extractData((RestResponse)companyResultDtoRestResponse);
            logger.info("\u3010\u5929\u773c\u67e5\u3011\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)companyResultDto));
            Assert.notNull((Object)companyResultDto, (String)"0001", (String)"\u67e5\u8be2\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u65e0\u6570\u636e");
            CompanyResultInfoDto result = companyResultDto.getResult();
            Assert.notNull((Object)result, (String)"0001", (String)"\u67e5\u8be2\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u65e0\u6570\u636e");
            StoreRespDto respDto = new StoreRespDto(result.getName(), result.getHistoryNames(), result.getCreditCode(), "", result.getCity(), result.getDistrict(), result.getRegLocation(), result.getRegStatus(), result.getLegalPersonName());
            Assert.isTrue((!BeanPropertyNullUtil.isAllFieldNull(respDto) ? 1 : 0) != 0, (String)"0001", (String)"\u67e5\u8be2\u4f01\u4e1a\u57fa\u7840\u4fe1\u606f\u65e0\u6570\u636e");
            return respDto;
        }
        return storeRespDto;
    }

    public CompanyVerifyRespDto verifyCompany(CompanyVerifyReqDto verifyCompanyReqDto) {
        Assert.notNull((Object)verifyCompanyReqDto.getCode(), (String)"0001", (String)"\u4fe1\u7528\u4ee3\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.notNull((Object)verifyCompanyReqDto.getName(), (String)"0001", (String)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.notNull((Object)verifyCompanyReqDto.getLegalPersonName(), (String)"0001", (String)"\u6cd5\u4eba\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        CompanyVerifyRespDto companyVerifyRespDto = null;
        RestResponse storeRespDtoRestResponse = this.storeQueryApi.queryStoreRespDtoByCreditNum(verifyCompanyReqDto.getCode());
        StoreRespDto storeRespDto = (StoreRespDto)RestResponseHelper.extractData((RestResponse)storeRespDtoRestResponse);
        if (BeanPropertyNullUtil.isAllFieldNull(storeRespDto)) {
            RestResponse companyVerifyRespDtoRestResponse = this.companyQueryApi.queryCompanyVerify(verifyCompanyReqDto);
            companyVerifyRespDto = (CompanyVerifyRespDto)RestResponseHelper.extractData((RestResponse)companyVerifyRespDtoRestResponse);
            Assert.notNull((Object)companyVerifyRespDto, (String)"0001", (String)"\u5929\u773c\u67e5\u4e09\u8981\u7d20\u6821\u9a8c\u5f02\u5e38");
            if (companyVerifyRespDto.getResult() != 1) {
                throw new BizException("100000", "\u5929\u773c\u67e5-\u4f01\u4e1a\u4e09\u8981\u7d20\u9a8c\u8bc1\u5f02\u5e38\uff1a\u9a8c\u8bc1\u7ed3\u679c" + CompanyVerifyEnum.fromCode((Integer)companyVerifyRespDto.getResult()).getName() + " \u63cf\u8ff0\uff1a" + companyVerifyRespDto.getRemark());
            }
            CompanyResultDto companyResultDto = (CompanyResultDto)RestResponseHelper.extractData((RestResponse)this.companyQueryApi.queryCompanyByDesc(verifyCompanyReqDto.getCode()));
            if (companyResultDto.getError_code() != 0) {
                throw new BizException("100000", "\u5929\u773c\u67e5-\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u5f02\u5e38\uff1a\u9519\u8bef\u4ee3\u7801 " + companyResultDto.getError_code());
            }
            logger.info("\u6839\u636e\u4fe1\u7528\u4ee3\u7801\u83b7\u53d6\u95e8\u5e97\u8be6\u7ec6\u4fe1\u606f => {} ", (Object)JSON.toJSONString((Object)companyResultDto));
            StoreReqDto storeReqDto = this.companyResultDtoToStoreRespDto(companyResultDto);
            this.storeService.saveOrUpdateStore(storeReqDto);
        } else {
            companyVerifyRespDto = new CompanyVerifyRespDto();
            boolean name = verifyCompanyReqDto.getName().equals(StringUtils.defaultString((String)storeRespDto.getStoreName(), (String)""));
            boolean legalPersonName = verifyCompanyReqDto.getLegalPersonName().equals(StringUtils.defaultString((String)storeRespDto.getLegalPersonName(), (String)""));
            CompanyVerifyEnum companyVerifyEnum = name ? (legalPersonName ? CompanyVerifyEnum.SUCCESS : CompanyVerifyEnum.FAIL_LEGALPERSONNAME) : CompanyVerifyEnum.FAIL_NAME;
            companyVerifyRespDto.setResult(companyVerifyEnum.getCode());
            companyVerifyRespDto.setRemark(companyVerifyEnum.getName());
        }
        return companyVerifyRespDto;
    }

    private StoreReqDto companyResultDtoToStoreRespDto(CompanyResultDto companyResultDto) {
        CompanyResultInfoDto result = companyResultDto.getResult();
        StoreReqDto storeReqDto = StoreReqDto.builder().storeName(result.getName()).storeAlias(result.getHistoryNames()).socialCreditNum(result.getCreditCode()).province(result.getBase()).city(result.getCity()).district(result.getDistrict()).storeAddr(result.getRegLocation()).storeRegisterAddr(result.getRegLocation()).state(result.getRegStatus()).legalPersonName(result.getLegalPersonName()).isReplenish(IsDealEnum.NOT_DEAL.getCode()).dataOrigin(StoreDataOriginEnum.SKY_EYE_QUERY.getCode()).build();
        TianyanchaProvinceEnum tianyanchaProvince = TianyanchaProvinceEnum.find(result.getBase());
        log.info("\u5929\u773c\u67e5\u7701\u4efd\u4fe1\u606f\u6620\u5c04 ==> \u5929\u773c\u67e5\u7ed3\u679c: {}; \u6620\u5c04\u7ed3\u679c {}", (Object)result.getBase(), (Object)(tianyanchaProvince == null ? null : tianyanchaProvince.getProvinceName()));
        if (tianyanchaProvince != null) {
            storeReqDto.setProvince(tianyanchaProvince.getProvinceName());
            storeReqDto.setProvinceCode(tianyanchaProvince.getProvinceCode());
            if (TianyanchaProvinceEnum.BIG_CITY.contains(tianyanchaProvince.getProvinceName()) && "\u5e02\u8f96\u533a".equals(result.getCity())) {
                String bigCityName = tianyanchaProvince.getProvinceName() + "\u5e02";
                log.info("\u5929\u773c\u67e5\u76f4\u8f96\u5e02\u6620\u5c04 ==> \u5929\u773c\u67e5\u7ed3\u679c: {}; \u6620\u5c04\u7ed3\u679c {}", (Object)result.getCity(), (Object)bigCityName);
                result.setCity(bigCityName);
                storeReqDto.setCity(bigCityName);
            }
            String cityCode = this.getStoreAreaCodeByName(result.getCity(), tianyanchaProvince.getProvinceCode(), String.valueOf(StoreAreaLevelEnum.CITY.getCode()));
            storeReqDto.setCityCode(cityCode);
            if (cityCode != null) {
                String districtCode = this.getStoreAreaCodeByName(result.getDistrict(), cityCode, String.valueOf(StoreAreaLevelEnum.DISTRICT.getCode()));
                storeReqDto.setDistrictCode(districtCode);
            }
        }
        return storeReqDto;
    }

    private String getStoreAreaCodeByName(String name, String parentCode, String level) {
        log.info("\u6839\u636e\u533a\u57df\u540d\u79f0\u83b7\u53d6\u533a\u57dfcode\u53c2\u6570 ==> \u533a\u57df\u540d\u79f0: {}; \u533a\u57dfparentCode {}; level {}", new Object[]{name, parentCode, level});
        if (parentCode == null) {
            return null;
        }
        StoreAreaRespDto storeAreaRespDto = (StoreAreaRespDto)RestResponseHelper.extractData((RestResponse)this.storeAreaQueryApi.queryByProvince(StoreQueryProvinceReqDto.builder().parentCode(parentCode).level(level).name(name).build()));
        log.info("\u6839\u636e\u533a\u57df\u540d\u79f0\u83b7\u53d6\u533a\u57dfcode\u7ed3\u679c ==> \u533a\u57dfcode: {}", (Object)storeAreaRespDto.getCode());
        return storeAreaRespDto.getCode();
    }

    public Void updateCustomerStatus(Long id, Long statusId) {
        this.updateCusAndSellerstatus(id, statusId, null);
        return null;
    }

    private Void updateCusAndSellerstatus(Long id, Long statusId, String flag) {
        RestResponse sellerResp;
        SellerRespDto sellerRespDto;
        RestResponse cusResp = this.customerExtQueryApi.queryById(id);
        CustomerExtDetailRespDto respDto = (CustomerExtDetailRespDto)RestResponseHelper.extractData((RestResponse)cusResp);
        if (ObjectUtils.isEmpty((Object)respDto) || ObjectUtils.isEmpty((Object)respDto.getOrgInfoId())) {
            throw new BizException("100000", "\u5546\u5bb6\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)respDto.getStatusId())) {
            logger.info("\u5ba2\u6237id\u4e3a:{},\u5176\u72b6\u6001ID\u4e3a\u7a7a,\u4e0d\u66f4\u65b0\u5ba2\u6237\u72b6\u6001\u548c\u5546\u5bb6\u72b6\u6001", (Object)id);
            return null;
        }
        if (!"ALL".equals(flag)) {
            RestResponse resp = this.customerExtThreeApi.updateCustomerStatus(id, statusId);
            RestResponseHelper.extractData((RestResponse)resp);
        }
        if (ObjectUtils.isNotEmpty((Object)(sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)(sellerResp = this.sellerExtQueryApi.querySellerByOrganizationId(respDto.getOrgInfoId()))))) && ObjectUtils.isNotEmpty((Object)sellerRespDto.getId())) {
            StatusReqDto statusReqDto = new StatusReqDto();
            statusReqDto.setId(sellerRespDto.getId());
            RestResponse statusResp = this.customerStatusQueryApi.queryById(statusId);
            CustomerStatusRespDto statusRespDto = (CustomerStatusRespDto)RestResponseHelper.extractData((RestResponse)statusResp);
            if (CustomerStatusEnum.ENABLED.getCode().equals(statusRespDto.getCode()) || CustomerStatusEnum.CANCEL.getCode().equals(statusRespDto.getCode())) {
                statusReqDto.setStatus(SellerStatusEnum.NORMAL.getCode());
            } else {
                statusReqDto.setStatus(SellerStatusEnum.BANNED.getCode());
            }
            RestResponse changeResp = this.sellerExtApi.changeStatus(statusReqDto);
            RestResponseHelper.extractData((RestResponse)changeResp);
        }
        return null;
    }

    public void update(CustomerReqExtDto reqDto) {
        RestResponse updateResp = this.customerExtThreeApi.update(reqDto);
        RestResponseHelper.extractData((RestResponse)updateResp);
        this.updateCusAndSellerstatus(reqDto.getId(), reqDto.getStatusId(), "ALL");
        this.updateCusNameForDealer(reqDto);
    }

    private void updateCusNameForDealer(CustomerReqExtDto reqDto) {
        if (!CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
            return;
        }
        if (reqDto.getOrgInfoId() == null || StringUtils.isEmpty((CharSequence)reqDto.getName())) {
            return;
        }
        logger.info("\u540c\u6b65\u4fee\u6539\u5173\u8054\u8868\u516c\u53f8\u540d\u79f0 start. organizationId={}, name={}", (Object)reqDto.getOrgInfoId(), (Object)reqDto.getName());
        Integer updateOrganizationResult = (Integer)RestResponseHelper.extractData((RestResponse)this.organizationThreeApi.modify(ModifyOrganizationReqDto.builder().id(reqDto.getOrgInfoId()).name(reqDto.getName()).build()));
        logger.info("\u540c\u6b65\u4fee\u6539\u5173\u8054\u8868\u516c\u53f8\u540d\u79f0 \u4fee\u6539 us_organization \u8868\u6210\u529f result={}; id={}", (Object)updateOrganizationResult, (Object)reqDto.getOrgInfoId());
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(reqDto.getOrgInfoId()));
        if (sellerRespDto != null && sellerRespDto.getId() != null) {
            SellerToBReqDto sellerToBReqDto = new SellerToBReqDto();
            sellerToBReqDto.setSellerId(sellerRespDto.getId());
            sellerToBReqDto.setName(reqDto.getName());
            sellerToBReqDto.setOrganizationName(reqDto.getName());
            RestResponseHelper.extractData((RestResponse)this.sellerExtApi.modifySeller(sellerToBReqDto));
            logger.info("\u540c\u6b65\u4fee\u6539\u5173\u8054\u8868\u516c\u53f8\u540d\u79f0 \u4fee\u6539 sc_seller \u8868\u6210\u529f id={}", (Object)sellerRespDto.getId());
        }
        List shopBaseDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerOrgId(reqDto.getOrgInfoId()));
        for (ShopBaseDto shopBaseDto : shopBaseDtos) {
            ShopToBDto shopToBDto = new ShopToBDto();
            shopToBDto.setId(shopBaseDto.getId());
            if (shopBaseDtos.size() > 1) {
                shopToBDto.setName(reqDto.getName() + shopBaseDto.getCode());
            } else {
                shopToBDto.setName(reqDto.getName());
            }
            shopToBDto.setOrganizationName(reqDto.getName());
            RestResponseHelper.extractData((RestResponse)this.shopExtApi.updateShop(shopToBDto));
            logger.info("\u540c\u6b65\u4fee\u6539\u5173\u8054\u8868\u516c\u53f8\u540d\u79f0 \u4fee\u6539 sc_shop \u8868\u6210\u529f id={}", (Object)shopBaseDto.getId());
        }
        StoreSellerGovernReqDto StoreSellerGovernReqDto2 = new StoreSellerGovernReqDto();
        StoreSellerGovernReqDto2.setCompanyName(reqDto.getName());
        StoreSellerGovernReqDto2.setSellerName(reqDto.getName());
        StoreSellerGovernReqDto2.setOrganizationId(reqDto.getOrgInfoId());
        Integer updateStoreSellerGovernResult = (Integer)RestResponseHelper.extractData((RestResponse)this.storeSellerGovernApi.updateByOrganizationId(StoreSellerGovernReqDto2));
        logger.info("\u540c\u6b65\u4fee\u6539\u5173\u8054\u8868\u516c\u53f8\u540d\u79f0 \u4fee\u6539 cs_store_seller_govern \u8868\u6210\u529f result={}", (Object)updateStoreSellerGovernResult);
        logger.info("\u540c\u6b65\u4fee\u6539\u5173\u8054\u8868\u516c\u53f8\u540d\u79f0 end. ");
    }

    public RestResponse<CustomerAddResultDto> add(CustomerReqExtDto reqDto) {
        return this.customerExtThreeApi.add(reqDto);
    }

    public RestResponse<List<String>> batchUpCusIfWholePurchase(CustomerBatchUpReqDto reqDto) {
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCustomerIds()) && reqDto.getDr() != null && reqDto.getDr().equals(1)) {
            ArrayList<DrCustomersReqDto> drCustomerLists = new ArrayList<DrCustomersReqDto>();
            for (Long id : reqDto.getCustomerIds()) {
                drCustomerLists.add(new DrCustomersReqDto(id, (Integer)RestResponseHelper.extractData((RestResponse)this.saleOrderReportQueryApi.queryCountByCustomerId(id.toString()))));
            }
            reqDto.setDrCustomerLists(drCustomerLists);
            reqDto.setCustomerIds(null);
        }
        return this.customerExtThreeApi.batchUpCusIfWholePurchase(reqDto);
    }
}

