/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.credit.api.credit.ICreditEntityApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryTobApi;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerOrgInfoApi;
import com.dtyunxi.yundt.cube.center.user.api.ICustomerUserApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.ICustomerOrgInfoQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.ICustomerUserQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerV4Service;
import com.dtyunxi.yundt.module.customer.api.dto.response.CustomerListRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.SrcTypeEnum;
import com.dtyunxi.yundt.module.customer.biz.impl.CustomerServiceImpl;
import com.dtyunxi.yundt.module.customer.biz.mq.producer.CustomerChangeProducer;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.dto.request.CustomerSearchExtThreeReqDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="customerV4Service")
public class CustomerServiceV4Impl
implements ICustomerV4Service {
    private static Logger logger = LoggerFactory.getLogger(CustomerServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private ICustomerOrgInfoApi customerOrgInfoApi;
    @Resource
    private ICustomerApi customerApi;
    @Autowired
    private IUserApi userApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private ICustomerUserQueryApi customerUserQueryApi;
    @Resource
    private ICustomerUserApi customerUserApi;
    @Resource
    private ICustomerOrgInfoQueryApi customerOrgInfoQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private OssRegistryVo ossRegistryVo;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IOrderQueryTobApi orderQueryTobApi;
    @Resource
    private CustomerChangeProducer customerChangeProducer;
    @Resource
    private ICreditEntityApi iCreditEntityApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    public PageInfo<CustomerListRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        RestResponse enableCustomerIds;
        CustomerSearchExtThreeReqDto searchReqDto = new CustomerSearchExtThreeReqDto();
        logger.info("queryByPage params:{}", (Object)filter);
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (CustomerSearchExtThreeReqDto)JSONObject.parseObject((String)filter, CustomerSearchExtThreeReqDto.class);
        }
        searchReqDto.setTenantId(this.context.tenantId());
        this.settingUserIdsForSearch((CustomerSearchReqDto)searchReqDto);
        if (Objects.nonNull(searchReqDto.getUserFlag()) && !searchReqDto.getUserFlag().booleanValue()) {
            return new PageInfo();
        }
        searchReqDto.setListFlag(Boolean.valueOf(true));
        if (SrcTypeEnum.SALESMAN.getCode().equals(searchReqDto.getSrcType())) {
            searchReqDto.setSalesmanUserId(this.context.userId());
            RestResponse pageInfoRestResponse = this.customerQueryApi.queryByPage(JSON.toJSONString((Object)searchReqDto), pageNum, pageSize);
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            ArrayList listRespDtoList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                List customerIds = (List)this.customerExtQueryApi.queryCustomerIdByOrgId(pageInfo.getList().stream().map(CustomerRespDto::getMerchantId).distinct().collect(Collectors.toList())).getData();
                List customerList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty((Collection)customerIds)) {
                    customerList = (List)this.customerExtQueryApi.queryListByCustomerIds(customerIds).getData();
                }
                logger.info("\u83b7\u53d6\u6240\u5c5e\u5546\u5bb6 customerIds = {}, customerList = {}", (Object)JSONObject.toJSONString((Object)customerIds), (Object)JSONObject.toJSONString((Object)customerList));
                List orgInfoIds = pageInfo.getList().stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
                List orgAndOrgInfoByIds = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOrgAndOrgInfoByIds(orgInfoIds));
                logger.info("\u83b7\u53d6\u6240\u5c5eorgInfo orgInfoIds = {}, orgAndOrgInfoList = {}", (Object)JSONObject.toJSONString(orgInfoIds), (Object)JSONObject.toJSONString((Object)orgAndOrgInfoByIds));
                for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                    CustomerListRespDto listRespDto = new CustomerListRespDto();
                    CubeBeanUtils.copyProperties((Object)listRespDto, (Object)customerRespDto, (String[])new String[0]);
                    if (CollectionUtils.isNotEmpty((Collection)customerList)) {
                        for (CustomerRespDto customer : customerList) {
                            if (!Objects.equals(customerRespDto.getMerchantId(), customer.getOrgInfoId())) continue;
                            listRespDto.setMerchantName(customer.getName());
                            break;
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)orgAndOrgInfoByIds)) {
                        for (OrgAndOrgInfoRespDto orgAndOrgInfoRespDto : orgAndOrgInfoByIds) {
                            if (!Objects.equals(customerRespDto.getOrgInfoId(), orgAndOrgInfoRespDto.getOrganizationDto().getId())) continue;
                            listRespDto.setOrgName(orgAndOrgInfoRespDto.getOrganizationInfoDto().getOrgName());
                            break;
                        }
                    }
                    listRespDtoList.add(listRespDto);
                }
            }
            logger.info("\u4e1a\u52a1\u5458\u7aeflistRespDtoList>>>>{}", (Object)JSON.toJSONString((Object)listRespDtoList));
            PageInfo listRespDtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)listRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
            listRespDtoPageInfo.setList((List)listRespDtoList);
            return listRespDtoPageInfo;
        }
        if ("Y".equalsIgnoreCase(searchReqDto.getIsHaveCreditAccount())) {
            enableCustomerIds = this.iCreditEntityApi.getEnableCustomerIds("3");
            searchReqDto.setIdList((List)enableCustomerIds.getData());
        }
        if (Objects.equals(searchReqDto.getIsFilterCreditEntity(), "Y")) {
            enableCustomerIds = this.iCreditEntityApi.getEnableCustomerIds("3");
            searchReqDto.setIdNotInList((List)enableCustomerIds.getData());
            logger.info("[\u5ba2\u5546\u5ba2\u6237] >>> \u8fc7\u6ee4\u6389\u5df2\u4fe1\u7528\u51c6\u5165\u7684\u5ba2\u6237id:{}", (Object)searchReqDto.getIdNotInList());
        }
        searchReqDto.setIsFilterDownstreamCustomersByCurrentUser(Boolean.valueOf(true));
        if (searchReqDto.getType() == null) {
            searchReqDto.setType(CustomerTypeEnum.DEALER.getCode());
        }
        if (searchReqDto.getChannel() == null) {
            searchReqDto.setChannel(CustomerTypeEnum.DEALER.getCode());
        }
        if (searchReqDto.getOrganizationId() != null) {
            searchReqDto.setMerchantIds(Arrays.asList(searchReqDto.getOrganizationId()));
        }
        RestResponse pageInfoRestResponse = this.customerExtThreeQueryApi.queryByPage(JSON.toJSONString((Object)searchReqDto), pageNum, pageSize);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        PageInfo listRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)listRespDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList listRespDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                CustomerListRespDto listRespDto = new CustomerListRespDto();
                CubeBeanUtils.copyProperties((Object)listRespDto, (Object)customerRespDto, (String[])new String[0]);
                listRespDtoList.add(listRespDto);
            }
        }
        listRespDtoPageInfo.setList((List)listRespDtoList);
        return listRespDtoPageInfo;
    }

    private void settingUserIdsForSearch(CustomerSearchReqDto searchReqDto) {
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getUserName())) {
            ArrayList userFilters = Lists.newArrayList();
            userFilters.add(SqlFilter.like((String)"userName", (Object)("%" + searchReqDto.getUserName() + "%")));
            HashMap filterMap = Maps.newHashMap();
            filterMap.put("filters", userFilters);
            filterMap.put("tenantId", searchReqDto.getTenantId());
            filterMap.put("instanceId", searchReqDto.getInstanceId());
            String queryFilter = JSONObject.toJSONString((Object)filterMap);
            RestResponse pageInfoRestResponse = this.userQueryApi.queryByPage(queryFilter, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
            PageInfo userDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
            ArrayList userIdList = Lists.newArrayList();
            if (Objects.nonNull(userDtoPageInfo) && CollectionUtils.isNotEmpty((Collection)userDtoPageInfo.getList())) {
                for (UserDto userDto : userDtoPageInfo.getList()) {
                    userIdList.add(userDto.getId());
                }
            }
            if (CollectionUtils.isEmpty((Collection)userIdList)) {
                searchReqDto.setUserFlag(Boolean.valueOf(false));
            }
            searchReqDto.setUserIds((List)userIdList);
        }
    }
}

