/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerAreaApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaInfoReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaSubTreeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaTreeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaTreeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u5546\u7ec4\u4ef6\uff1a\u5ba2\u6237\u533a\u57df\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/basedata/area-group"})
public class CustomerAreaRest {
    @Resource
    private IContext context;
    @Resource
    private ICustomerAreaApi customerAreaApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;

    @PostMapping(value={""}, produces={"application/json"})
    @ApiOperation(value="\u65b0\u589e\u533a\u57df\u5206\u7ec4", notes="\u65b0\u589e\u533a\u57df\u5206\u7ec4")
    RestResponse<Long> saveAreaGroup(@Validated @RequestBody CustomerAreaReqDto customerAreaReqDto) {
        customerAreaReqDto.setInstanceId(this.context.instanceId());
        customerAreaReqDto.setTenantId(this.context.tenantId());
        return new RestResponse(this.customerAreaApi.saveCustomerArea(customerAreaReqDto).getData());
    }

    @DeleteMapping(value={"/{code}"}, produces={"application/json"})
    @ApiOperation(value="\u5220\u9664\u533a\u57df\u5206\u7ec4", notes="\u6839\u636e\u533a\u57df\u5206\u7ec4ID\u5220\u9664\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u533a\u57df\u5206\u7ec4CODE", dataType="String", paramType="path", required=true)})
    RestResponse<Void> removeByCode(@PathVariable(value="code") String code) {
        CustomerAreaInfoReqDto customerAreaInfoReqDto = new CustomerAreaInfoReqDto();
        customerAreaInfoReqDto.setCode(code);
        this.customerAreaApi.removeByCondition(customerAreaInfoReqDto);
        return RestResponse.VOID;
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"})
    @ApiOperation(value="\u4fee\u6539\u533a\u57df\u5206\u7ec4", notes="\u4fee\u6539\u533a\u57df\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u533a\u57df\u5206\u7ec4ID", dataType="Long", paramType="path", required=true)})
    RestResponse<Void> modifyAreaGroup(@PathVariable(value="id") Long id, @Validated @RequestBody CustomerAreaReqDto customerAreaReqDto) {
        customerAreaReqDto.setInstanceId(this.context.instanceId());
        customerAreaReqDto.setTenantId(this.context.tenantId());
        this.customerAreaApi.modifyCustomerArea(id, customerAreaReqDto);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/page"}, produces={"application/json"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u533a\u57df\u5206\u7ec4", notes="\u5206\u9875\u67e5\u8be2\u533a\u57df\u5206\u7ec4")
    RestResponse<PageInfo<CustomerAreaRespDto>> queryByPage(@RequestParam(value="filter") String filter, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        RestResponse pageInfo = this.customerAreaQueryApi.queryByPage(filter, pageNum, pageSize);
        return pageInfo;
    }

    @GetMapping(value={"/code/{code}"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u533a\u57df\u5206\u7ec4\u7f16\u7801\u67e5\u8be2\u533a\u57df\u5206\u7ec4", notes="\u6839\u636e\u533a\u57df\u5206\u7ec4\u7f16\u7801\u67e5\u8be2\u533a\u57df\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u533a\u57df\u5206\u7ec4\u7f16\u7801", dataType="String", paramType="path", required=true)})
    RestResponse<CustomerAreaTreeRespDto> queryByCode(@PathVariable(value="code") String code) {
        CustomerAreaSubTreeReqDto customerAreaSubTreeReqDto = new CustomerAreaSubTreeReqDto();
        customerAreaSubTreeReqDto.setCode(code);
        RestResponse customerAreaTreeRespDtoRestResponse = this.customerAreaQueryApi.queryForSubTree(customerAreaSubTreeReqDto);
        return customerAreaTreeRespDtoRestResponse;
    }

    @GetMapping(value={"/parent-code/{parentCode}"}, produces={"application/json"})
    @ApiOperation(value="\u6839\u636e\u533a\u57df\u5206\u7ec4\u7236\u7f16\u7801\u67e5\u8be2\u533a\u57df\u5206\u7ec4", notes="\u6839\u636e\u533a\u57df\u5206\u7ec4\u7236\u7f16\u7801\u67e5\u8be2\u533a\u57df\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="parentCode", value="\u533a\u57df\u5206\u7ec4\u7236\u7f16\u7801", dataType="String", paramType="path", required=true)})
    RestResponse<List<CustomerAreaRespDto>> queryByParentCode(@PathVariable(value="parentCode") String parentCode) {
        CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
        customerAreaListReqDto.setParentCode(parentCode);
        RestResponse listRestResponse = this.customerAreaQueryApi.queryForList(customerAreaListReqDto);
        return listRestResponse;
    }

    @GetMapping(value={"/tree"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u533a\u57df\u5206\u7ec4\u6811", notes="\u67e5\u8be2\u533a\u57df\u5206\u7ec4\u6811")
    RestResponse<List<CustomerAreaTreeRespDto>> queryForTree(@RequestParam(required=false) Long orgInfoId) {
        CustomerAreaTreeReqDto customerAreaTreeReqDto = new CustomerAreaTreeReqDto();
        customerAreaTreeReqDto.setOrgInfoId(orgInfoId);
        RestResponse listRestResponse = this.customerAreaQueryApi.queryForTree(customerAreaTreeReqDto);
        return listRestResponse;
    }

    @GetMapping(value={"/list/level/{level}"}, produces={"application/json"})
    @ApiOperation(value="\u6309\u5c42\u7ea7\u67e5\u8be2\u533a\u57df\u5206\u7ec4", notes="\u6309\u5c42\u7ea7\u67e5\u8be2\u533a\u57df\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="level", value="\u67e5\u8be2\u5c42\u7ea7", dataType="Long", paramType="path", required=true)})
    RestResponse<List<CustomerAreaRespDto>> queryByLevel(@PathVariable(value="level") Integer level) {
        CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
        customerAreaListReqDto.setLevel(level);
        RestResponse listRestResponse = this.customerAreaQueryApi.queryForList(customerAreaListReqDto);
        return listRestResponse;
    }
}

