/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.starter.context;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.user.api.query.IApplicationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.context.biz.FeignClientContextFilter;
import com.dtyunxi.yundt.module.context.biz.config.ContextInterceptorConfig;
import com.dtyunxi.yundt.module.context.biz.impl.CenterRequestPreProcessService;
import com.dtyunxi.yundt.module.context.biz.impl.ContextImpl;
import com.dtyunxi.yundt.module.context.common.config.AppRecognitionConfig;
import com.dtyunxi.yundt.module.context.common.config.ContextAutoConfiguration;
import feign.RequestInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Lazy;

@RefreshScope
@ComponentScan(value={"com.dtyunxi.yundt.module.context"})
public class ContextModuleAutoConfig
extends ContextAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={RequestInterceptor.class})
    public FeignClientContextFilter feignFilter(AppRecognitionConfig appRecognitionConfig) {
        return new FeignClientContextFilter().initTransferableHeaders(appRecognitionConfig.getTransferableHeaders());
    }

    @Bean
    public ContextInterceptorConfig contextInterceptorConfig(AppRecognitionConfig appRecognitionConfig) {
        return new ContextInterceptorConfig().initTransferableHeaders(appRecognitionConfig.getTransferableHeaders());
    }

    @Bean
    public IContext context() {
        return new ContextImpl();
    }

    @Bean
    public CenterRequestPreProcessService requestPreProcessService(@Lazy @Autowired IApplicationQueryApi applicationQueryApi, @Autowired AppRecognitionConfig appRecognitionConfig, @Autowired(required=false) ICacheService cacheService) {
        return new CenterRequestPreProcessService(applicationQueryApi, appRecognitionConfig, cacheService);
    }
}

