/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.pearlriver.mail.impl;

import com.dtyunxi.pearlriver.mail.MailService;
import com.dtyunxi.pearlriver.vo.MailVo;
import java.io.File;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class MailServiceImpl
implements MailService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private MailVo from;

    @Override
    public void sendSimpleMail(String to, String subject, String content) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(this.from.getFrom());
        message.setTo(to);
        message.setSubject(subject);
        message.setText(content);
        try {
            this.mailSender.send(message);
            this.logger.info("\u7b80\u5355\u90ae\u4ef6\u5df2\u7ecf\u53d1\u9001\u3002");
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001\u7b80\u5355\u90ae\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    @Override
    public void sendHtmlMail(String to, String subject, String content) {
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(this.from.getFrom());
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
            this.mailSender.send(message);
            this.logger.info("html\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001html\u90ae\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    @Override
    public void sendHtmlMail(String[] to, String subject, String content) {
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(this.from.getFrom());
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
            this.mailSender.send(message);
            this.logger.info("html\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001html\u90ae\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    @Override
    public void sendAttachmentsMail(String to, String subject, String content, String filePath) {
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(this.from.getFrom());
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
            FileSystemResource file = new FileSystemResource(new File(filePath));
            String fileName = filePath.substring(filePath.lastIndexOf(File.separator));
            helper.addAttachment(fileName, (InputStreamSource)file);
            this.mailSender.send(message);
            this.logger.info("\u5e26\u9644\u4ef6\u7684\u90ae\u4ef6\u5df2\u7ecf\u53d1\u9001\u3002");
        }
        catch (MessagingException e) {
            this.logger.error("\u53d1\u9001\u5e26\u9644\u4ef6\u7684\u90ae\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    @Override
    public void sendInlineResourceMail(String to, String subject, String content, String rscPath, String rscId) {
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(this.from.getFrom());
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
            FileSystemResource res = new FileSystemResource(new File(rscPath));
            helper.addInline(rscId, (Resource)res);
            this.mailSender.send(message);
            this.logger.info("\u5d4c\u5165\u9759\u6001\u8d44\u6e90\u7684\u90ae\u4ef6\u5df2\u7ecf\u53d1\u9001\u3002");
        }
        catch (MessagingException e) {
            this.logger.error("\u53d1\u9001\u5d4c\u5165\u9759\u6001\u8d44\u6e90\u7684\u90ae\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
        }
    }
}

