package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author ghosn
 * @create 2023/4/4 13:24
 */
@Data
@ApiModel(value = "CustomerStoreReqDto", description = "客户门店信息查询Dto")
public class CustomerStoreReqDto {

    @ApiModelProperty(value = "组织ID", name = "orgId")
    private Long orgId;


    @ApiModelProperty(value = "门店ids", name = "storeIds")
    private List<String> storeIds;

    @ApiModelProperty(value = "组织ids", name = "merchantIds")
    private List<Long> merchantIds;


    @ApiModelProperty(value = "门店编号", name = "storeNo")
    private String storeNo;

    @ApiModelProperty(value = "门店编号集合", name = "storeNos")
    private List<String> storeNos;

    @ApiModelProperty(value = "门店名称", name = "storeName")
    private String storeName;

    @ApiModelProperty(value = "门店信用代码", name = "creditCode")
    private String creditCode;

    @ApiModelProperty(value = "门店类型", name = "storeTye")
    private String storeType;

    @ApiModelProperty(value = "门店子类型", name = "storeCategoryCode")
    private String storeCategoryCode;

    @ApiModelProperty(value = "门店状态", name = "storeTye")
    private String storeState;

    @ApiModelProperty(value = "所属商家", name = "merchantId")
    private Long merchantId;

    @ApiModelProperty(value = "客户区域", name = "regionCodes")
    private List<String> regionCodes;

    @ApiModelProperty(
            name = "provinceCode",
            value = "省份编码"
    )
    private String provinceCode;

    @ApiModelProperty(
            name = "cityCode",
            value = "市编码"
    )
    private String cityCode;

    @ApiModelProperty(
            name = "districtCode",
            value = "县区编码"
    )
    private String districtCode;

    @ApiModelProperty(
            name = "distributionName",
            value = "分销商名称"
    )
    private String distributionName;

    @ApiModelProperty(
            name = "distributionCode",
            value = "分销商客户编码"
    )
    private String distributionCode;

    @ApiModelProperty(
            name = "distributionCreditCode",
            value = "分销商信用代码"
    )
    private String distributionCreditCode;

    @ApiModelProperty(
            name = "parentStoreNo",
            value = "父级门店编码"
    )
    private String parentStoreNo;

    @ApiModelProperty(
            name = "parentStoreName",
            value = "父级门店名称"
    )
    private String parentStoreName;

    @ApiModelProperty(
            name = "parentCreditCode",
            value = "父级门店信用代码"
    )
    private String parentCreditCode;

    @ApiModelProperty(
            name = "startCreateTime",
            value = "门店起始创建时间"
    )
    private Date startCreateTime;

    @ApiModelProperty(
            name = "endCreateTime",
            value = "门店结束创建时间"
    )
    private Date endCreateTime;

}
