package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.TbPersonPartnerRelReqDto;
import com.dtyunxi.tcbj.api.dto.response.StoreSalesmanRelationRespDto;
import com.dtyunxi.tcbj.api.dto.response.TbPersonPartnerRelRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 服务接口
 *
 * @author ghosn
 * @since 2023-04-06
 */
@Api(tags = {"报表中心：业务员服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-api-query-ITbPersonPartnerRelQueryApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/tbPersonPartnerRel",
        url = "${tcbj.center.report.api:}"
)
public interface ITbPersonPartnerRelQueryApi {

    /**
     * 根据id查询
     *
     * @param id id
     * @return 数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询", notes = "根据id查询")
    RestResponse<TbPersonPartnerRelRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 分页数据
     *
     * @param filter   查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "分页数据", notes = "根据filter查询条件查询数据，filter=TbPersonPartnerRelReqDto")
    RestResponse<PageInfo<TbPersonPartnerRelRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                  @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);



    @PostMapping("/queryPersonPartner")
    @ApiOperation(value = "查询业务员信息", notes = "根据filter查询条件查询数据，filter=TbPersonPartnerRelReqDto")
    RestResponse<List<TbPersonPartnerRelRespDto>> queryByPage(@RequestBody TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto);


    /**
     * 根据组织ID查询当前经销商关联业务员
     *
     * @param filter
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/salesman/page")
    @ApiOperation(value = "业务员分页数据", notes = "业务员分页数据")
    RestResponse<PageInfo<StoreSalesmanRelationRespDto>> querySalesmanByPage(@RequestParam("filter") String filter,
                                                                             @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                             @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
