/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.request.CargoOccupyReqDto;
import com.dtyunxi.tcbj.api.dto.request.MaterialReqDto;
import com.dtyunxi.tcbj.api.dto.response.CargoOccupyRespDto;
import com.dtyunxi.tcbj.api.dto.response.PreemptSourceNoRespDto;
import com.dtyunxi.tcbj.biz.service.query.IInventoryReportService;
import com.dtyunxi.tcbj.dao.das.CsInventoryPreemptionDas;
import com.dtyunxi.tcbj.dao.das.InCargoOccupyDas;
import com.dtyunxi.tcbj.dao.das.ItemsDas;
import com.dtyunxi.tcbj.dao.das.OrganizationDas;
import com.dtyunxi.tcbj.dao.eo.ItemEo;
import com.dtyunxi.tcbj.dao.eo.OrganizationEo;
import com.dtyunxi.tcbj.dao.vo.CargoOccupyVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class IInventoryReportServiceImpl
implements IInventoryReportService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private InCargoOccupyDas cargoOccupyDas;
    @Resource
    private OrganizationDas organizationDas;
    @Resource
    private ItemsDas itemsDas;
    @Resource
    private CsInventoryPreemptionDas csInventoryPreemptionDas;

    @Override
    public List<CargoOccupyRespDto> queryOrderCargoOccupy(CargoOccupyReqDto reqDto) {
        Assert.notNull((Object)reqDto.getTenantId(), (String)"\u7ec4\u7ec7id(tenantId)\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (CollectionUtils.isEmpty((Collection)reqDto.getMaterialList())) {
            return new ArrayList<CargoOccupyRespDto>(0);
        }
        OrganizationEo queryOrgEo = new OrganizationEo();
        queryOrgEo.setCode(reqDto.getTenantId());
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectOne((BaseEo)queryOrgEo);
        Assert.notNull((Object)organizationEo, (String)String.format("\u7ec4\u7ec7id=%s\u7684\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", reqDto.getTenantId()));
        List materialNoList = reqDto.getMaterialList().stream().map(MaterialReqDto::getMaterialNo).collect(Collectors.toList());
        ItemEo queryItemEo = new ItemEo();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.in((String)"code", materialNoList));
        queryItemEo.setSqlFilters((List)filterList);
        List itemEoList = this.itemsDas.select((BaseEo)queryItemEo);
        List longCodeList = Optional.ofNullable(itemEoList).orElseGet(Collections::emptyList).stream().map(ItemEo::getLongCode).collect(Collectors.toList());
        Map itemEoMap = Optional.ofNullable(itemEoList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(ItemEo::getLongCode, Function.identity(), (v1, v2) -> v2));
        CargoOccupyVo cargoOccupyVo = new CargoOccupyVo();
        cargoOccupyVo.setMaterialList(longCodeList);
        cargoOccupyVo.setOrganizationId(organizationEo.getId());
        List cargoOccupyEoList = this.csInventoryPreemptionDas.selectInventoryPreemption(cargoOccupyVo);
        List<CargoOccupyRespDto> occupyRespDtoList = Optional.ofNullable(cargoOccupyEoList).orElseGet(Collections::emptyList).stream().map(item -> {
            CargoOccupyRespDto cargoOccupyRespDto = new CargoOccupyRespDto();
            if (itemEoMap.get(item.getCargoCode()) != null) {
                ItemEo itemEo = (ItemEo)itemEoMap.get(item.getCargoCode());
                cargoOccupyRespDto.setMaterialNo(itemEo.getCode());
                cargoOccupyRespDto.setFreezeNum(Integer.valueOf(item.getPreemptNum().intValue()));
            }
            return cargoOccupyRespDto;
        }).collect(Collectors.toList());
        return occupyRespDtoList;
    }

    @Override
    public PageInfo<PreemptSourceNoRespDto> queryPreemptSourceNo(Integer pageNum, Integer pageSize, List<String> sourceNoList) {
        this.logger.info("\u67e5\u8be2\u9884\u5360\u8868\u53bb\u91cd\u540e\u5355\u53f7\u5165\u53c2pageNum\uff1a{}\uff0cpageSize\uff1a{}\uff0csourceNoList\uff1a{}", new Object[]{pageNum, pageSize, JSON.toJSONString(sourceNoList)});
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.cargoOccupyDas.queryPreemptSourceNo(sourceNoList);
        PageInfo pageInfo = new PageInfo(list);
        pageInfo.setList(list);
        return pageInfo;
    }
}

