/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.api.constant;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PaymentWayEnum {
    WFT_WX_GZH("0000", "0000", "\u6c64\u81e3\u500d\u5065", "901", "00001", "WX", new BigDecimal("0.00"), "h5"),
    WFT_ALIPLY_SM("0000", "0000", "\u6c64\u81e3\u500d\u5065", "902", "00001", "ZFB", new BigDecimal("0.00"), "h5"),
    WFT_UNIFY_SM("0000", "0000", "\u6c64\u81e3\u500d\u5065", "902", "00001", "ZX", new BigDecimal("0.00"), "web"),
    WFT_ALIPLY_YE("0000", "0000", "\u6c64\u81e3\u500d\u5065", "700", "110", "DJB", BigDecimal.ZERO, "all");

    public static final String WEB = "web";
    public static final String H5 = "h5";
    public static final String ALL = "all";
    private final String storeCode;
    private final String appCode;
    private final String appName;
    private final String payTypeCode;
    private final String payPartnerCode;
    private final String type;
    private final BigDecimal poundageRateMin;
    private final String supportTerminal;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    private PaymentWayEnum(String storeCode, String appCode, String appName, String payTypeCode, String payPartnerCode, String type, BigDecimal poundageRateMin, String supportTerminal) {
        this.storeCode = storeCode;
        this.appCode = appCode;
        this.appName = appName;
        this.payTypeCode = payTypeCode;
        this.payPartnerCode = payPartnerCode;
        this.type = type;
        this.poundageRateMin = poundageRateMin;
        this.supportTerminal = supportTerminal;
    }

    public String getStoreCode() {
        return this.storeCode;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getPayTypeCode() {
        return this.payTypeCode;
    }

    public String getPayPartnerCode() {
        return this.payPartnerCode;
    }

    public String getTypeStr() {
        return this.type;
    }

    public BigDecimal getPoundageRateMin() {
        return this.poundageRateMin;
    }

    public String getSupportTerminal() {
        return this.supportTerminal;
    }

    public <T> T toClass(Class<T> targetClass) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("storeCode", (Object)this.storeCode);
            jsonObject.put("appCode", (Object)this.appCode);
            jsonObject.put("appName", (Object)this.appName);
            jsonObject.put("payTypeCode", (Object)this.payTypeCode);
            jsonObject.put("payPartnerCode", (Object)this.payPartnerCode);
            jsonObject.put("type", (Object)this.type);
            jsonObject.put("poundageRateMin", (Object)this.poundageRateMin);
            jsonObject.put("supportTerminal", (Object)this.supportTerminal);
            return (T)JSONObject.parseObject((String)jsonObject.toString(), targetClass);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BizException("\u8f6c\u6362\u5f02\u5e38\uff01");
        }
    }

    public static PaymentWayEnum fromCode(String payTypeCode) {
        for (PaymentWayEnum typeEnum : PaymentWayEnum.values()) {
            if (!typeEnum.getPayTypeCode().equals(payTypeCode)) continue;
            return typeEnum;
        }
        return null;
    }
}

