/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.openapi.common.wms.enums;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum ExternalWmsServiceEnum {
    QIMEN_WMS("qm", Lists.newArrayList((Object[])new WmsMappingEnum[]{WmsMappingEnum.WZ, WmsMappingEnum.RQ})),
    RQ_WMS("rq", Lists.newArrayList());

    private final String serviceCode;
    private final List<WmsMappingEnum> codes;

    private ExternalWmsServiceEnum(String serviceCode, List<WmsMappingEnum> codes) {
        this.serviceCode = serviceCode;
        this.codes = codes;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public List<WmsMappingEnum> getCodes() {
        return this.codes;
    }

    public static ExternalWmsServiceEnum getByCode(String code) {
        return Arrays.stream(ExternalWmsServiceEnum.values()).filter(e -> e.getCodes().contains((Object)WmsMappingEnum.getByCode(code))).findFirst().orElse(null);
    }

    public static String getServiceCode(String code) {
        return Optional.ofNullable(ExternalWmsServiceEnum.getByCode(code)).map(ExternalWmsServiceEnum::getServiceCode).orElse("");
    }

    public static enum WmsMappingEnum {
        WZ("\u552f\u667aWMS", "\u552f\u667a"),
        RQ("\u8363\u5e86WMS", "\u8363\u5e86");

        private final String channelCode;
        private final String channelName;

        private WmsMappingEnum(String channelCode, String channelName) {
            this.channelCode = channelCode;
            this.channelName = channelName;
        }

        public String getChannelCode() {
            return this.channelCode;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public static WmsMappingEnum getByCode(String code) {
            return Arrays.stream(WmsMappingEnum.values()).filter(e -> e.getChannelCode().equals(code)).findFirst().orElse(null);
        }
    }
}

