/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.settlement.api.ISettlementApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.PaymentWayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.PoundageAgencyEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.PaymentBatchParamReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.PaymentOrderReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.PaymentWayRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRegisterRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.query.ISettlementAccountQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.query.ISettlementQueryApi;
import com.dtyunxi.tcbj.module.settlement.biz.dto.OrderPayDetailDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.BatchPayOrderReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.PayOrderReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.PaymentWayReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.response.OrderPaymentWayRespDto;
import com.dtyunxi.tcbj.module.settlement.biz.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.module.settlement.biz.service.PayOrderService;
import com.dtyunxi.tcbj.module.settlement.biz.service.SettlementAccountRegisterRelationService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.trade.ext.api.constants.OrderBizStatusTobEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderRespDto;
import com.dtyunxi.yundt.module.trade.biz.impl.OrderServiceImpl;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PayOrderServiceImpl
implements PayOrderService {
    private Logger logger = LoggerFactory.getLogger(PayOrderServiceImpl.class);
    @Value(value="${payControl:true}")
    private boolean payControl;
    @Resource
    private ISettlementApi settlementApi;
    @Resource
    private ISettlementQueryApi settlementQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private ISettlementAccountQueryApi settlementAccountQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private SettlementAccountRegisterRelationService settlementAccountRegisterRelationService;
    @Resource
    private OrderServiceImpl orderService;
    private static final Integer ONLINE_PAY = 1;
    private static final Integer BALANCE_PAY = 2;

    @Override
    public RestResponse<Object> unifyPay(PayOrderReqDto dto) {
        throw new BizException("\u65b9\u6cd5\u5df2\u5f03\u7528");
    }

    @Override
    public RestResponse<List<PaymentWayRespDto>> queryPaymentWay(String orderNo, String orgId, String cusId) {
        throw new BizException("\u65b9\u6cd5\u5df2\u5f03\u7528");
    }

    @Override
    public RestResponse<List<PaymentWayRespDto>> queryPaymentWayBatch(PaymentWayReqDto dto) {
        OrderPaymentWayRespDto response = (OrderPaymentWayRespDto)RestResponseHelper.extractData(this.queryOrderPaymentWay(dto));
        return new RestResponse(response.getPaymentWayList());
    }

    @Override
    public RestResponse<OrderPaymentWayRespDto> queryOrderPaymentWay(PaymentWayReqDto dto) {
        if (StringUtils.isNotBlank((CharSequence)dto.getTerminal())) {
            dto.setTerminal("h5");
        }
        OrderPaymentWayRespDto response = new OrderPaymentWayRespDto();
        ArrayList<OrderPayDetailDto> orderPayDetailList = new ArrayList<OrderPayDetailDto>();
        boolean ifRegister = false;
        for (String order : dto.getOrderNos()) {
            OrderPayDetailDto orderPayDetailDto = new OrderPayDetailDto();
            OrderRespDto orderDetail = this.orderService.getOrderDetail(order, null, new boolean[0]);
            if (ObjectUtils.isEmpty((Object)orderDetail)) {
                throw SettlementExceptionCode.UNIFY_PAY_ORDER_NOT_FOUND.buildBizException(orderDetail.getOrderNo());
            }
            if (ObjectUtils.isEmpty((Object)orderDetail.getOrgInfoId())) {
                throw SettlementExceptionCode.UNIFY_PAY_ORDER_NOT_FOUND_1.buildBizException(orderDetail.getOrderNo());
            }
            SettlementAccountRegisterRespDto accountRegister = (SettlementAccountRegisterRespDto)RestResponseHelper.extractData(this.settlementAccountRegisterRelationService.queryRegiAccForSwitch(null, orderDetail.getOrgInfoId().toString()));
            orderPayDetailDto.setIfRegisterStatus(0);
            if (this.payControl && ObjectUtils.isNotEmpty((Object)accountRegister) && StringUtils.isNotEmpty((CharSequence)accountRegister.getAccountNo())) {
                SettlementAccountRespDto account = (SettlementAccountRespDto)RestResponseHelper.extractData((RestResponse)this.settlementAccountQueryApi.queryByAccountNo(accountRegister.getAccountNo()));
                if (ObjectUtils.isNotEmpty((Object)account) && account.getAccountStatus().equals(SettlementAccountStatusEnum.ENABLED.getCode())) {
                    orderPayDetailDto.setIfRegisterStatus(1);
                    orderPayDetailDto.setPoundageAgency(account.getPoundageAgency());
                    ifRegister = true;
                } else {
                    orderPayDetailDto.setIfRegisterStatus(-1);
                }
            }
            orderPayDetailDto.setOrderNo(orderDetail.getOrderNo());
            orderPayDetailDto.setOrderAmount(orderDetail.getWaitPayAmount());
            orderPayDetailDto.setShopName(orderDetail.getShopName());
            orderPayDetailList.add(orderPayDetailDto);
        }
        if (!ifRegister) {
            response.setOrders(orderPayDetailList);
            response.setPaymentWayList(new ArrayList<PaymentWayRespDto>());
            return new RestResponse((Object)response);
        }
        ArrayList<PaymentWayRespDto> resList = new ArrayList<PaymentWayRespDto>((Collection)RestResponseHelper.extractData((RestResponse)this.settlementQueryApi.paymentWay("WX,ZFB,ZX", dto.getTerminal())));
        if (StringUtils.isNotEmpty((CharSequence)dto.getOrgId()) || StringUtils.isNotEmpty((CharSequence)dto.getCusId())) {
            SettlementAccountRespDto account;
            SettlementAccountRegisterRespDto accountRegister = null;
            try {
                accountRegister = (SettlementAccountRegisterRespDto)RestResponseHelper.extractData(this.settlementAccountRegisterRelationService.queryRegiAccForSwitch(dto.getCusId(), dto.getOrgId()));
            }
            catch (BizException e) {
                this.logger.error("\u83b7\u53d6\u8d26\u6237\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            }
            if (ObjectUtils.isNotEmpty((Object)accountRegister) && StringUtils.isNotEmpty((CharSequence)accountRegister.getAccountNo()) && ObjectUtils.isNotEmpty((Object)(account = (SettlementAccountRespDto)RestResponseHelper.extractData((RestResponse)this.settlementAccountQueryApi.queryByAccountNo(accountRegister.getAccountNo())))) && account.getAccountStatus().equals(SettlementAccountStatusEnum.ENABLED.getCode())) {
                resList.addAll((Collection)RestResponseHelper.extractData((RestResponse)this.settlementQueryApi.paymentWay("DJB", dto.getTerminal())));
            }
        }
        response.setOrders(this.buildOrderPayDetail(orderPayDetailList));
        response.setPaymentWayList(resList);
        return new RestResponse((Object)response);
    }

    @Override
    public RestResponse<Object> unifyPayBatch(BatchPayOrderReqDto dto) {
        this.logger.info("\u6267\u884c\u6279\u91cf\u652f\u4ed8\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        ArrayList paymentOrderReqDtos = Lists.newArrayList();
        dto.getBatchOrderNos().stream().distinct().forEach(e -> paymentOrderReqDtos.add(this.checkAndQueryPaymentOrderReqDto(dto, (String)e)));
        if (CollectionUtils.isEmpty((Collection)paymentOrderReqDtos)) {
            throw SettlementExceptionCode.UNIFY_PAY_ORDER_LIST_NULL.buildBizException();
        }
        PaymentBatchParamReqDto paramReqDto = this.buildPaymentBatchParamReqDto(dto);
        paramReqDto.setPaymentOrderList((List)paymentOrderReqDtos);
        if (dto.getPaymentType().intValue() == ONLINE_PAY.intValue()) {
            return this.settlementApi.paymentBatchOfOnline(paramReqDto);
        }
        if (dto.getPaymentType().intValue() == BALANCE_PAY.intValue()) {
            SettlementAccountRegisterRespDto buyerAccountRegister = (SettlementAccountRegisterRespDto)RestResponseHelper.extractData(this.settlementAccountRegisterRelationService.queryRegiAccForSwitch(dto.getOptCustomerId(), dto.getOptOrgId()));
            if (ObjectUtils.isEmpty((Object)buyerAccountRegister) || StringUtils.isEmpty((CharSequence)buyerAccountRegister.getAccountNo())) {
                throw SettlementExceptionCode.UNIFY_PAY_ACCOUNT_REGISTER_NOT_FOUND_ERROR.buildBizException();
            }
            SettlementAccountRespDto buyerAccount = (SettlementAccountRespDto)RestResponseHelper.extractData((RestResponse)this.settlementAccountQueryApi.queryByAccountNo(buyerAccountRegister.getAccountNo()));
            if (ObjectUtils.isEmpty((Object)buyerAccount) || !buyerAccount.getAccountStatus().equals(SettlementAccountStatusEnum.ENABLED.getCode())) {
                throw SettlementExceptionCode.UNIFY_PAY_ACCOUNT_REGISTER_STATUS_ERROR.buildBizException();
            }
            paramReqDto.setPassword(dto.getPayPassword());
            paramReqDto.setChargeOffAccountOrgId(buyerAccountRegister.getOrganizationId());
            paramReqDto.setChargeOffAccount(buyerAccount.getAccountNo());
            paramReqDto.setChargeOffAccountName(buyerAccount.getAccountName());
            paramReqDto.setChargeOffAccountType(buyerAccount.getAccountType());
            return this.settlementApi.paymentBatchOfBalance(paramReqDto);
        }
        throw SettlementExceptionCode.UNIFY_PAY_PAY_TYPE_NOT_FOUND.buildBizException();
    }

    private PaymentBatchParamReqDto buildPaymentBatchParamReqDto(BatchPayOrderReqDto dto) {
        PaymentBatchParamReqDto paramReqDto = new PaymentBatchParamReqDto();
        paramReqDto.setServiceChargeRate(dto.getPaymentWayReqDto().getPoundageRate());
        paramReqDto.setUserId(this.context.userId());
        paramReqDto.setUserName(this.context.userName());
        paramReqDto.setUserType(null);
        paramReqDto.setPaymentWayReqDto(dto.getPaymentWayReqDto());
        paramReqDto.setExpireTime(Integer.valueOf(120));
        return paramReqDto;
    }

    private PaymentOrderReqDto checkAndQueryPaymentOrderReqDto(BatchPayOrderReqDto dto, String e) {
        this.logger.info("checkAndQueryPaymentOrderReqDto\uff1a{}=={}", (Object)e, (Object)JSON.toJSONString((Object)dto));
        OrderRespDto orderDetail = this.orderService.getOrderDetail(e, null, new boolean[0]);
        if (ObjectUtils.isEmpty((Object)orderDetail) || StringUtils.isEmpty((CharSequence)orderDetail.getOrderNo())) {
            throw SettlementExceptionCode.UNIFY_PAY_ORDER_NOT_FOUND.buildBizException(orderDetail.getOrderNo());
        }
        if (ObjectUtils.isEmpty((Object)orderDetail.getWaitPayAmount()) || orderDetail.getWaitPayAmount().compareTo(BigDecimal.ZERO) < 1) {
            throw SettlementExceptionCode.UNIFY_PAY_ORDER_AMOUNT_ERROR.buildBizException(orderDetail.getOrderNo());
        }
        if (!OrderBizStatusTobEnum.WAIT_PAY.getCode().equals(orderDetail.getOrderTradeStatus())) {
            throw SettlementExceptionCode.UNIFY_PAY_ORDER_STATUS_ERROR.buildBizException(orderDetail.getOrderNo());
        }
        PaymentWayRespDto paymentWayRespDto = (PaymentWayRespDto)RestResponseHelper.extractData((RestResponse)this.settlementQueryApi.queryPaymentWay(dto.getPaymentWayReqDto().getPayTypeCode(), null));
        if (ObjectUtils.isEmpty((Object)paymentWayRespDto)) {
            this.logger.info("\u8be5\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728\uff1a{}", (Object)JSON.toJSONString((Object)dto.getPaymentWayReqDto()));
            throw new BizException("-1", "\u8be5\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728\uff01");
        }
        dto.getPaymentWayReqDto().setPoundageRate(paymentWayRespDto.getPoundageRate());
        dto.getPaymentWayReqDto().setPoundageRateMin(paymentWayRespDto.getPoundageRateMin());
        SettlementAccountRegisterRespDto accountRegisterDto = (SettlementAccountRegisterRespDto)RestResponseHelper.extractData(this.settlementAccountRegisterRelationService.queryRegiAccForSwitch(null, orderDetail.getOrgInfoId().toString()));
        if (ObjectUtils.isEmpty((Object)accountRegisterDto) || StringUtils.isEmpty((CharSequence)accountRegisterDto.getAccountNo())) {
            throw SettlementExceptionCode.UNIFY_PAY_ORDER_ACCOUNT_REGISTER_NOT_FOUND_ERROR.buildBizException(orderDetail.getOrderNo());
        }
        SettlementAccountRespDto accountRespDto = (SettlementAccountRespDto)RestResponseHelper.extractData((RestResponse)this.settlementAccountQueryApi.queryByAccountNo(accountRegisterDto.getAccountNo()));
        if (ObjectUtils.isEmpty((Object)accountRespDto) || !accountRespDto.getAccountStatus().equals(SettlementAccountStatusEnum.ENABLED.getCode())) {
            throw SettlementExceptionCode.UNIFY_PAY_ORDER_ACCOUNT_REGISTER_STATUS_ERROR.buildBizException(orderDetail.getOrderNo());
        }
        PaymentOrderReqDto paramReqDto = new PaymentOrderReqDto();
        paramReqDto.setOrderNo(orderDetail.getOrderNo());
        paramReqDto.setLaunchAmount(orderDetail.getWaitPayAmount().setScale(2, 1));
        paramReqDto.setRecordedAccount(accountRespDto.getAccountNo());
        paramReqDto.setRecordedAccountName(accountRespDto.getAccountName());
        paramReqDto.setRecordedAccountType(accountRespDto.getAccountType());
        paramReqDto.setPoundageAgency(accountRespDto.getPoundageAgency());
        PaymentWayEnum payWayEnum = PaymentWayEnum.fromCode((String)dto.getPaymentWayReqDto().getPayTypeCode());
        if (paramReqDto.getPoundageAgency().intValue() == PoundageAgencyEnum.SELLER.getCode().intValue()) {
            paramReqDto.setPoundageAmount(BigDecimal.ZERO);
        } else {
            paramReqDto.setPoundageAmount(this.calculateFee(orderDetail.getWaitPayAmount(), payWayEnum));
        }
        paramReqDto.setTradeAmount(paramReqDto.getLaunchAmount().add(paramReqDto.getPoundageAmount()));
        paramReqDto.setTradePayParnterPoundage(this.calculateFee(paramReqDto.getTradeAmount(), payWayEnum));
        return paramReqDto;
    }

    private List<OrderPayDetailDto> buildOrderPayDetail(List<OrderPayDetailDto> list) {
        PaymentWayEnum[] paymentWayEnums = PaymentWayEnum.values();
        list.forEach(dto -> {
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            if (ObjectUtils.isEmpty((Object)dto.getPoundageAgency()) || dto.getPoundageAgency().intValue() == PoundageAgencyEnum.SELLER.getCode().intValue()) {
                for (PaymentWayEnum wayEnum : paymentWayEnums) {
                    map.put(wayEnum.getPayTypeCode().concat(wayEnum.getPayPartnerCode()), BigDecimal.ZERO);
                }
            } else {
                for (PaymentWayEnum wayEnum : paymentWayEnums) {
                    BigDecimal fee = this.calculateFee(dto.getOrderAmount(), wayEnum);
                    map.put(wayEnum.getPayTypeCode().concat(wayEnum.getPayPartnerCode()), fee);
                }
            }
            dto.setPayWays(map);
        });
        return list;
    }

    private BigDecimal calculateFee(BigDecimal originalAmount, PaymentWayEnum paymentWayEnum) {
        if (paymentWayEnum == null) {
            throw new BizException("-1", "\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570paymentWayEnum\u5fc5\u4f20");
        }
        PaymentWayRespDto paymentWayRespDto = (PaymentWayRespDto)RestResponseHelper.extractData((RestResponse)this.settlementQueryApi.queryPaymentWay(paymentWayEnum.getPayTypeCode(), null));
        BigDecimal poundageRate = paymentWayRespDto.getPoundageRate();
        if (ObjectUtils.isEmpty((Object)originalAmount) || originalAmount.compareTo(BigDecimal.ZERO) == 0 || poundageRate.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal fee = poundageRate.multiply(originalAmount).setScale(2, 4);
        if (fee.compareTo(paymentWayEnum.getPoundageRateMin()) <= 0) {
            fee = paymentWayEnum.getPoundageRateMin();
        }
        return fee;
    }
}

