/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ISplitLogApi;
import com.dtyunxi.tcbj.api.dto.response.CiticSplitAmountResDto;
import com.dtyunxi.tcbj.api.dto.response.QuerySplitLogAmountRespDto;
import com.dtyunxi.tcbj.api.dto.response.QuerySplitLogDealerRespDto;
import com.dtyunxi.tcbj.center.settlement.api.ICupTradeApi;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.CupSplitAmountReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.QuerySplitLogResDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.response.QuerySplitLogAmountMergeRespDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.response.QuerySplitLogRespDto;
import com.dtyunxi.tcbj.module.settlement.biz.service.ISplitLogService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ISplitLogServiceImpl
implements ISplitLogService {
    private static final Logger log = LogManager.getLogger(ISplitLogServiceImpl.class);
    @Resource
    private ISplitLogApi splitLogApi;
    @Resource
    private ICupTradeApi cupTradeApi;

    @Override
    public QuerySplitLogRespDto querySplitLog(QuerySplitLogResDto reqDto) {
        log.info("\u652f\u4ed8\u4e2d\u5fc3--\u6309\u65e5\u7edf\u8ba1\u603b\u989d\u5bf9\u8d26\u529f\u80fd reqDto={}", (Object)JSON.toJSONString((Object)reqDto));
        QuerySplitLogRespDto result = new QuerySplitLogRespDto();
        List CupTradeFlowRecordRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.cupTradeApi.cupSplitAmount(CupSplitAmountReqDto.builder().tradeDateList(this.getTradeDateList(reqDto, false)).build()));
        log.info("\u94f6\u8054\u548c\u4e2d\u4fe1\u91d1\u989d\u5bf9\u8d26-\u94f6\u8054\u91d1\u989d CupTradeFlowRecordRespDtos={}", (Object)JSON.toJSONString((Object)CupTradeFlowRecordRespDtos));
        if (CupTradeFlowRecordRespDtos != null && !CupTradeFlowRecordRespDtos.isEmpty()) {
            result.setCupSplitAmountList(CupTradeFlowRecordRespDtos);
        } else {
            result.setCupSplitAmountList(new ArrayList<com.dtyunxi.tcbj.center.settlement.api.dto.response.QuerySplitLogAmountRespDto>());
        }
        List SplitOrderEos = (List)RestResponseHelper.extractData((RestResponse)this.splitLogApi.citicSplitAmount(CiticSplitAmountResDto.builder().tradeDateList(this.getTradeDateList(reqDto, true)).build()));
        log.info("\u94f6\u8054\u548c\u4e2d\u4fe1\u91d1\u989d\u5bf9\u8d26-\u4e2d\u4fe1\u6e05\u5206\u91d1\u989d SplitOrderEos={}", (Object)JSON.toJSONString((Object)SplitOrderEos));
        if (SplitOrderEos != null && !SplitOrderEos.isEmpty()) {
            result.setCiticSplitAmountList(SplitOrderEos);
        } else {
            result.setCiticSplitAmountList(new ArrayList<QuerySplitLogAmountRespDto>());
        }
        this.setReconciliationStatus(result);
        List dealerSplitList = (List)RestResponseHelper.extractData((RestResponse)this.splitLogApi.dealerSplitList(CiticSplitAmountResDto.builder().tradeDateList(this.getTradeDateList(reqDto, true)).build()));
        log.info("\u94f6\u8054\u548c\u4e2d\u4fe1\u91d1\u989d\u5bf9\u8d26-\u4e2d\u4fe1\u5206\u8d26\u7ecf\u9500\u5546\u5217\u8868 dealerSplitList={}", (Object)JSON.toJSONString((Object)dealerSplitList));
        if (dealerSplitList != null && !dealerSplitList.isEmpty()) {
            result.setDealerSplitList(dealerSplitList);
        } else {
            result.setDealerSplitList(new ArrayList<QuerySplitLogDealerRespDto>());
        }
        this.dateFormate(result);
        this.mergeDataList(result);
        if (result.getAmountMergeRespDto() == null) {
            result.setAmountMergeRespDto(new ArrayList<QuerySplitLogAmountMergeRespDto>());
        }
        return result;
    }

    private void mergeDataList(QuerySplitLogRespDto result) {
        if (result.getCiticSplitAmountList() == null || result.getCiticSplitAmountList().isEmpty()) {
            return;
        }
        if (result.getCupSplitAmountList() == null || result.getCupSplitAmountList().isEmpty()) {
            return;
        }
        List<QuerySplitLogAmountMergeRespDto> mergeRespDtos = result.getCiticSplitAmountList().stream().map(e -> QuerySplitLogAmountMergeRespDto.builder().date(e.getDate()).status(e.getStatus()).citicAmount(e.getAmount()).cupAmount("-").build()).collect(Collectors.toList());
        Map<String, QuerySplitLogAmountMergeRespDto> mergeRespMap = mergeRespDtos.stream().collect(Collectors.toMap(QuerySplitLogAmountMergeRespDto::getDate, e -> e));
        for (com.dtyunxi.tcbj.center.settlement.api.dto.response.QuerySplitLogAmountRespDto cupSplitAmount : result.getCupSplitAmountList()) {
            if (cupSplitAmount.getDate() == null) continue;
            QuerySplitLogAmountMergeRespDto citicSplitAmount = mergeRespMap.get(cupSplitAmount.getDate().replace("-", ""));
            if (citicSplitAmount == null) {
                mergeRespDtos.add(QuerySplitLogAmountMergeRespDto.builder().date(cupSplitAmount.getDate()).status(cupSplitAmount.getStatus()).citicAmount("-").cupAmount(cupSplitAmount.getAmount()).build());
                continue;
            }
            citicSplitAmount.setCupAmount(cupSplitAmount.getAmount());
        }
        mergeRespDtos.sort(Comparator.comparing(QuerySplitLogAmountMergeRespDto::getDate));
        result.setAmountMergeRespDto(mergeRespDtos);
        result.setCiticSplitAmountList(null);
        result.setCupSplitAmountList(null);
    }

    private void setReconciliationStatus(QuerySplitLogRespDto result) {
        if (result.getCupSplitAmountList() == null || result.getCupSplitAmountList().isEmpty()) {
            return;
        }
        if (result.getCiticSplitAmountList() == null || result.getCiticSplitAmountList().isEmpty()) {
            return;
        }
        Map<String, QuerySplitLogAmountRespDto> citicSplitAmountMap = result.getCiticSplitAmountList().stream().collect(Collectors.toMap(QuerySplitLogAmountRespDto::getDate, e -> e));
        for (com.dtyunxi.tcbj.center.settlement.api.dto.response.QuerySplitLogAmountRespDto cupSplitAmount : result.getCupSplitAmountList()) {
            QuerySplitLogAmountRespDto citicSplitAmount;
            if (cupSplitAmount.getDate() == null || (citicSplitAmount = citicSplitAmountMap.get(cupSplitAmount.getDate().replace("-", ""))) == null || new BigDecimal(citicSplitAmount.getAmount()).compareTo(new BigDecimal(cupSplitAmount.getAmount())) != 0) continue;
            cupSplitAmount.setStatus("\u5df2\u5bf9\u8d26");
            citicSplitAmount.setStatus("\u5df2\u5bf9\u8d26");
        }
    }

    private List<String> getTradeDateList(QuerySplitLogResDto reqDto, boolean needTrim) {
        List<String> betweenDate = this.getBetweenDate(reqDto.getStartDate(), reqDto.getEndDate());
        if (needTrim) {
            return betweenDate.stream().map(e -> e.replace("-", "")).collect(Collectors.toList());
        }
        return betweenDate;
    }

    private List<String> getBetweenDate(String start, String end) {
        LocalDate endDate;
        ArrayList<String> list = new ArrayList<String>();
        LocalDate startDate = LocalDate.parse(start);
        long distance = ChronoUnit.DAYS.between(startDate, endDate = LocalDate.parse(end));
        if (distance < 1L) {
            list.add(startDate.toString());
            return list;
        }
        Stream.iterate(startDate, d -> d.plusDays(1L)).limit(distance + 1L).forEach(f -> list.add(f.toString()));
        return list;
    }

    private void dateFormate(QuerySplitLogRespDto result) {
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat outPutFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        if (result.getCupSplitAmountList() != null) {
            result.getCupSplitAmountList().forEach(e -> {
                try {
                    Date date = inputFormat.parse(e.getDate().replace("-", ""));
                    e.setDate(outPutFormat.format(date));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (result.getCiticSplitAmountList() != null) {
            result.getCiticSplitAmountList().forEach(e -> {
                try {
                    Date date = inputFormat.parse(e.getDate().replace("-", ""));
                    e.setDate(outPutFormat.format(date));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (result.getDealerSplitList() != null) {
            result.getDealerSplitList().forEach(e -> {
                try {
                    Date date = inputFormat.parse(e.getSplitDt().replace("-", ""));
                    e.setSplitDt(outPutFormat.format(date));
                    StringBuilder sb = new StringBuilder();
                    String[] splitStrs = e.getSplitDtSet().split(",");
                    List strList = Arrays.stream(splitStrs).sorted().collect(Collectors.toList());
                    for (String s : strList) {
                        Date date2 = inputFormat.parse(s.replace("-", ""));
                        sb.append(outPutFormat.format(date2)).append(",");
                    }
                    String sbStr = sb.substring(0, sb.length() - 1);
                    e.setSplitDtSet(sbStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }
}

