/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.settlement.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.enums.citic.CiticUserTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.IProtocolSignApi;
import com.dtyunxi.tcbj.center.settlement.api.ISettlementAccountRegisterRelationApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.BusinessLicenseTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.ProtocolSignAgreeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.ProtocolTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettleAccOrgTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.ParentOrgInfoDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.ProtocolSignReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountRegisterReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.ProtocolInfoRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.ProtocolSignRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRegisterRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementRootAccountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.query.IProtocolInfoQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.query.IProtocolSignQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.query.ISettlemenRootAccountQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.query.ISettlementAccountRegisterRelationQueryApi;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.ResignProtocolReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.response.ResignProtocolRespDto;
import com.dtyunxi.tcbj.module.settlement.biz.service.SettlementAccountRegisterRelationService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.OrgInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class SettlementAccountRegisterRelationServiceImpl
implements SettlementAccountRegisterRelationService {
    private static final Logger logger = LoggerFactory.getLogger(SettlementAccountRegisterRelationServiceImpl.class);
    @Resource
    private ISettlementAccountRegisterRelationQueryApi iSettlementAccountRegisterRelationQueryApi;
    @Resource
    private ISettlementAccountRegisterRelationApi iSettlementAccountRegisterRelationApi;
    @Resource
    private IOrganizationQueryExtApi iOrganizationQueryExtApi;
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IEmployeeQueryApi employeeQueryApi;
    @Resource
    private IProtocolSignApi protocolSignApi;
    @Resource
    private IProtocolSignQueryApi protocolSignQueryApi;
    @Resource
    private IProtocolInfoQueryApi protocolInfoQueryApi;
    @Resource
    private ISettlemenRootAccountQueryApi rootAccountQueryApi;

    @Override
    public RestResponse<SettlementAccountRegisterRespDto> queryByOrgId(SettlementAccountRegisterReqDto settlementAccountRegisterReqDto) {
        CustomerRespDto oneDto = (CustomerRespDto)this.iCustomerExtQueryApi.queryOneByOrgId(Long.valueOf(settlementAccountRegisterReqDto.getOrganizationId())).getData();
        if (oneDto == null) {
            throw new BizException("\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a");
        }
        CustomerRespDto cusDto = (CustomerRespDto)this.iCustomerExtQueryApi.queryById(oneDto.getId()).getData();
        if (cusDto == null) {
            throw new BizException("\u7ec4\u7ec7\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        settlementAccountRegisterReqDto.setOrganizationType(cusDto.getType());
        if (SettleAccOrgTypeEnum.DEALER.getCode().equals(settlementAccountRegisterReqDto.getOrganizationType())) {
            settlementAccountRegisterReqDto.setOrganizationCreditCode(cusDto.getCompanyInfoDto().getCreditCode());
        }
        return this.iSettlementAccountRegisterRelationQueryApi.queryByOrgId(settlementAccountRegisterReqDto);
    }

    @Override
    public RestResponse<List<SettlementAccountRegisterRespDto>> queryByOrgIdBatch(List<Long> orgIdList) {
        ArrayList<SettlementAccountRegisterReqDto> list = new ArrayList<SettlementAccountRegisterReqDto>();
        for (Long orgId : orgIdList) {
            SettlementAccountRegisterReqDto settlementAccountRegisterReqDto = new SettlementAccountRegisterReqDto();
            settlementAccountRegisterReqDto.setOrganizationId(orgId);
            CustomerRespDto oneDto = (CustomerRespDto)this.iCustomerExtQueryApi.queryOneByOrgId(orgId).getData();
            if (oneDto == null) {
                throw new BizException("\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a");
            }
            CustomerRespDto cusDto = (CustomerRespDto)this.iCustomerExtQueryApi.queryById(oneDto.getId()).getData();
            if (cusDto == null) {
                throw new BizException("\u7ec4\u7ec7\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a");
            }
            settlementAccountRegisterReqDto.setOrganizationType(cusDto.getType());
            if (SettleAccOrgTypeEnum.DEALER.getCode().equals(settlementAccountRegisterReqDto.getOrganizationType())) {
                settlementAccountRegisterReqDto.setOrganizationCreditCode(cusDto.getCompanyInfoDto().getCreditCode());
            }
            list.add(settlementAccountRegisterReqDto);
        }
        return this.iSettlementAccountRegisterRelationQueryApi.queryByOrgIdBatch(list);
    }

    @Override
    public RestResponse<Long> addSettlementAccountRegister(SettlementAccountRegisterReqDto settlementAccountRegisterReqDto) {
        Long customerid = settlementAccountRegisterReqDto.getCustomerId();
        Long curOrgId = settlementAccountRegisterReqDto.getOrganizationId();
        CustomerRespDto cusDto = null;
        if (ObjectUtils.isEmpty((Object)customerid) && ObjectUtils.isEmpty((Object)curOrgId)) {
            throw new BizException("\u7ec4\u7ec7\u5ba2\u6237ID\u4e3a\u7a7a");
        }
        if (!ObjectUtils.isEmpty((Object)customerid)) {
            cusDto = (CustomerRespDto)this.iCustomerExtQueryApi.queryById(customerid).getData();
        } else if (!ObjectUtils.isEmpty((Object)curOrgId)) {
            cusDto = (CustomerRespDto)this.iCustomerExtQueryApi.queryOneByOrgId(curOrgId).getData();
        }
        if (cusDto == null) {
            throw new BizException("\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5728\u5ba2\u5546\u6863\u6848\u5904\u7ef4\u62a4");
        }
        if (!ObjectUtils.isEmpty((Object)customerid)) {
            curOrgId = cusDto.getOrgInfoId();
        }
        logger.info("\u83b7\u53d6\u5230\u5ba2\u6237\u6570\u636e-\u5ba2\u5546\uff0corgId={}\uff0ccusDto={}", (Object)customerid, (Object)JSON.toJsonString((Object)cusDto));
        settlementAccountRegisterReqDto.setOrganizationId(curOrgId);
        settlementAccountRegisterReqDto.setOrganizationType(cusDto.getType());
        settlementAccountRegisterReqDto.setCustomerOrgCode(cusDto.getCode());
        OrgAdvDetailRespDto orgDto = (OrgAdvDetailRespDto)this.iOrganizationQueryExtApi.queryById(curOrgId).getData();
        logger.info("\u83b7\u53d6\u5230\u7ec4\u7ec7\u6570\u636e\uff0ccurOrgId={}\uff0corgDto={}", (Object)curOrgId, (Object)JSON.toJsonString((Object)orgDto));
        if (orgDto == null) {
            throw new BizException("\u7ec4\u7ec7\u8be6\u60c5\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (!(CiticUserTypeEnum.PERSONAL.getKey().equals(String.valueOf(settlementAccountRegisterReqDto.getRegisterType())) || orgDto.getOrgAdvInfoRespDto() != null && orgDto.getOrgAdvInfoRespDto().getCreditCode() != null)) {
            throw new BizException("\u7ec4\u7ec7\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5ba2\u5546\u6863\u6848\u4fe1\u606f\u7ef4\u62a4\u540e\u518d\u7533\u8bf7\u8fdb\u4ef6");
        }
        if (CustomerTypeEnum.RETAILER.getCode().equals(cusDto.getType())) {
            List parOrgIdList = (List)RestResponseHelper.extractData((RestResponse)this.iCustomerExtQueryApi.queryUpperOrgIdsByOrgId(curOrgId));
            ArrayList<ParentOrgInfoDto> parOrgMapList = new ArrayList<ParentOrgInfoDto>();
            for (Long parOrgId : parOrgIdList) {
                OrgAdvDetailRespDto parentOrgDto = (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)this.iOrganizationQueryExtApi.queryById(parOrgId));
                if (parentOrgDto.getOrgAdvInfoRespDto() == null) continue;
                ParentOrgInfoDto porgDto = new ParentOrgInfoDto();
                porgDto.setOrganizationId(parOrgId);
                porgDto.setOrganizationCreditCode(parentOrgDto.getOrgAdvInfoRespDto().getCreditCode());
                porgDto.setOrganizationType(SettleAccOrgTypeEnum.DEALER.getCode());
                parOrgMapList.add(porgDto);
            }
            settlementAccountRegisterReqDto.setParOrgList(parOrgMapList);
        } else if (CustomerTypeEnum.DEALER.getCode().equals(cusDto.getType())) {
            settlementAccountRegisterReqDto.setRegisterName(orgDto.getOrgAdvInfoRespDto().getOrgName());
            settlementAccountRegisterReqDto.setOrganizationCreditCode(orgDto.getOrgAdvInfoRespDto().getCreditCode());
            settlementAccountRegisterReqDto.setLegalName(orgDto.getOrgAdvInfoRespDto().getLegalName());
            settlementAccountRegisterReqDto.setLegalIdCard(orgDto.getOrgAdvInfoRespDto().getLegalCardNum());
        }
        RestResponse restResponse = this.iSettlementAccountRegisterRelationApi.addSettlementAccountRegister(settlementAccountRegisterReqDto);
        return restResponse;
    }

    @Override
    public RestResponse<Integer> modifySettlementAccountRegister(SettlementAccountRegisterReqDto settlementAccountRegisterReqDto) {
        OrgAdvDetailRespDto orgDto = (OrgAdvDetailRespDto)this.iOrganizationQueryExtApi.queryById(settlementAccountRegisterReqDto.getOrganizationId()).getData();
        if (orgDto == null) {
            throw new BizException("\u5f53\u524d\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (!CiticUserTypeEnum.PERSONAL.getKey().equals(settlementAccountRegisterReqDto.getRegisterType().toString())) {
            if (orgDto.getOrgAdvInfoRespDto() == null) {
                throw new BizException("\u5f53\u524d\u7ec4\u7ec7\u8be6\u60c5\u4fe1\u606f\u4e3a\u7a7a,\u65e0\u6cd5\u91cd\u65b0\u83b7\u53d6\u4f01\u4e1a\u540d\u79f0\u3001\u4f01\u4e1a\u6cd5\u4eba\u3001\u6cd5\u4eba\u8eab\u4efd\u8bc1\u53f7\u7801\uff0c\u91cd\u65b0\u4fee\u6539\u5931\u8d25");
            }
            settlementAccountRegisterReqDto.setRegisterName(orgDto.getOrgAdvInfoRespDto().getOrgName());
            settlementAccountRegisterReqDto.setLegalName(orgDto.getOrgAdvInfoRespDto().getLegalName());
            settlementAccountRegisterReqDto.setLegalIdCard(orgDto.getOrgAdvInfoRespDto().getLegalCardNum());
        }
        return this.iSettlementAccountRegisterRelationApi.modifySettlementAccountRegister(settlementAccountRegisterReqDto);
    }

    @Override
    public RestResponse<Void> removeSettlementAccountRegister(@PathVariable(value="ids") String ids, @RequestParam(value="instanceId") Long instanceId) {
        return null;
    }

    @Override
    public RestResponse<SettlementAccountRegisterRespDto> queryRegisterAccountByOrgId(String curOrgId) {
        if (StringUtils.isEmpty((CharSequence)curOrgId)) {
            throw new BizException("\u7ec4\u7ec7\u5ba2\u6237ID\u4e3a\u7a7a");
        }
        CustomerRespDto oneDto = (CustomerRespDto)this.iCustomerExtQueryApi.queryOneByOrgId(Long.valueOf(curOrgId)).getData();
        if (oneDto == null) {
            throw new BizException("\u627e\u4e0d\u5230\u8be5\u5ba2\u6237\u4fe1\u606f\u901a\u8fc7\u7ec4\u7ec7id\u3010" + curOrgId + "\u3011");
        }
        return this.queryRegisterAccountByCustomerId(oneDto.getId().toString());
    }

    @Override
    public RestResponse<SettlementAccountRegisterRespDto> queryRegisterAccountByCustomerId(String customerid) {
        SettlementAccountRegisterRespDto sRespDto = null;
        if (StringUtils.isEmpty((CharSequence)customerid)) {
            throw new BizException("\u7ec4\u7ec7\u5ba2\u6237ID\u4e3a\u7a7a");
        }
        try {
            RestResponse sResp;
            RestResponse customerExtDetailResp = this.iCustomerExtQueryApi.queryById(Long.valueOf(customerid));
            CustomerExtDetailRespDto cusDto = (CustomerExtDetailRespDto)RestResponseHelper.extractData((RestResponse)customerExtDetailResp);
            logger.info("\u83b7\u53d6\u5230\u5ba2\u6237\u6570\u636e\uff0corgId={}\uff0ccusDto={}", (Object)customerid, (Object)JSON.toJsonString((Object)cusDto));
            if (cusDto == null) {
                throw new BizException("\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a\u901a\u8fc7\u5ba2\u6237id\u3010" + customerid + "\u3011" + customerExtDetailResp.toString());
            }
            Long curOrgId = cusDto.getOrgInfoId();
            SettlementAccountRegisterReqDto sReqDto = new SettlementAccountRegisterReqDto();
            sReqDto.setOrganizationId(curOrgId);
            sReqDto.setOrganizationType(cusDto.getType());
            if (SettleAccOrgTypeEnum.DEALER.getCode().equals(cusDto.getType())) {
                if (cusDto.getCompanyInfoDto() == null || cusDto.getCompanyInfoDto().getOrgCode() == null) {
                    throw new BizException("\u7ec4\u7ec7\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u7ecf\u9500\u5546\u7ef4\u62a4\u5ba2\u6237\u6863\u6848\u4fe1\u606f\u540e\u518d\u7533\u8bf7\u8fdb\u4ef6");
                }
                sReqDto.setOrganizationCreditCode(cusDto.getCompanyInfoDto().getCreditCode());
            }
            if (ObjectUtils.isNotEmpty((Object)(sRespDto = (SettlementAccountRegisterRespDto)RestResponseHelper.extractData((RestResponse)(sResp = this.iSettlementAccountRegisterRelationQueryApi.queryByOrgId(sReqDto)))))) {
                ProtocolSignReqDto proReqDto = new ProtocolSignReqDto();
                proReqDto.setBusinessId(sRespDto.getId());
                RestResponse proResp = this.protocolSignQueryApi.queryByPage(JSON.toJsonString((Object)proReqDto), Integer.valueOf(1), Integer.valueOf(10));
                PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)proResp);
                if (ObjectUtils.isNotEmpty((Object)pageInfo.getList()) && pageInfo.getList().size() > 0) {
                    Date lastestDate = ((ProtocolSignRespDto)pageInfo.getList().get(0)).getCreateTime();
                    sRespDto.setProtocolId(((ProtocolSignRespDto)pageInfo.getList().get(0)).getProtocolId());
                    for (ProtocolSignRespDto signDto : pageInfo.getList()) {
                        if (lastestDate.compareTo(signDto.getCreateTime()) < 0) continue;
                        sRespDto.setProtocolId(signDto.getProtocolId());
                    }
                }
            } else {
                RestResponse protRestResp;
                ProtocolInfoRespDto protocolInfoRespDto;
                sRespDto = new SettlementAccountRegisterRespDto();
                if (cusDto.getCompanyInfoDto() != null && cusDto.getCompanyInfoDto().getOrgCode() != null) {
                    sRespDto.setLegalName(cusDto.getCompanyInfoDto().getLegalName());
                    sRespDto.setLegalIdCard(cusDto.getCompanyInfoDto().getLegalCardNum());
                    sRespDto.setRegisterName(cusDto.getCompanyInfoDto().getOrgName());
                    sRespDto.setOrganizationCreditCode(cusDto.getCompanyInfoDto().getCreditCode());
                    if (!ObjectUtils.isEmpty((Object)cusDto.getCompanyInfoDto().getBusinessLicenseType()) && cusDto.getCompanyInfoDto().getBusinessLicenseType().equals(BusinessLicenseTypeEnum.BUSINESS_LICENSE.getCode())) {
                        sRespDto.setBusinessLicenseNo(cusDto.getCompanyInfoDto().getCreditCode());
                    }
                }
                if (CustomerTypeEnum.DEALER.getCode().equals(cusDto.getType())) {
                    sRespDto.setRegisterType(Integer.valueOf(Integer.parseInt(CiticUserTypeEnum.CORP.getKey())));
                }
                if (ObjectUtils.isNotEmpty((Object)(protocolInfoRespDto = (ProtocolInfoRespDto)RestResponseHelper.extractData((RestResponse)(protRestResp = this.protocolInfoQueryApi.queryLatestProtocolByType(ProtocolTypeEnum.YHXY.getCode())))).getId())) {
                    sRespDto.setProtocolId(protocolInfoRespDto.getId());
                }
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            e.printStackTrace();
            RestResponse response = new RestResponse();
            response.setResultCode("0");
            response.setResultMsg(e.getMessage());
            return response;
        }
        return new RestResponse((Object)sRespDto);
    }

    @Override
    public RestResponse<SettlementAccountRegisterRespDto> queryRegiAccByCusIdOrOrgId() {
        String customerid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        String curOrgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        if (!StringUtils.isEmpty((CharSequence)customerid)) {
            return this.queryRegisterAccountByCustomerId(customerid);
        }
        if (!StringUtils.isEmpty((CharSequence)curOrgId)) {
            return this.queryRegisterAccountByOrgId(curOrgId);
        }
        return new RestResponse(null);
    }

    @Override
    public RestResponse<SettlementAccountRegisterRespDto> queryRegiAccForSwitch(@RequestParam(value="customerid", required=false) String customerid, @RequestParam(value="organizationid", required=false) String organizationid) {
        if (!StringUtils.isEmpty((CharSequence)customerid)) {
            return this.queryRegisterAccountByCustomerId(customerid);
        }
        if (!StringUtils.isEmpty((CharSequence)organizationid)) {
            return this.queryRegisterAccountByOrgId(organizationid);
        }
        throw new BizException("\u67e5\u8be2\u53c2\u6570\u6761\u4ef6\u4e3a\u7a7a");
    }

    @Override
    public RestResponse<Boolean> queryDealerIsExistAccount(String customerid) {
        SettlementAccountRegisterRespDto accDto = (SettlementAccountRegisterRespDto)this.queryRegisterAccountByCustomerId(customerid).getData();
        if (accDto != null && accDto.getId() != null && (accDto.getOrganizationType().equals(SettleAccOrgTypeEnum.DEALER.getCode()) || accDto.getOrganizationType().equals(SettleAccOrgTypeEnum.CUSTOMER.getCode()) && !CiticUserTypeEnum.PERSONAL.getKey().equals(accDto.getRegisterType().toString()))) {
            return new RestResponse((Object)true);
        }
        return new RestResponse((Object)false);
    }

    @Override
    public RestResponse<SettlementAccountRegisterRespDto> queryByRelationId(@PathVariable(value="id") Long id) {
        SettlementAccountRegisterRespDto registerRespDto = (SettlementAccountRegisterRespDto)this.iSettlementAccountRegisterRelationQueryApi.queryByRelationId(id).getData();
        if (registerRespDto == null || registerRespDto.getId() == null) {
            throw new BizException("\u8fdb\u4ef6\u8d44\u6599\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        OrgAndOrgInfoRespDto orgInfoRespDto = (OrgAndOrgInfoRespDto)this.organizationQueryApi.queryOrgAndOrgInfo(registerRespDto.getOrganizationId()).getData();
        if (!CiticUserTypeEnum.PERSONAL.getKey().equals(registerRespDto.getRegisterType().toString())) {
            if (orgInfoRespDto == null || orgInfoRespDto.getOrganizationInfoDto() == null) {
                throw new BizException("\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a\uff0c\u7ec4\u7ec7\u4fe1\u606f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5728\u5ba2\u5546\u4e2d\u5fc3\u5904\u7ef4\u62a4");
            }
            registerRespDto.setLegalName(orgInfoRespDto.getOrganizationInfoDto().getLegalName());
            registerRespDto.setLegalIdCard(orgInfoRespDto.getOrganizationInfoDto().getLegalCardNum());
            registerRespDto.setRegisterName(orgInfoRespDto.getOrganizationInfoDto().getOrgName());
        }
        ProtocolSignReqDto proReqDto = new ProtocolSignReqDto();
        proReqDto.setBusinessId(registerRespDto.getId());
        RestResponse proResp = this.protocolSignQueryApi.queryByPage(JSON.toJsonString((Object)proReqDto), Integer.valueOf(1), Integer.valueOf(10));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)proResp);
        if (ObjectUtils.isNotEmpty((Object)pageInfo.getList()) && pageInfo.getList().size() > 0) {
            Date lastestDate = ((ProtocolSignRespDto)pageInfo.getList().get(0)).getCreateTime();
            registerRespDto.setProtocolId(((ProtocolSignRespDto)pageInfo.getList().get(0)).getProtocolId());
            for (ProtocolSignRespDto signDto : pageInfo.getList()) {
                if (lastestDate.compareTo(signDto.getCreateTime()) < 0) continue;
                registerRespDto.setProtocolId(signDto.getProtocolId());
            }
        }
        return new RestResponse((Object)registerRespDto);
    }

    @Override
    public RestResponse<ResignProtocolRespDto> queryIsResignProtocol(String customerid, String curOrgId) {
        RestResponse protocolResp = new RestResponse(null);
        try {
            RestResponse<SettlementAccountRegisterRespDto> registerResp = null;
            if (!StringUtils.isEmpty((CharSequence)customerid) || !StringUtils.isEmpty((CharSequence)curOrgId)) {
                if (!StringUtils.isEmpty((CharSequence)customerid)) {
                    registerResp = this.queryRegisterAccountByCustomerId(customerid);
                } else if (!StringUtils.isEmpty((CharSequence)curOrgId)) {
                    registerResp = this.queryRegisterAccountByOrgId(curOrgId);
                }
                SettlementAccountRegisterRespDto dto = (SettlementAccountRegisterRespDto)RestResponseHelper.extractData(registerResp);
                if (dto != null && dto.getId() != null) {
                    ProtocolInfoRespDto protocolInfoRespDto = (ProtocolInfoRespDto)RestResponseHelper.extractData((RestResponse)this.protocolInfoQueryApi.queryLatestProtocolByType(ProtocolTypeEnum.YHXY.getCode()));
                    ResignProtocolRespDto resignProtocolRespDto = new ResignProtocolRespDto();
                    BeanUtils.copyProperties((Object)protocolInfoRespDto, (Object)((Object)resignProtocolRespDto));
                    if (ObjectUtils.isNotEmpty((Object)resignProtocolRespDto.getId()) && !resignProtocolRespDto.getProtocolType().equals(ProtocolTypeEnum.VERSION1.getCode())) {
                        ProtocolSignReqDto reqDto = new ProtocolSignReqDto();
                        reqDto.setProtocolId(resignProtocolRespDto.getId());
                        reqDto.setBusinessType(ProtocolTypeEnum.YHXY.getCode());
                        reqDto.setBusinessId(dto.getId());
                        RestResponse signRespDtoRestResponse = this.protocolSignQueryApi.queryByPage(JSON.toJsonString((Object)reqDto), Integer.valueOf(1), Integer.valueOf(10));
                        PageInfo psPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)signRespDtoRestResponse);
                        if (psPageInfo.getList().size() == 0) {
                            resignProtocolRespDto.setRelationId(dto.getId().toString());
                            protocolResp = new RestResponse((Object)resignProtocolRespDto);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            protocolResp.setResultCode("0");
            protocolResp.setResultMsg(e.getMessage());
        }
        return protocolResp;
    }

    @Override
    public RestResponse<Long> resignSettlementProtocol(@RequestBody ResignProtocolReqDto resignProtocolReqDto) {
        if (!resignProtocolReqDto.getIsAgree().equals(ProtocolSignAgreeEnum.AGREE.getCode())) {
            throw new BizException("\u8bf7\u52fe\u9009\u662f\u5426\u540c\u610f");
        }
        ProtocolSignReqDto protocolReqDto = new ProtocolSignReqDto();
        protocolReqDto.setProtocolId(resignProtocolReqDto.getProtocolId());
        String userId = (String)ServiceContext.getContext().getKeys().get("yes.req.userId");
        EmployeeRespDto employeeRespDto = (EmployeeRespDto)RestResponseHelper.extractData((RestResponse)this.employeeQueryApi.queryByUserId());
        protocolReqDto.setSignUserId(userId);
        protocolReqDto.setSignPersonName(employeeRespDto.getName());
        protocolReqDto.setSignTime(new Date());
        protocolReqDto.setIsAgree(Boolean.valueOf(true));
        protocolReqDto.setBusinessType(ProtocolTypeEnum.YHXY.getCode());
        protocolReqDto.setBusinessId(resignProtocolReqDto.getRelationId());
        return this.protocolSignApi.addProtocolSign(protocolReqDto);
    }

    @Override
    public RestResponse<Void> checkCreditCodeChage(Long customerid, Long organizationid, String creditCode) {
        SettlementAccountRegisterRespDto registerRespDto = (SettlementAccountRegisterRespDto)this.queryRegiAccForSwitch(customerid == null ? null : customerid.toString(), organizationid == null ? null : organizationid.toString()).getData();
        if (registerRespDto != null && registerRespDto.getId() != null && !creditCode.equals(registerRespDto.getOrganizationCreditCode()) && (registerRespDto.getOrganizationType().equals(CustomerTypeEnum.DEALER.getCode()) || registerRespDto.getOrganizationType().equals(CustomerTypeEnum.RETAILER.getCode()) && !CiticUserTypeEnum.PERSONAL.getKey().equals(registerRespDto.getRegisterType().toString()))) {
            throw new BizException("\u65e7\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u5df2\u7533\u8bf7\u94b1\u5305\u8d26\u6237\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u3002\u82e5\u9700\u53d8\u66f4\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff0c\u8bf7\u6ce8\u9500\u94b1\u5305");
        }
        return new RestResponse();
    }

    private void validPolicy(Long orgid) {
        RestResponse restResponse = this.iCustomerExtQueryApi.queryOrgInfoPageByUserId(null, null, Integer.valueOf(1), Integer.valueOf(1000));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)restResponse);
        boolean isExist = false;
        if (pageInfo.getSize() > 0) {
            for (OrgInfoDto orgDto : pageInfo.getList()) {
                if (orgDto.getOrgInfoId().compareTo(orgid) != 0) continue;
                isExist = true;
            }
        }
        if (pageInfo.getSize() == 0 || !isExist) {
            throw new BizException("\u975e\u7ec4\u7ec7\u5bf9\u5e94\u7528\u6237\uff0c\u65e0\u7ed3\u7b97\u8d26\u6237\u76f8\u5173\u6743\u9650");
        }
    }

    @Override
    public RestResponse<SettlementRootAccountRespDto> queryRootAccount(String typeCode) {
        return this.rootAccountQueryApi.queryRootAccount(typeCode);
    }
}

