/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.settlement.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.settlement.api.IShareBenefitApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.ShareBenefitReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.TradeSettlementFlowReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.query.ITradeSettlementFlowQueryApi;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.ShareBenefitOrderReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.service.ShareBenefitOrderService;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ShareBenefitOrderServiceImpl
implements ShareBenefitOrderService {
    private Logger logger = LoggerFactory.getLogger(ShareBenefitOrderServiceImpl.class);
    @Resource
    private IShareBenefitApi shareBenefitApi;
    @Resource
    private ITradeSettlementFlowQueryApi tradeSettlementFlowQueryApi;
    @Resource
    private IContext context;

    @Override
    public RestResponse<Void> shareBenefit(ShareBenefitOrderReqDto dto) {
        this.logger.info("\u8ba2\u5355\u53d1\u8d27\u5206\u8d26\u8bf7\u6c42\uff0c\u5165\u53c2={}", (Object)JSON.toJSONString((Object)dto));
        TradeSettlementFlowReqDto flowReqDto = new TradeSettlementFlowReqDto();
        flowReqDto.setOptTradeNo(dto.getOrderNo());
        List flowList = (List)RestResponseHelper.extractData((RestResponse)this.tradeSettlementFlowQueryApi.queryList(flowReqDto));
        if (CollectionUtil.isEmpty((Collection)flowList)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4ea4\u6613\u6d41\u6c34");
        }
        TradeSettlementFlowRespDto payFlow = null;
        for (TradeSettlementFlowRespDto flow : flowList) {
            if (!flow.getTradeType().equals(SettlementFlowTradeTypeEnum.PAY.getCode()) || !flow.getTradeStatus().equals(SettlementFlowTradeStatusEnum.SUCCESS.getCode())) continue;
            payFlow = flow;
        }
        if (ObjectUtils.isEmpty(payFlow)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u652f\u4ed8\u4ea4\u6613\u6d41\u6c34");
        }
        if (dto.getUserId() == null && this.context.userId() != null) {
            dto.setUserId(this.context.userId());
        } else if (dto.getUserId() == null && this.context.userId() == null) {
            dto.setUserId(-1L);
        }
        if (dto.getUserName() == null && this.context.userName() != null) {
            dto.setUserName(this.context.userName());
        } else if (dto.getUserName() == null && this.context.userName() == null) {
            dto.setUserName("-1");
        }
        ShareBenefitReqDto reqDto = new ShareBenefitReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)dto, (String[])new String[0]);
        reqDto.setRequestTime(dto.getDate());
        this.shareBenefitApi.unifyShareBenefit(reqDto);
        return RestResponse.VOID;
    }
}

