/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.settlement.rest;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.PaymentWayRespDto;
import com.dtyunxi.tcbj.module.settlement.biz.config.WxTokenRegister;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.BatchPayOrderReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.PayOrderReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.PaymentWayReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.response.OrderPaymentWayRespDto;
import com.dtyunxi.tcbj.module.settlement.biz.service.PayOrderService;
import com.dtyunxi.tcbj.module.settlement.biz.utils.Authorization;
import com.dtyunxi.tcbj.module.settlement.biz.utils.WeiXinUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ed3\u7b97\u7ec4\u4ef6\uff1a\u652f\u4ed8\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/payOrder"})
public class PayOrderRest {
    private Logger logger = LoggerFactory.getLogger(PayOrderRest.class);
    @Resource
    private PayOrderService payOrderService;
    @Resource
    private WxTokenRegister wxTokenRegister;

    @GetMapping(value={"/queryPaymentWay"})
    @ApiOperation(value="\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f", notes="\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f")
    public RestResponse<List<PaymentWayRespDto>> queryPaymentWay(@RequestParam(value="orderNo") String orderNo, @RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="cusId", required=false) String cusId) {
        PaymentWayReqDto reqDto = new PaymentWayReqDto();
        reqDto.setOrderNos(new String[]{orderNo});
        reqDto.setCusId(cusId);
        reqDto.setOrgId(orgId);
        return this.payOrderService.queryPaymentWayBatch(reqDto);
    }

    @PostMapping(value={"/unifyPay"})
    @ApiOperation(value="\u7edf\u4e00\u652f\u4ed8\uff08\u5355\u7b14\uff09", notes="\u7edf\u4e00\u652f\u4ed8\uff08\u5355\u7b14\uff09")
    public RestResponse<Object> unifyPay(@Valid @RequestBody PayOrderReqDto dto) {
        BatchPayOrderReqDto reqDto = new BatchPayOrderReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)dto, (String[])new String[0]);
        reqDto.setBatchOrderNos(Collections.singletonList(dto.getOrderNo()));
        return this.payOrderService.unifyPayBatch(reqDto);
    }

    @PostMapping(value={"/unifyPay/batch"})
    @ApiOperation(value="\u7edf\u4e00\u652f\u4ed8\uff08\u6279\u91cf\uff09", notes="\u7edf\u4e00\u652f\u4ed8\uff08\u6279\u91cf\uff09")
    public RestResponse<Object> unifyPayBatch(@Valid @RequestBody BatchPayOrderReqDto dto) {
        return this.payOrderService.unifyPayBatch(dto);
    }

    @PostMapping(value={"/queryPaymentWayBatch"})
    @ApiOperation(value="\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f\u3010\u6279\u91cf\u652f\u4ed8\u3011", notes="\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f\u3010\u6279\u91cf\u652f\u4ed8\u3011")
    public RestResponse<List<PaymentWayRespDto>> queryPaymentWayBatch(@Valid @RequestBody PaymentWayReqDto dto) {
        return this.payOrderService.queryPaymentWayBatch(dto);
    }

    @GetMapping(value={"/wxTokenOpenId/{code}", "/wxTokenOpenId/"})
    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1openId", notes="\u83b7\u53d6\u5fae\u4fe1openId")
    public RestResponse<Authorization> wxTokenOpenId(@PathVariable(value="code") String code) {
        this.logger.info("\u83b7\u53d6\u7528\u6237code=" + code);
        if (StringUtils.isBlank((CharSequence)code)) {
            return new RestResponse("100400", "code\u53c2\u6570\u4e3a\u7a7a");
        }
        Authorization authorization = WeiXinUtil.getAuthorization((String)this.wxTokenRegister.getAppId(), (String)this.wxTokenRegister.getAppSecret(), (String)code);
        this.logger.info("\u83b7\u53d6\u5230authorization={}", (Object)JSON.toJSONString((Object)authorization));
        return new RestResponse((Object)authorization);
    }

    @PostMapping(value={"/queryOrderPaymentWay"})
    @ApiOperation(value="\u83b7\u53d6\u8ba2\u5355\u652f\u4ed8\u65b9\u5f0f", notes="\u83b7\u53d6\u8ba2\u5355\u652f\u4ed8\u65b9\u5f0f")
    public RestResponse<OrderPaymentWayRespDto> queryOrderPaymentWay(@Valid @RequestBody PaymentWayReqDto dto) {
        return this.payOrderService.queryOrderPaymentWay(dto);
    }
}

