/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.credit.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.eo.SqlOrderBy;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditTermModelReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditTermModelRuleReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditTermModelSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditTermModelInfoRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditTermModelRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.BeginDateTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.ConfigType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditTermTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.GeneralRuleCodeType;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditTermModelService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.untils.GenerateCode;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.untils.HelperUtils;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditAccountDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditNodeDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditOccupyConfigDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditOrderBillDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditTermModelDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditTermModelRuleDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditNodeEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditTermModelEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditTermModelRuleEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="creditTermModel")
public class CreditTermModelServiceImpl
implements ICreditTermModelService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private CreditOrderBillDas creditOrderBillDas;
    @Resource
    private CreditTermModelDas creditTermModelDas;
    @Resource
    private CreditTermModelRuleDas creditTermModelRuleDas;
    @Resource
    private CreditNodeDas creditNodeDas;
    @Resource
    private CreditOccupyConfigDas creditOccupyConfigDas;
    @Resource
    private GenerateCode generateCode;
    @Resource
    private CreditAccountDas creditAccountDas;
    @Autowired
    private IContext iContext;
    @Resource
    private HelperUtils helperUtils;
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private ICreditAccountService creditAccountService;

    @Transactional(rollbackFor={Exception.class})
    public Long add(CreditTermModelReqDto termModelReqDto) {
        this.validTermModel(termModelReqDto);
        CreditTermModelEo creditTermModelEo = new CreditTermModelEo();
        DtoHelper.dto2Eo((BaseVo)termModelReqDto, (BaseEo)creditTermModelEo);
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        creditTermModelEo.setOrgInfoId(orgId);
        if (null == termModelReqDto.getId()) {
            String code = StringUtils.isNotEmpty((CharSequence)termModelReqDto.getCode()) ? termModelReqDto.getCode() : this.generateCode.createCode(GeneralRuleCodeType.TERM_MODEL);
            creditTermModelEo.setCode(code);
            this.creditTermModelDas.insert((BaseEo)creditTermModelEo);
        } else {
            this.creditTermModelDas.updateSelective((BaseEo)creditTermModelEo);
        }
        List termModelRuleEoList = termModelReqDto.getTermModelRuleReqDtoList().stream().map(obj -> {
            CreditTermModelRuleEo termModelRuleEo = new CreditTermModelRuleEo();
            DtoHelper.dto2Eo((BaseVo)obj, (BaseEo)termModelRuleEo, (String[])new String[]{"id"});
            termModelRuleEo.setCreditTermModelId(creditTermModelEo.getId());
            return termModelRuleEo;
        }).collect(Collectors.toList());
        this.creditTermModelRuleDas.insertBatch(termModelRuleEoList);
        return creditTermModelEo.getId();
    }

    private void validTermModel(CreditTermModelReqDto termModelReqDto) {
        this.logger.info("\u65b0\u589e\u6a21\u578b----:" + JSONObject.toJSONString((Object)termModelReqDto));
        Boolean aBoolean = this.creditTermModelDas.queryByNameId(termModelReqDto.getId(), termModelReqDto.getName());
        if (!aBoolean.booleanValue()) {
            throw new BizException("\u8d26\u671f\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        if (CollectionUtils.isEmpty((Collection)termModelReqDto.getTermModelRuleReqDtoList())) {
            throw new BizException("\u89c4\u5219\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CreditTermTypeEnum type = CreditTermTypeEnum.getType((Integer)termModelReqDto.getType());
        if (null == type) {
            throw new BizException("\u8d26\u671f\u6307\u5b9a\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        block7: for (CreditTermModelRuleReqDto ruleReqDto : termModelReqDto.getTermModelRuleReqDtoList()) {
            if (null == ruleReqDto.getPayRate() || ruleReqDto.getPayRate().compareTo(BigDecimal.valueOf(100L)) > 0) {
                throw new BizException("\u4ed8\u6b3e\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a \u4e14\u4e0d\u80fd\u5927\u4e8e100%");
            }
            switch (type) {
                case GENERAL: {
                    this.logger.info("--\u65b0\u5efa\u8d26\u671f\uff0c\u3010\u4e00\u822c\u8d26\u671f\u3011");
                    if (null != ruleReqDto.getAfterDays()) continue block7;
                    throw new BizException("\u63a8\u8fdf\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                case WEEK: {
                    this.logger.info("--\u65b0\u5efa\u8d26\u671f\uff0c\u3010\u56fa\u5b9a\u5468\u7ed3\u65e5\u3011");
                    if (null != ruleReqDto.getDateRangeStart() && null != ruleReqDto.getDateRangeEnd() && null != ruleReqDto.getDelayNumber() && null != ruleReqDto.getDelayUnit() && null != ruleReqDto.getWeek() && null != ruleReqDto.getWeekNumber()) continue block7;
                    throw new BizException("\u8d77\u7b97\u65e5\u5f00\u59cb\u533a\u95f4\u3001\u5230\u671f\u65e5\u4fe1\u606f\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
                }
                case MONTH: {
                    this.logger.info("--\u65b0\u5efa\u8d26\u671f\uff0c\u3010\u56fa\u5b9a\u6708\u7ed3\u65e5\u3011");
                    if (null != ruleReqDto.getDateRangeStart() && null != ruleReqDto.getDateRangeEnd() && null != ruleReqDto.getDelayNumber() && null != ruleReqDto.getDateNumber()) continue block7;
                    throw new BizException("\u8d77\u7b97\u65e5\u5f00\u59cb\u533a\u95f4\u3001\u5230\u671f\u65e5\u4fe1\u606f\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
                }
                case INSTALLMENT: {
                    this.logger.info("--\u65b0\u5efa\u8d26\u671f\uff0c\u3010\u5206\u671f\u4ed8\u6b3e\u3011");
                    if (null != ruleReqDto.getAfterDays()) continue block7;
                    break;
                }
                case SURE_DAY: {
                    this.logger.info("--\u65b0\u5efa\u8d26\u671f\uff0c\u3010\u8d26\u671f\u3011");
                    if (null != ruleReqDto.getSureEndDay() && null != ruleReqDto.getBeginStartDay() && null != ruleReqDto.getBeginEndDay()) continue block7;
                    throw new BizException("\u8303\u56f4\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                default: {
                    this.logger.info("--\u65b0\u5efa\u8d26\u671f\uff0c\u72b6\u6001\u4e0d\u9700\u5904\u7406");
                }
            }
        }
    }

    public void enable(Long id) {
    }

    public void disable(Long id) {
    }

    public void delete(Long id) {
        CreditTermModelEo termModelEo = (CreditTermModelEo)this.creditTermModelDas.selectByPrimaryKey(id);
        if (null == termModelEo) {
            throw new BizException("\u8d26\u671f\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25");
        }
        Map accountNumMap = this.creditAccountDas.queryConfigAccountNum(Collections.singletonList(id), ConfigType.CREDIT_TERM);
        if (!accountNumMap.isEmpty()) {
            throw new BizException("\u8d26\u671f\u5df2\u88ab\u4fe1\u7528\u8d26\u6237\u7ed1\u5b9a\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.creditTermModelDas.logicDeleteById(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void edit(Long id, CreditTermModelReqDto dto) {
        CreditTermModelEo creditTermModelEo = (CreditTermModelEo)this.creditTermModelDas.selectByPrimaryKey(id);
        if (null == creditTermModelEo) {
            throw new BizException("\u8d26\u671f\u4e0d\u5b58\u5728\uff0c\u7f16\u8f91\u5931\u8d25");
        }
        this.bak(id);
        dto.setId(creditTermModelEo.getId());
        dto.setCode(creditTermModelEo.getCode());
        this.add(dto);
    }

    private void bak(Long id) {
        CreditTermModelRuleEo newModel = new CreditTermModelRuleEo();
        newModel.setCreditTermModelId(id);
        List creditTermModelRuleEos = this.creditTermModelRuleDas.selectList((BaseEo)newModel);
        CreditTermModelEo oldModel = (CreditTermModelEo)this.creditTermModelDas.selectByPrimaryKey(id);
        Long oldModelId = oldModel.getId();
        oldModel.setId(null);
        oldModel.setSourceId(id);
        oldModel.setIsBackup(Integer.valueOf(1));
        this.creditTermModelDas.insert((BaseEo)oldModel);
        for (CreditTermModelRuleEo creditTermModelRuleEo : creditTermModelRuleEos) {
            creditTermModelRuleEo.setCreditTermModelId(oldModel.getId());
        }
        this.creditTermModelRuleDas.updateCreditTermModelId(id, oldModel.getId());
        this.creditOrderBillDas.updatePointValue("credit_term_model_id", oldModel.getId(), oldModelId);
    }

    public PageInfo<CreditTermModelRespDto> queryPage(CreditTermModelSearchReqDto searchReqDto) {
        CreditTermModelEo termModelEo = this.getCreditTermModelEo(searchReqDto);
        PageHelper.startPage((int)searchReqDto.getPageNum(), (int)searchReqDto.getPageSize());
        PageInfo select = new PageInfo(this.creditTermModelDas.select((BaseEo)termModelEo));
        PageInfo pageInfo = new PageInfo();
        this.joinList((PageInfo<CreditTermModelEo>)select, (PageInfo<CreditTermModelRespDto>)pageInfo);
        return pageInfo;
    }

    private CreditTermModelEo getCreditTermModelEo(CreditTermModelSearchReqDto searchReqDto) {
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        CreditTermModelEo termModelEo = new CreditTermModelEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.isNull((String)"is_backup"));
        this.helperUtils.setBaseSearch(searchReqDto, searchReqDto.getName(), searchReqDto.getCreateTimeStart(), searchReqDto.getCreateTimeEnd(), sqlFilterList, termModelEo);
        termModelEo.setOrgInfoId(orgId);
        SortOrder sortOrder = SortOrder.getSortOrder((String)searchReqDto.getSortType());
        if (SortOrder.ASC.equals((Object)sortOrder)) {
            this.logger.info("\u8d26\u671f\u6a21\u578b\u6309\u5347\u5e8f\u6392\u5e8f\uff01");
            ArrayList sqlOrderByList = Lists.newArrayList();
            sqlOrderByList.add(new SqlOrderBy("create_time", sortOrder));
            termModelEo.setSqlOrderBys((List)sqlOrderByList);
        }
        return termModelEo;
    }

    private void joinList(PageInfo<CreditTermModelEo> select, PageInfo<CreditTermModelRespDto> pageInfo) {
        if (CollectionUtils.isNotEmpty((Collection)select.getList())) {
            ArrayList list = Lists.newArrayList();
            BeanUtils.copyProperties(select, pageInfo, (String[])new String[]{"list"});
            CubeBeanUtils.copyCollection((Collection)list, (Collection)select.getList(), CreditTermModelRespDto.class);
            List ids = list.stream().map(BaseRespDto::getId).collect(Collectors.toList());
            Map accountNumMap = this.creditAccountDas.queryConfigAccountNum(ids, ConfigType.CREDIT_TERM);
            for (CreditTermModelRespDto dto : list) {
                dto.setBeginDateTypeName("\u53d1\u8d27\u65e5" + (dto.getAfterDays() != null && dto.getAfterDays() > 0 ? "+" + dto.getAfterDays() : ""));
                if (!accountNumMap.containsKey(dto.getId())) continue;
                dto.setAccountNum((Integer)accountNumMap.get(dto.getId()));
            }
            pageInfo.setList((List)list);
        }
    }

    public CreditTermModelInfoRespDto getDetail(Long id) {
        CreditTermModelEo creditTermModelEo = (CreditTermModelEo)this.creditTermModelDas.selectByPrimaryKey(id);
        if (null == creditTermModelEo || null == creditTermModelEo.getId()) {
            throw new BizException("\u8d26\u671f\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2\u5931\u8d25");
        }
        CreditTermModelRuleEo termModelRuleEo = new CreditTermModelRuleEo();
        termModelRuleEo.setCreditTermModelId(id);
        termModelRuleEo.setOrderBy("sort");
        List select = this.creditTermModelRuleDas.selectPage((BaseEo)termModelRuleEo, Integer.valueOf(1), Integer.valueOf(5000)).getList();
        if (CollectionUtils.isEmpty((Collection)select)) {
            throw new BizException("\u8d26\u671f\u89c4\u5219\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2\u5931\u8d25");
        }
        CreditTermModelInfoRespDto dto = new CreditTermModelInfoRespDto();
        BeanUtils.copyProperties((Object)creditTermModelEo, (Object)dto);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)select, CreditTermModelRuleReqDto.class);
        dto.setTermModelRuleReqDtoList((List)list);
        String beginDateName = this.getBeginDateName();
        dto.setBeginDateTypeName(beginDateName);
        for (CreditTermModelRuleReqDto ruleReqDto : dto.getTermModelRuleReqDtoList()) {
            ruleReqDto.setBeginDateTypeName(beginDateName);
        }
        return dto;
    }

    private String getBeginDateName() {
        String beginDateName = "\u989d\u5ea6\u5360\u7528\u65e5";
        CreditNodeEo selectItemCreditNode = new CreditNodeEo();
        selectItemCreditNode.setCode(BeginDateTypeEnum.QUOTA_OCCUPY_BEGIN_DAY.getCode());
        PageInfo creditNodeEoPageInfo = this.creditNodeDas.selectPage((BaseEo)selectItemCreditNode, Integer.valueOf(1), Integer.valueOf(1));
        if (null != creditNodeEoPageInfo && !CollectionUtils.isEmpty((Collection)creditNodeEoPageInfo.getList())) {
            beginDateName = ((CreditNodeEo)creditNodeEoPageInfo.getList().get(0)).getName();
        }
        this.logger.info("------------------------------------------------\u627e\u5230CreditNodeEo\u8868\u4e2d\u7684\u5360\u7528\u65e5[{}]", (Object)beginDateName);
        return beginDateName;
    }

    @Override
    public PageInfo<CreditTermModelInfoRespDto> queryPageDetail(CreditTermModelSearchReqDto searchReqDto) {
        PageInfo pageInfo = new PageInfo();
        PageInfo<CreditTermModelRespDto> pageInfo1 = this.queryPage(searchReqDto);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo1.getList())) {
            List ids = pageInfo1.getList().stream().map(BaseRespDto::getId).collect(Collectors.toList());
            List ruleEoList = this.creditTermModelRuleDas.queryByModelIds(ids);
            HashMap<Long, List> ruleMap = new HashMap<Long, List>();
            String beginDateName = ((CreditTermModelRespDto)pageInfo1.getList().get(0)).getBeginDateTypeName();
            for (CreditTermModelRuleEo termModelRuleEo : ruleEoList) {
                List list = (List)ruleMap.get(termModelRuleEo.getCreditTermModelId());
                CreditTermModelRuleReqDto ruleReqDto = new CreditTermModelRuleReqDto();
                DtoHelper.eo2Dto((BaseEo)termModelRuleEo, (BaseVo)ruleReqDto);
                ruleReqDto.setBeginDateTypeName(beginDateName);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    list = Lists.newArrayList();
                }
                list.add(ruleReqDto);
                ruleMap.put(termModelRuleEo.getCreditTermModelId(), list);
            }
            ArrayList list = Lists.newArrayList();
            for (CreditTermModelRespDto modelRespDto : pageInfo1.getList()) {
                CreditTermModelInfoRespDto modelInfoRespDto = new CreditTermModelInfoRespDto();
                BeanUtils.copyProperties((Object)modelRespDto, (Object)modelInfoRespDto);
                modelInfoRespDto.setTermModelRuleReqDtoList((List)ruleMap.get(modelRespDto.getId()));
                list.add(modelInfoRespDto);
            }
            BeanUtils.copyProperties(pageInfo1, (Object)pageInfo, (String[])new String[]{"list"});
            pageInfo.setList((List)list);
        }
        return pageInfo;
    }
}

