/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.api.exception;

import java.util.HashMap;
import java.util.Map;

public enum ChargeModeEnum {
    VOLUME(1, "\u6309\u4ef6/\u4f53\u79ef"),
    TRANSPORT(2, "\u6309\u8fd0\u8d39\u5355\u4ef7"),
    WEIGHT(3, "\u6309\u91cd\u91cf\u8ba1\u8d39"),
    MINIMUM(4, "\u6309\u6700\u4f4e\u6536\u8d39");

    private Integer type;
    private String name;
    public static final Map<Integer, ChargeModeEnum> CHARGE_MODE_TYPE_MAP;

    private ChargeModeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public static ChargeModeEnum getChargeMode(Integer type) {
        ChargeModeEnum chargeModeEnum = CHARGE_MODE_TYPE_MAP.get(type);
        return chargeModeEnum;
    }

    public Integer getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    static {
        CHARGE_MODE_TYPE_MAP = new HashMap<Integer, ChargeModeEnum>();
        CHARGE_MODE_TYPE_MAP.put(VOLUME.getType(), VOLUME);
        CHARGE_MODE_TYPE_MAP.put(TRANSPORT.getType(), TRANSPORT);
        CHARGE_MODE_TYPE_MAP.put(WEIGHT.getType(), WEIGHT);
        CHARGE_MODE_TYPE_MAP.put(MINIMUM.getType(), MINIMUM);
    }
}

