/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.api.exception;

import com.dtyunxi.finance.api.exception.FinanceExceptionEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinanceException
extends RuntimeException {
    private static Logger logger = LoggerFactory.getLogger(FinanceException.class);
    private String errorCode;
    private String errorMsg;

    public FinanceException(String errorCode, String errorMsg) {
        super(errorMsg);
        logger.info("code:{},message:{}", (Object)errorCode, (Object)errorMsg);
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public static void throwException(FinanceExceptionEnum accountExEnum) throws FinanceException {
        String code = accountExEnum.getCode();
        String message = accountExEnum.getMessage();
        logger.info("code:{},message:{}", (Object)code, (Object)message);
        throw new FinanceException(code, message);
    }

    public static void throwException(FinanceExceptionEnum accountExEnum, String message) throws FinanceException {
        String code = accountExEnum.getCode();
        logger.info("code:{},message:{}", (Object)code, (Object)message);
        throw new FinanceException(code, message);
    }

    public static void throwCustomException(FinanceExceptionEnum FinanceExceptionEnum2, String message) throws FinanceException {
        String code = FinanceExceptionEnum2.getCode();
        String exceptionMessage = FinanceExceptionEnum2.getMessage();
        logger.info("code:{},message:{}", (Object)code, (Object)message);
        throw new FinanceException(code, message + exceptionMessage);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FinanceException)) {
            return false;
        }
        FinanceException other = (FinanceException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        return !(this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FinanceException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "FinanceException(errorCode=" + this.getErrorCode() + ", errorMsg=" + this.getErrorMsg() + ")";
    }
}

