/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.request.logistic.LogisticRecordReqDto;
import com.dtyunxi.finance.api.exception.ChargeModeEnum;
import com.dtyunxi.finance.api.exception.ExampleExceptionCode;
import com.dtyunxi.finance.api.exception.FinanceException;
import com.dtyunxi.finance.api.exception.FinanceExceptionEnum;
import com.dtyunxi.finance.api.exception.LogisticRecordStatusEnum;
import com.dtyunxi.finance.api.exception.constant.SortingContractStatusEnum;
import com.dtyunxi.finance.biz.service.ILogisticRecordService;
import com.dtyunxi.finance.dao.das.AppointAreaDas;
import com.dtyunxi.finance.dao.das.LogisticRecordDas;
import com.dtyunxi.finance.dao.eo.LogisticRecordEo;
import com.dtyunxi.rest.RestResponse;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogisticRecordServiceImpl
implements ILogisticRecordService {
    private static final Logger log = LoggerFactory.getLogger(LogisticRecordServiceImpl.class);
    @Resource
    private LogisticRecordDas logisticRecordDas;
    @Resource
    private AppointAreaDas appointAreaDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveLogisticRecord(LogisticRecordReqDto reqDto) {
        this.checkContractTime(reqDto);
        LogisticRecordEo logisticRecordEo = new LogisticRecordEo();
        if (StringUtils.isEmpty((CharSequence)reqDto.getId())) {
            LogisticRecordEo sourceEo;
            BeanUtils.copyProperties((Object)reqDto, (Object)logisticRecordEo);
            this.logisticRecordDas.insert((BaseEo)logisticRecordEo);
            if (reqDto.getCopyFlag().booleanValue() && reqDto.getSourceId() != null && reqDto.getSourceId() > 0L && (sourceEo = (LogisticRecordEo)this.logisticRecordDas.selectByLogicKey((Object)String.valueOf(reqDto.getSourceId()))) != null && Objects.equals(sourceEo.getChargeMode(), logisticRecordEo.getChargeMode()) && Objects.equals(sourceEo.getSeasonType(), logisticRecordEo.getSeasonType())) {
                List areaEos = ((ExtQueryChainWrapper)this.appointAreaDas.filter().eq((Object)"template_id", (Object)reqDto.getSourceId())).list(Integer.valueOf(5000));
                LogisticRecordEo finalLogisticRecordEo = logisticRecordEo;
                areaEos.stream().forEach(i -> {
                    i.setId(null);
                    i.setTemplateId(finalLogisticRecordEo.getId());
                });
                this.appointAreaDas.insertBatch(areaEos);
            }
        } else {
            List areaEos;
            logisticRecordEo = (LogisticRecordEo)this.logisticRecordDas.selectByPrimaryKey(Long.valueOf(reqDto.getId()));
            logisticRecordEo.setContractName(reqDto.getContractName());
            logisticRecordEo.setWarehouseId(reqDto.getWarehouseId());
            logisticRecordEo.setWarehouseName(reqDto.getWarehouseName());
            logisticRecordEo.setLogisticId(reqDto.getLogisticId());
            logisticRecordEo.setLogisticCompany(reqDto.getLogisticCompany());
            logisticRecordEo.setTransportType(reqDto.getTransportType());
            logisticRecordEo.setChargeMode(reqDto.getChargeMode());
            logisticRecordEo.setParams(reqDto.getParams());
            logisticRecordEo.setStartTime(reqDto.getStartTime());
            logisticRecordEo.setEndTime(reqDto.getEndTime());
            logisticRecordEo.setDeliveryPrice(reqDto.getDeliveryPrice());
            logisticRecordEo.setUnloadPrice(reqDto.getUnloadPrice());
            logisticRecordEo.setContractOilPrice(reqDto.getContractOilPrice());
            if (!Objects.equals(logisticRecordEo.getSeasonType(), reqDto.getSeasonType()) && CollectionUtil.isNotEmpty((Collection)(areaEos = ((ExtQueryChainWrapper)this.appointAreaDas.filter().eq((Object)"template_id", (Object)reqDto.getSourceId())).list(Integer.valueOf(5000))))) {
                areaEos.stream().forEach(i -> this.appointAreaDas.delete((BaseEo)i));
            }
            logisticRecordEo.setSeasonType(reqDto.getSeasonType());
            logisticRecordEo.setOffSeason(reqDto.getOffSeason());
            logisticRecordEo.setPeakSeason(reqDto.getPeakSeason());
            logisticRecordEo.setAddress(reqDto.getAddress());
            logisticRecordEo.setRemark(reqDto.getRemark());
            this.logisticRecordDas.update((BaseEo)logisticRecordEo);
        }
        return logisticRecordEo.getId();
    }

    private void checkContractTime(LogisticRecordReqDto reqDto) {
        List list;
        log.info("\u7269\u6d41\u8d39\u7528\u8bbe\u7f6e\u65f6\u95f4 startTime: " + reqDto.getStartTime().toString() + " endTime:" + reqDto.getEndTime().toString());
        Date endTime = reqDto.getEndTime();
        Date startTime = reqDto.getStartTime();
        if (startTime.getTime() > endTime.getTime()) {
            FinanceException.throwException((FinanceExceptionEnum)FinanceExceptionEnum.INVALID_DATE);
        }
        ExtQueryChainWrapper filter = (ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticRecordDas.filter().eq((Object)"warehouse_id", (Object)reqDto.getWarehouseId())).eq((Object)"logistic_id", (Object)reqDto.getLogisticId())).eq((Object)"transport_type", (Object)reqDto.getTransportType())).eq((Object)"charge_mode", (Object)reqDto.getChargeMode())).ne((Object)"status", (Object)LogisticRecordStatusEnum.INVALID.getType());
        if (StringUtils.isNotBlank((CharSequence)reqDto.getId())) {
            filter.ne((Object)"id", (Object)reqDto.getId());
        }
        if (CollectionUtil.isNotEmpty((Collection)(list = filter.list()))) {
            log.info("\u67e5\u8be2\u540c\u4e00\u7269\u7406\u4ed3\u3001\u7269\u6d41\u516c\u53f8\u3001\u627f\u8fd0\u65b9\u5f0f\u7684\u7269\u6d41\u8d39\u7528\u8bbe\u7f6e\u8bb0\u5f55\u5217\u8868 list.toString():" + list.toString());
            this.getIntersect(startTime, endTime, list);
        }
    }

    private void getIntersect(Date startDate, Date endDate, List<LogisticRecordEo> list) {
        if (startDate.getTime() < endDate.getTime()) {
            for (LogisticRecordEo contractEo : list) {
                if (contractEo.getStatus().equals(SortingContractStatusEnum.TO_VOID.getCode())) continue;
                long a = contractEo.getStartTime().getTime();
                long b = contractEo.getEndTime().getTime();
                long c = startDate.getTime();
                long d = endDate.getTime();
                log.info("A=contractEo.getStartTime():" + contractEo.getStartTime().toString() + " B=contractEo.getEndTime():" + contractEo.getEndTime().toString());
                log.info("A=contractEo.getStartTime().getTime():" + contractEo.getStartTime().getTime() + " B=contractEo.getEndTime().getTime():" + contractEo.getEndTime().getTime());
                log.info("C=startDate:" + startDate.toString() + " D=endDate:" + endDate.toString());
                log.info("C=startDate.getTime():" + startDate.getTime() + " D=endDate.getTime():" + endDate.getTime());
                if ((a > c || b < c) && (a > d || d > b)) continue;
                throw new BizException("\u540c\u4e00\u7269\u7406\u4ed3\u3001\u7269\u6d41\u516c\u53f8\u3001\u627f\u8fd0\u65b9\u5f0f\u5bf9\u5e94\u5408\u540c\u6709\u6548\u671f\u4e0d\u80fd\u6709\u53e0\u52a0");
            }
        } else {
            throw new BizException("\u8d77\u59cb\u65f6\u95f4\u4e0e\u7ec8\u6b62\u65f6\u95f4\u8bbe\u7f6e\u6709\u8bef");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long removeLogisticRecord(Long id) {
        LogisticRecordEo logisticRecordEo = (LogisticRecordEo)this.logisticRecordDas.selectByPrimaryKey(id);
        if (null != logisticRecordEo && null != logisticRecordEo.getId()) {
            logisticRecordEo.setDr(1);
            this.logisticRecordDas.deleteData(logisticRecordEo);
        }
        return logisticRecordEo.getId();
    }

    @Override
    public Long copyLogisticRecord(Long id) {
        LogisticRecordEo logisticRecordEo = (LogisticRecordEo)this.logisticRecordDas.selectByPrimaryKey(id);
        LogisticRecordEo recordEo = new LogisticRecordEo();
        if (null != logisticRecordEo && null != logisticRecordEo.getId()) {
            BeanUtils.copyProperties((Object)logisticRecordEo, (Object)recordEo);
            recordEo.setId(null);
            this.logisticRecordDas.insert((BaseEo)recordEo);
        }
        return recordEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long abolishLogisticRecord(Long id) {
        LogisticRecordEo logisticRecordEo = (LogisticRecordEo)this.logisticRecordDas.selectByPrimaryKey(id);
        if (null != logisticRecordEo && null != logisticRecordEo.getId()) {
            logisticRecordEo.setStatus(LogisticRecordStatusEnum.INVALID.getType());
            this.logisticRecordDas.update((BaseEo)logisticRecordEo);
        }
        return logisticRecordEo.getId();
    }

    @Override
    public RestResponse checkData(LogisticRecordReqDto reqDto) {
        RestResponse response = new RestResponse();
        ChargeModeEnum chargeModeEnum = ChargeModeEnum.getChargeMode((Integer)reqDto.getChargeMode());
        if (null == chargeModeEnum) {
            response.setResultCode(ExampleExceptionCode.DATA_NULL.getCode());
            response.setResultMsg(ExampleExceptionCode.DATA_NULL.getMsg());
            return response;
        }
        if ((ChargeModeEnum.VOLUME.getType().equals(reqDto.getChargeMode()) || ChargeModeEnum.WEIGHT.getType().equals(reqDto.getChargeMode())) && null == reqDto.getParams()) {
            response.setResultCode(ExampleExceptionCode.DATA_NULL.getCode());
            response.setResultMsg(ExampleExceptionCode.DATA_NULL.getMsg());
            return response;
        }
        return response;
    }
}

