/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.query.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.finance.api.dto.request.logistic.LogisticRecordExtReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.LogisticRecordQueryReqDto;
import com.dtyunxi.finance.api.dto.response.logistic.LogisticRecordQueryRespDto;
import com.dtyunxi.finance.api.exception.ChargeModeEnum;
import com.dtyunxi.finance.api.exception.LogisticRecordStatusEnum;
import com.dtyunxi.finance.biz.service.query.ILogisticRecordQueryService;
import com.dtyunxi.finance.dao.das.AppointAreaDas;
import com.dtyunxi.finance.dao.das.LogisticRecordDas;
import com.dtyunxi.finance.dao.eo.LogisticRecordEo;
import com.dtyunxi.finance.dao.po.LogisticRecordPo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class LogisticRecordQueryServiceImpl
implements ILogisticRecordQueryService {
    private static final Logger log = LoggerFactory.getLogger(LogisticRecordQueryServiceImpl.class);
    @Resource
    private LogisticRecordDas logisticRecordDas;
    @Resource
    private AppointAreaDas appointAreaDas;

    @Override
    public PageInfo<LogisticRecordQueryRespDto> queryByPage(LogisticRecordQueryReqDto queryReqDto) {
        PageHelper.startPage((int)queryReqDto.getPageNum(), (int)queryReqDto.getPageSize());
        LogisticRecordEo logisticRecordEo = new LogisticRecordEo();
        BeanUtils.copyProperties((Object)queryReqDto, (Object)logisticRecordEo);
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getChargeMode())) {
            logisticRecordEo.setChargeMode(Integer.valueOf(queryReqDto.getChargeMode()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getValidYear())) {
            logisticRecordEo.setStartValidYear(queryReqDto.getValidYear());
            logisticRecordEo.setEndValidYear(String.format("%s-%s", queryReqDto.getValidYear(), "12-31 23:59:59"));
        }
        PageInfo eoPageInfo = new PageInfo(this.logisticRecordDas.queryByPage(logisticRecordEo));
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList list = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), (Collection)list, LogisticRecordQueryRespDto.class);
        dtoPageInfo.setList((List)list);
        return dtoPageInfo;
    }

    @Override
    public LogisticRecordQueryRespDto queryLogisticRecordById(Long id) {
        LogisticRecordEo logisticRecordEo = (LogisticRecordEo)this.logisticRecordDas.selectByPrimaryKey(id);
        if (null != logisticRecordEo && null != logisticRecordEo.getId()) {
            LogisticRecordQueryRespDto respDto = new LogisticRecordQueryRespDto();
            BeanUtils.copyProperties((Object)logisticRecordEo, (Object)respDto);
            if (null == respDto.getStatus()) {
                Integer status = this.isEffectiveDate(respDto);
                respDto.setStatus(status);
            }
            if (StringUtils.isNotEmpty((CharSequence)respDto.getParams())) {
                JSONArray jsonArray;
                List jsonObjectList;
                ArrayList bizParams = new ArrayList();
                if (ChargeModeEnum.VOLUME.getType().equals(respDto.getChargeMode())) {
                    HashMap objectMap = new HashMap();
                    JSONObject jsonObject = JSONObject.parseObject((String)respDto.getParams());
                    for (Object map : jsonObject.entrySet()) {
                        objectMap.put(((Map.Entry)map).getKey().toString(), ((Map.Entry)map).getValue());
                    }
                    bizParams.add(objectMap);
                } else if (ChargeModeEnum.WEIGHT.getType().equals(respDto.getChargeMode()) && CollectionUtils.isNotEmpty((Collection)(jsonObjectList = (jsonArray = JSONObject.parseArray((String)respDto.getParams())).toJavaList(JSONObject.class)))) {
                    for (JSONObject object : jsonObjectList) {
                        HashMap objectMap = new HashMap();
                        for (Object map : object.entrySet()) {
                            objectMap.put(((Map.Entry)map).getKey().toString(), ((Map.Entry)map).getValue());
                        }
                        bizParams.add(objectMap);
                    }
                }
                respDto.setBizParams(bizParams);
            }
            return respDto;
        }
        return null;
    }

    @Override
    public List<LogisticRecordQueryRespDto> queryByLst(List<LogisticRecordExtReqDto> list) {
        if (CollectionUtil.isEmpty(list)) {
            return Lists.newArrayList();
        }
        ArrayList queryList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)queryList, list, LogisticRecordPo.class);
        List eos = this.logisticRecordDas.queryByList((List)queryList);
        log.info("eos-------:{}", (Object)JSON.toJSONString((Object)eos));
        ArrayList respLists = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respLists, (Collection)eos, LogisticRecordQueryRespDto.class);
        log.info("respLists-------:{}", (Object)JSON.toJSONString((Object)respLists));
        return respLists;
    }

    private Integer isEffectiveDate(LogisticRecordQueryRespDto respDto) {
        if (Objects.equals(respDto.getStatus(), 3)) {
            return LogisticRecordStatusEnum.INVALID.getType();
        }
        Integer count = ((ExtQueryChainWrapper)this.appointAreaDas.filter().eq((Object)"template_id", (Object)respDto.getId())).count();
        if (count == null || count == 0) {
            return LogisticRecordStatusEnum.DRAFT.getType();
        }
        if (null == respDto.getStartTime() || null == respDto.getEndTime()) {
            return LogisticRecordStatusEnum.INVALID.getType();
        }
        if (new Date().before(respDto.getStartTime())) {
            return LogisticRecordStatusEnum.INITIALIZE.getType();
        }
        if (new Date().after(respDto.getEndTime())) {
            return LogisticRecordStatusEnum.FAILURE.getType();
        }
        if (new Date().after(respDto.getStartTime()) && new Date().before(respDto.getEndTime())) {
            LogisticRecordStatusEnum.AMONG.getType();
        }
        return respDto.getStatus();
    }

    public static void main(String[] args) {
        System.out.println(new Date());
        System.out.println(new Date().before(new Date("Sat Oct 09 11:35:10 CST 2022")));
    }

    private Integer isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (null == startTime || null == endTime) {
            return LogisticRecordStatusEnum.INVALID.getType();
        }
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return LogisticRecordStatusEnum.AMONG.getType();
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        if (date.after(begin) && date.before(end)) {
            return LogisticRecordStatusEnum.AMONG.getType();
        }
        if (date.before(begin)) {
            return LogisticRecordStatusEnum.INITIALIZE.getType();
        }
        if (date.after(end)) {
            return LogisticRecordStatusEnum.FAILURE.getType();
        }
        return LogisticRecordStatusEnum.INVALID.getType();
    }
}

