/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.api.constant;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.google.common.collect.Lists;
import java.util.List;

public enum StrategyTypeEnum {
    DELAY_AUDIT("isDelayAudit", "DELAY_AUDIT", "\u5ef6\u65f6\u5ba1\u6838"),
    IGNORE_REMARK_AUDIT("isIgnoreRemarkAudit", "IGNORE_REMARK_AUDIT", "\u5ffd\u7565\u5546\u5bb6\u5907\u6ce8"),
    AMOUNT_RANGE_AUDIT("isAmountRangeAudit", "AMOUNT_RANGE_AUDIT", "\u6307\u5b9a\u91d1\u989d\u533a\u95f4"),
    LOGICAL_WAREHOUSE_AUDIT("isLogicalWarehouseAudit", "LOGICAL_WAREHOUSE_AUDIT", "\u6307\u5b9a\u903b\u8f91\u4ed3\u4eba\u5de5\u5ba1\u6838"),
    GOODS_AUDIT("isGoodsAudit", "GOODS_AUDIT", "\u6307\u5b9aSKU\u4eba\u5de5\u5ba1\u6838"),
    CUSTOMER_AUDIT("isCustomerAudit", "CUSTOMER_AUDIT", "\u6307\u5b9a\u5ba2\u6237\u4eba\u5de5\u5ba1\u6838"),
    AREA_AUDIT("isAreaAudit", "AREA_AUDIT", "\u6307\u5b9a\u533a\u57df\u4eba\u5de5\u5ba1\u6838"),
    BUYER_REMARK_AUDIT("isBuyerRemarkAudit", "BUYER_REMARK_AUDIT", "\u4e70\u5bb6\u5907\u6ce8\u6307\u5b9a\u5173\u952e\u8bcd\u4eba\u5de5\u5ba1\u6838"),
    SELLER_REMARK_AUDIT("isSellerRemarkAudit", "SELLER_REMARK_AUDIT", "\u5356\u5bb6\u5907\u6ce8\u6307\u5b9a\u5173\u952e\u8bcd\u4eba\u5de5\u5ba1\u6838");

    private String tag;
    private String strategyType;
    private String desc;

    private StrategyTypeEnum(String tag, String strategyType, String desc) {
        this.tag = tag;
        this.strategyType = strategyType;
        this.desc = desc;
    }

    public String getTag() {
        return this.tag;
    }

    public String getStrategyType() {
        return this.strategyType;
    }

    public String getDesc() {
        return this.desc;
    }

    public static StrategyTypeEnum enumOf(String type) {
        for (StrategyTypeEnum typeEnum : StrategyTypeEnum.values()) {
            if (!typeEnum.getStrategyType().equals(type)) continue;
            return typeEnum;
        }
        throw new BizException(PcpTradeExceptionCode.TYPE_NOT_EXIT.getCode(), String.format("(%s)%s", type, PcpTradeExceptionCode.TYPE_NOT_EXIT.getMsg()));
    }

    public static List<StrategyTypeEnum> getStrategyTypeList() {
        return Lists.newArrayList((Object[])StrategyTypeEnum.values());
    }
}

