/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.alarm.client.config;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.alarm.client.config.AlarmClientAutoConfiguration;
import com.dtyunxi.yundt.cube.alarm.client.config.AlarmClientProperties;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableFeignClients(basePackages={"com.dtyunxi.yundt.cube.center.scheduler"})
@AutoConfigureAfter(value={AlarmClientAutoConfiguration.class})
public class SchedulerConfig {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerConfig.class);
    @Resource
    private AlarmClientProperties schedulerProperties;
    @Value(value="${scheduler.client.app_code}")
    private String schedulerAppCode;
    @Autowired
    private ITaskApi taskApi;

    @Bean(value={"schedulerInitResult"})
    public String schedulerInit() {
        if (this.schedulerProperties == null || CollectionUtils.isEmpty(this.schedulerProperties.getJobs())) {
            logger.info("\u5f53\u524d\u5e94\u7528\u6682\u672a\u53d1\u73b0\u5b9a\u65f6\u4efb\u52a1");
            return "success";
        }
        for (TaskAndBizCreateReqDto reqDto : this.schedulerProperties.getJobs()) {
            reqDto.setAppCode(this.schedulerAppCode);
            reqDto.setParams("");
            reqDto.setShardType("SINGLE");
            reqDto.setTaskBatchId(null);
            reqDto.setTaskDesc("");
            reqDto.setTaskName(reqDto.getBizName());
            reqDto.setInstanceId(Long.valueOf(-1L));
            reqDto.setTenantId(Long.valueOf(-1L));
            try {
                RestResponse addResult = this.taskApi.addWithBiz(reqDto);
                if (addResult.getData() != null) {
                    this.taskApi.enableById((Long)addResult.getData(), "{}");
                }
            }
            catch (Exception e) {
                logger.error("===========:{}", (Object)e.getMessage());
            }
            logger.info("\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1{}\u6210\u529f", (Object)reqDto.getBizName());
        }
        return "success";
    }
}

