/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.alarm.client;

import com.dtyunxi.cube.utils.rules.RuleExecException;
import com.dtyunxi.yundt.cube.alarm.api.IAlarmRuleExecutor;
import com.dtyunxi.yundt.cube.alarm.api.IAlarmRuleManager;
import com.dtyunxi.yundt.cube.alarm.api.IMonitorDataFetcher;
import com.dtyunxi.yundt.cube.alarm.api.dto.req.MonitorDataFetchReqDto;
import com.dtyunxi.yundt.cube.alarm.client.sender.AlarmSender;
import com.dtyunxi.yundt.cube.alarm.domain.Alarm;
import com.dtyunxi.yundt.cube.alarm.domain.AlarmRule;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AlarmClient {
    private static final int DATA_ALREADY_MINUTE = 1;
    private static Logger log = LoggerFactory.getLogger(AlarmClient.class);
    private AlarmSender alarmSender;
    private IMonitorDataFetcher monitorDataFetcher;
    private IAlarmRuleManager ruleManager;
    private IAlarmRuleExecutor ruleExecutor;
    private String applicationName;

    public AlarmClient(String applicationName, IAlarmRuleManager ruleManager, AlarmSender alarmSender, IMonitorDataFetcher monitorDataFetcher, IAlarmRuleExecutor ruleExecutor) {
        this.applicationName = applicationName;
        this.ruleManager = ruleManager;
        this.alarmSender = alarmSender;
        this.monitorDataFetcher = monitorDataFetcher;
        this.ruleExecutor = ruleExecutor;
    }

    public void run() throws RuleExecException {
        AlarmRule rule = this.ruleManager.getRule(this.applicationName);
        if (Objects.isNull(rule)) {
            log.info("applicationName: " + this.applicationName + " rule not found skip process");
            return;
        }
        MonitorDataFetchReqDto dataFetchReqDto = new MonitorDataFetchReqDto();
        dataFetchReqDto.setAlarmRule(rule);
        List monitorDataList = this.monitorDataFetcher.fetch(dataFetchReqDto);
        if (CollectionUtils.isEmpty((Collection)monitorDataList)) {
            log.info("applicationName: " + this.applicationName + " MonitorData not found skip process");
            return;
        }
        List alarmList = this.ruleExecutor.exec(rule, monitorDataList);
        for (Alarm alarm : alarmList) {
            this.alarmSender.send(alarm);
        }
    }

    private static int calAlreadyMinute() {
        long current = System.currentTimeMillis() / 1000L / 60L;
        return (int)(current % 60L) - 1;
    }

    public void setAlarmSender(AlarmSender alarmSender) {
        this.alarmSender = alarmSender;
    }

    public void setRuleExecutor(IAlarmRuleExecutor ruleExecutor) {
        this.ruleExecutor = ruleExecutor;
    }

    public void setRuleManager(IAlarmRuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    public void setMonitorDataFetcher(IMonitorDataFetcher monitorDataFetcher) {
        this.monitorDataFetcher = monitorDataFetcher;
    }
}

