/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.alarm.client.rule;

import com.dtyunxi.cube.utils.rules.DefaultRuleExecutor;
import com.dtyunxi.cube.utils.rules.RuleDetail;
import com.dtyunxi.cube.utils.rules.RuleExecException;
import com.dtyunxi.cube.utils.rules.RuleResultSet;
import com.dtyunxi.yundt.cube.alarm.api.IAlarmRuleExecutor;
import com.dtyunxi.yundt.cube.alarm.api.domain.BaseMonitorData;
import com.dtyunxi.yundt.cube.alarm.domain.Alarm;
import com.dtyunxi.yundt.cube.alarm.domain.AlarmRule;
import com.dtyunxi.yundt.cube.alarm.domain.AlarmRuleDetail;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;

public abstract class AbstractAlarmRuleExecutor
implements IAlarmRuleExecutor {
    protected static DefaultRuleExecutor ruleExec = new DefaultRuleExecutor();

    public List<Alarm> exec(AlarmRule rule, List<BaseMonitorData> monitorDatas) throws RuleExecException {
        ArrayList<Alarm> result = new ArrayList<Alarm>();
        List ruleDetails = rule.getRuleDetails();
        block0: for (BaseMonitorData data : monitorDatas) {
            for (AlarmRuleDetail ruleDetail : ruleDetails) {
                RuleResultSet resultSet = ruleExec.exec((RuleDetail)ruleDetail, data.data());
                Map ruleResult = resultSet.getRuleResult();
                Object matchResult = ruleResult.get(ruleDetail.getName());
                if (!Objects.nonNull(matchResult) || !BooleanUtils.toBoolean((String)matchResult.toString())) continue;
                Alarm alarm = new Alarm();
                alarm.setRefId(data.getId());
                alarm.setEnableSms(Integer.valueOf(BooleanUtils.toInteger((boolean)ruleDetail.isEnableSms())));
                alarm.setApplicationName(rule.getApplicationName());
                alarm.setRuleName(rule.getRuleName());
                alarm.setSubRuleName(ruleDetail.getName());
                alarm.setType(rule.getType());
                alarm.setUsers(rule.getUsers());
                alarm.setDate(new Date());
                this.buildAlarm(alarm, resultSet);
                result.add(alarm);
                continue block0;
            }
        }
        return result;
    }
}

