/**
 * @(#) VerifyCodeApi.java 1.0 2018-08-30
 * 
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.CheckVerifyCodeAndModifyPasswordDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.MessageReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.SlideVerifyCodeRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * 验证码发送和校验验证码正确API
 * 
 * @author 项羽
 * @since 2.0.0
 */
@Api(tags = { "认证中心：验证码发送和校验服务" })
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-identity-api-IVerifyCodeApi", name = "${yundt.cube.center.identity.api.name:yundt-cube-center-identity}", path = "/v2", url = "${yundt.cube.center.identity.api:}")
public interface IVerifyCodeApi {

	/**
	 * 发送手机或者邮箱验证码
	 *
	 * @param message
	 *            验证码发送请求Dto
	 * @return 返回验证码的唯一标识uniqueId
	 */
	@PostMapping(value = "/code", produces = "application/json")
	@ApiOperation(value = "发送手机或者邮箱验证码", notes = "认证中心生成验证码，然后通过消息中心发送给用户手机或者邮箱，并且返回给调用方验证码的标识uniqueId")
	@ApiImplicitParams({
			@ApiImplicitParam(paramType = "body", name = "message", dataType = "MessageReqDto", required = true, value = "获取验证码实体", defaultValue = ""), })
	RestResponse<String> sendVerifyCode(MessageReqDto message);

	/**
	 * 获取图形验证码
	 *
	 * @return 返回认证中心生成的图形验证码
	 */
	@PostMapping(value = "/captcha", produces = "application/json")
	@ApiOperation(value = "获取图形验证码", notes = "认证中心生成图形验证码，返回uniqueId和图形验证码base64字符串，认证中心不会发送给用户")
	RestResponse<Map<String, String>> sendVerifyCodeByImg();

	/**
	 *  获取滑块验证码
	 *
	 * @return 返回认证中心生成的滑块验证码
	 */
	@PostMapping(value = "/captcha/slide", produces = "application/json")
	@ApiOperation(value = "获取滑块验证码", notes = "认证中心生成滑块验证码")
	RestResponse<SlideVerifyCodeRespDto> sendSlideVerifyCode();

	/**
	 * 检验验证码信息是否正确
	 * 
	 * @param uniqueId 验证码唯一id标识
	 * @param verifycode
	 *            填写的验证码
	 * @param type 验证码类型
	 * 
	 * @return Boolean 验证验证码信息结果
	 */
	@GetMapping(value = "/verifycode/isvalid", produces = "application/json")
	@ApiOperation(value = "校验验证码是否有效,验证码类型：1图像验证码，2手机验证码，3邮箱验证码", notes = "校验验证码是否有效,验证码类型：1图像验证码，2手机验证码，3邮箱验证码")
	@ApiImplicitParams({
			@ApiImplicitParam(paramType = "query", name = "verifycode", dataType = "String", required = true, value = "验证码"),
			@ApiImplicitParam(paramType = "query", name = "uniqueId", dataType = "String", required = true, value = "验证码后台生成时返回的唯一标识"),
			@ApiImplicitParam(paramType = "query", name = "type", dataType = "Int", required = true, value = "验证码类型：1图像验证码，2手机验证码，3邮箱验证码") })
	RestResponse<Boolean> checkVerifyCode(@RequestParam("verifycode") String verifycode,
			@RequestParam("uniqueId") String uniqueId, @RequestParam("type") Integer type);

	/**
	 * 校验滑块验证码是否有效
	 *
	 * @param slideUniqueId 滑块验证码唯一id
	 * @param slideX 滑块验证码X轴
	 * @return 操作结果
	 */
	@GetMapping(value = "/verifycode/slide/isvalid", produces = "application/json")
	@ApiOperation(value = "校验滑块验证码是否有效", notes = "校验滑块验证码是否有效")
	RestResponse<Boolean> checkSlideVerifyCode(@RequestParam("slideUniqueId") String slideUniqueId, @RequestParam("slideX") Integer slideX);

	/**
	 * 校验验证码是否有效，验证码类型：2手机验证码，3邮箱验证码，校验通过后重置密码
	 *
	 * @param reqDto
	 * @return
	 */
	@PutMapping(value = "/code/validate/reset-password")
	@ApiOperation(value = "校验验证码是否有效，验证码类型：2手机验证码，3邮箱验证码，校验通过后重置密码")
	RestResponse<Void> checkVerifyCodeAndModifyPassword(@RequestBody CheckVerifyCodeAndModifyPasswordDto reqDto);
}
