/*
 * @(#)BindLoginWithoutAccessTokenDto.java 1.0 2019-03-26
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * 轻量级绑定第三方用户并登录请求DTO
 *
 * @author 飞扬
 * @since 2.0.0
 */
@ApiModel(value = "BindLoginWithoutAccessTokenDto", description = "登陆绑定第三方")
public class BindLoginWithoutAccessTokenDto extends RequestDto {

    private static final long serialVersionUID = 7257919550602555728L;

    /**
     * 第三方类型
     */
    @ApiModelProperty(value = "第三方类型（1：微信，2：QQ，3：Sina微博, 必填）", required = true)
    @Min(1)
    @Max(10)
    @NotNull
    private Integer thirdType;

    /**
     * 第三方平台的用户openId
     */
    @ApiModelProperty(value = "第三方平台的用户openId, 必填")
    private String openId;

    /**
     * 第三方平台的用户unionId
     */
    @ApiModelProperty(value = "第三方平台的用户unionId, 必填")
    private String unionId;

    /**
     * 用户昵称
     */
    @ApiModelProperty(value = "用户昵称, 选填")
    private String nickName;

    /**
     * 用户头像url地址
     */
    @ApiModelProperty(value = "用户头像url地址, 选填")
    private String avatar;

    /**
     * 绑定的用户手机
     */
    @ApiModelProperty(value = "绑定的用户手机, 必填")
    private String phone;

    /**
     * 短信验证码
     */
    @ApiModelProperty(value = "短信验证码, 必填")
    private String checkCode;

    /**
     * 短信验证码唯一id，通过 获取验证码接口 得到
     */
    @ApiModelProperty(value = "短信验证码唯一id，通过 获取验证码接口得到, 必填")
    private String checkCodeUniqueId;

    /**
     * 登录token的生效时间, 单位:秒, 默认跟登录接口的时效一致
     */
    @ApiModelProperty(value = "登录Token的有效时间（秒）")
    private Integer validTime;
    /**
     * 默认false, 如果传true, 当openId和unionId都没关联用户时就返回"4003 用户不存在"
     */
    @ApiModelProperty(value = "是否阻塞未绑定的请求,默认false, 如果传true, 当openId和unionId都没关联用户时就返回4003 用户不存在")
    private boolean blockWhenNoBind;
    /**
     * 默认false,如果传true,当未绑定用户,或者绑定的用户没有关联手机时就返回"4013 用户未关联手机"
     */
    @ApiModelProperty(value = "默认false,如果传true,当未绑定用户,或者绑定的用户没有关联手机时就返回4013 用户未关联手机")
    private boolean blockWhenNoPhone;
    /**
     * 如果传true的时候, 当请求传了手机号, 并且openId没绑定, 就创建账号并绑定, 手机号, 类似忽略了 blockWhenNoBind=true的效果
     */
    @ApiModelProperty(value = "请求有手机时是否必然登录:如果传true的时候, 当请求传了手机号, 并且openId没绑定, 就创建账号并绑定, 手机号, 等于把blockWhenNoBind=true忽略了")
    private boolean createWhenPhoneInReq;

    @ApiModelProperty(value = "账号域")
    private String domain;

    public Integer getThirdType() {
        return thirdType;
    }

    public void setThirdType(Integer thirdType) {
        this.thirdType = thirdType;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public String getCheckCodeUniqueId() {
        return checkCodeUniqueId;
    }

    public void setCheckCodeUniqueId(String checkCodeUniqueId) {
        this.checkCodeUniqueId = checkCodeUniqueId;
    }

    public Integer getValidTime() {
        return validTime;
    }

    public void setValidTime(Integer validTime) {
        this.validTime = validTime;
    }

    public boolean isBlockWhenNoBind() {
        return blockWhenNoBind;
    }

    public BindLoginWithoutAccessTokenDto setBlockWhenNoBind(boolean blockWhenNoBind) {
        this.blockWhenNoBind = blockWhenNoBind;
        return this;
    }

    public boolean isBlockWhenNoPhone() {
        return blockWhenNoPhone;
    }

    public BindLoginWithoutAccessTokenDto setBlockWhenNoPhone(boolean blockWhenNoPhone) {
        this.blockWhenNoPhone = blockWhenNoPhone;
        return this;
    }

    public boolean isCreateWhenPhoneInReq() {
        return createWhenPhoneInReq;
    }

    public BindLoginWithoutAccessTokenDto setCreateWhenPhoneInReq(boolean createWhenPhoneInReq) {
        this.createWhenPhoneInReq = createWhenPhoneInReq;
        return this;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }
}