/**
 * @(#) DictionaryReqDto.java 1.0 2019-06-24
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 常量配置请求Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "DictionaryReqDto", description = "常量配置请求Dto")
public class DictionaryReqDto extends RequestDto {

    @ApiModelProperty(value = "id，新增不需要填")
    private Long id;

    @ApiModelProperty(value = "常量分组, 选填")
    private String dictGroup;

    @ApiModelProperty(value = "常量key, 必填", required = true)
    private String dictKey;

    @ApiModelProperty(value = "常量value, 必填", required = true)
    private String dictValue;

    @ApiModelProperty(value = "描述, 选填")
    private String description;

    @ApiModelProperty(value = "状态：1启用2禁用, 默认为1")
    private Integer status;

    @ApiModelProperty(value = "扩展字段, 选填")
    private String extension;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDictGroup() {
        return dictGroup;
    }

    public void setDictGroup(String dictGroup) {
        this.dictGroup = dictGroup;
    }

    public String getDictKey() {
        return dictKey;
    }

    public void setDictKey(String dictKey) {
        this.dictKey = dictKey;
    }

    public String getDictValue() {
        return dictValue;
    }

    public void setDictValue(String dictValue) {
        this.dictValue = dictValue;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}
