/**
 * @(#) LoginRespDto.java 1.0 2019-11-08
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.identity.api.dto.response;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 登录响应dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "LoginRespDto", description = "登录响应dto")
public class LoginRespDto extends RequestDto {
    @ApiModelProperty(value = "用户ID")
    private Long userId;

    @ApiModelProperty(value = "登录凭证token")
    private String token;

    @ApiModelProperty(value = "角色编码，")
    private String roleCode;

    @ApiModelProperty(value = "true:需要修改密码；false:不需要")
    private Boolean needModifyPassword;

    /**
     * token 有效时间
     */
    @ApiModelProperty(value = "当前token 有效时间（秒）")
    private Integer tokenValidTime;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public Boolean getNeedModifyPassword() {
        return needModifyPassword;
    }

    public void setNeedModifyPassword(Boolean needModifyPassword) {
        this.needModifyPassword = needModifyPassword;
    }

    public Integer getTokenValidTime() {
        return tokenValidTime;
    }

    public void setTokenValidTime(Integer tokenValidTime) {
        this.tokenValidTime = tokenValidTime;
    }
}
