/**
 * @(#) SlideVerifyCodeRespDto.java 1.0 2019-12-03
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.dto.response;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 滑块验证码返回Dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "SlideVerifyCodeRespDto", description = "滑块验证码返回Dto")
public class SlideVerifyCodeRespDto implements Serializable {

    /**
     * 滑动验证码，源图
     */
    private String originImage;

    /**
     * 滑动验证码，遮罩图
     */
    @ApiModelProperty(value = "遮罩图")
    private String shadeImage;

    /**
     * 滑动验证码，裁剪图
     */
    @ApiModelProperty(value = "裁剪图")
    private String cutoutImage;

    /**
     * 滑动验证码，X轴
     */
    private int X;

    /**
     * 滑动验证码，Y轴
     */
    @ApiModelProperty(value = "Y轴坐标")
    private int Y;

    /**
     * 滑块验证码唯一id
     */
    @ApiModelProperty(value = "滑块验证码唯一id")
    private String slideUniqueId;

    public String getOriginImage() {
        return originImage;
    }

    public void setOriginImage(String originImage) {
        this.originImage = originImage;
    }

    public String getShadeImage() {
        return shadeImage;
    }

    public void setShadeImage(String shadeImage) {
        this.shadeImage = shadeImage;
    }

    public String getCutoutImage() {
        return cutoutImage;
    }

    public void setCutoutImage(String cutoutImage) {
        this.cutoutImage = cutoutImage;
    }

    public int getX() {
        return X;
    }

    public void setX(int x) {
        X = x;
    }

    public int getY() {
        return Y;
    }

    public void setY(int y) {
        Y = y;
    }

    public String getSlideUniqueId() {
        return slideUniqueId;
    }

    public void setSlideUniqueId(String slideUniqueId) {
        this.slideUniqueId = slideUniqueId;
    }
}