/**
 * @(#) IAppSecretQueryApi.java 1.0 2019-01-21
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.identity.api.v3.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.AppSecretRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author 刘备
 * @since 1.0.0
 */
@Api(tags = {"认证中心：第三方渠道配置"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-identity-api-v3-query-IAppSecretQueryApi", name = "${yundt.cube.center.identity.api.name:yundt-cube-center-identity}", path = "/v3/app-secret", url = "${yundt.cube.center.identity.api:}")
public interface IAppSecretQueryApi {

    /**
     * 查询第三方渠道配置
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(value = "查询第三方渠道配置", notes = "查询第三方渠道配置")
    RestResponse<AppSecretRespDto> findById(@PathVariable("id") Long id);

    @RequestMapping(value = "/nopage", method = RequestMethod.GET)
    @ApiOperation(value = "查询第三方渠道配置列表", notes = "filter格式参考:\n" +
            "{\n" +
            "\"instanceId\":1,\n" +
            "\"tenantId\":1,\n" +
            "\"applicationId\":1\n" +
            "}\n" +
            "单次查询限额1000条\n")
    @ApiImplicitParam(name = "filter", value = "查询条件json字符串,例如 {\"tenantId\":1,\"instanceId\":1}", dataType = "string", paramType = "query", required = true)
    RestResponse<List<AppSecretRespDto>> findList(@RequestParam("filter") String filter);
}

