/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.apiimpl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.IVerifyCodeApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.CheckVerifyCodeAndModifyPasswordDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.MessageReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.SlideVerifyCodeRespDto;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="verifycodeApi")
public class VerifyCodeApiImpl
implements IVerifyCodeApi {
    @Resource
    IVerifyCodeService verifyCodeService;
    @Resource
    private IUserService userService;

    public RestResponse<String> sendVerifyCode(MessageReqDto message) {
        Long instanceId;
        Long tenantId = message.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : message.getTenantId();
        Long l = instanceId = message.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : message.getInstanceId();
        if (message.isCheckAccount()) {
            this.userService.checkAccount(message.getTarget(), message.getDomain(), instanceId);
        }
        return new RestResponse((Object)this.verifyCodeService.sendVerifyCode(tenantId, instanceId, message.getType(), message.getTarget()));
    }

    public RestResponse<Map<String, String>> sendVerifyCodeByImg() {
        return new RestResponse(this.verifyCodeService.sendVerifyCodeByImg());
    }

    public RestResponse<SlideVerifyCodeRespDto> sendSlideVerifyCode() {
        return new RestResponse((Object)this.verifyCodeService.sendSlideVerifyCode());
    }

    public RestResponse<Boolean> checkVerifyCode(@RequestParam String verifycode, @RequestParam String uniqueId, Integer type) {
        return new RestResponse((Object)this.verifyCodeService.checkVerifyCode(verifycode, uniqueId, type));
    }

    public RestResponse<Boolean> checkSlideVerifyCode(String slideUniqueId, Integer slideX) {
        return new RestResponse((Object)this.verifyCodeService.checkSlideCode(slideX, slideUniqueId, false));
    }

    public RestResponse<Void> checkVerifyCodeAndModifyPassword(CheckVerifyCodeAndModifyPasswordDto reqDto) {
        this.verifyCodeService.checkVerifyCodeAndModifyPassword(reqDto);
        return RestResponse.VOID;
    }
}

