/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.identity.api.constants.LoginSource;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AppSecretReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.api.vo.AppSecretFilter;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IAppSecretService;
import com.dtyunxi.yundt.cube.center.identity.dao.das.AppSecretDas;
import com.dtyunxi.yundt.cube.center.identity.dao.eo.AppSecretEo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppSecretServiceImpl
implements IAppSecretService {
    @Value(value="${app.key.weixin.web:}")
    private String weixinWebKey;
    @Value(value="${app.secret.weixin.web:}")
    private String weixinWebSecret;
    @Value(value="${app.key.weixin.web.browse:}")
    private String weixinWebBrowseKey;
    @Value(value="${app.secret.weixin.web.browse:}")
    private String weixinWebBrowseSecret;
    @Value(value="${app.key.qq.web:}")
    private String qqWebKey;
    @Value(value="${app.secret.qq.web:}")
    private String qqWebSecret;
    @Value(value="${app.key.sina.web:}")
    private String weiboWebKey;
    @Value(value="${app.secret.sina.web:}")
    private String weiboWebSecret;
    @Value(value="${app.key.dingtalk.web:}")
    private String dingTalkWebKey;
    @Value(value="${app.key.facebook.web:}")
    private String faceBookWebKey;
    @Value(value="${app.secret.facebook.web:}")
    private String faceBookWebSecret;
    @Autowired
    private AppSecretDas appSecretDas;

    @Override
    public AppSecretEo getByThirdType(Integer thirdType, Integer source) {
        AppSecretEo appSecretEo = new AppSecretEo();
        if (thirdType.equals(1)) {
            if (source.equals(LoginSource.WEB)) {
                appSecretEo.setKeyAppId(this.weixinWebKey);
                appSecretEo.setKeyAppSecret(this.weixinWebSecret);
                return appSecretEo;
            }
            if (source.equals(LoginSource.APP)) {
                appSecretEo.setKeyAppId(this.weixinWebBrowseKey);
                appSecretEo.setKeyAppSecret(this.weixinWebBrowseSecret);
                return appSecretEo;
            }
        } else {
            if (thirdType.equals(2)) {
                appSecretEo.setKeyAppId(this.qqWebKey);
                appSecretEo.setKeyAppSecret(this.qqWebSecret);
                return appSecretEo;
            }
            if (thirdType.equals(3)) {
                appSecretEo.setKeyAppId(this.weiboWebKey);
                appSecretEo.setKeyAppSecret(this.weiboWebSecret);
                return appSecretEo;
            }
            if (thirdType.equals(4)) {
                appSecretEo.setKeyAppId(this.dingTalkWebKey);
                return appSecretEo;
            }
            if (thirdType.equals(5)) {
                appSecretEo.setKeyAppId(this.faceBookWebKey);
                appSecretEo.setKeyAppSecret(this.faceBookWebSecret);
                return appSecretEo;
            }
        }
        return null;
    }

    @Override
    public AppSecretEo getAppSecretByFilter(AppSecretFilter filter) {
        if (filter.getConfigLevel() == null || filter.getConfigLevel() == 0) {
            return this.getByThirdType(filter.getThirdType(), filter.getLoginSource());
        }
        if (filter.getConfigLevel() == 1) {
            filter.setInstanceId(Long.valueOf(-1L));
        }
        AppSecretEo appSecretEo = this.appSecretDas.getSpecifiedAppSecret(filter.getTenantId(), filter.getInstanceId(), filter.getThirdType(), filter.getLoginSource());
        return appSecretEo;
    }

    @Override
    public AppSecretEo findById(Long id) {
        return (AppSecretEo)this.appSecretDas.selectByPrimaryKey(id);
    }

    @Override
    @Transactional
    public Long save(AppSecretReqDto appSecretReqDto) {
        appSecretReqDto.setInstanceId(Long.valueOf(appSecretReqDto.getInstanceId() == null ? -1L : appSecretReqDto.getInstanceId()));
        AppSecretEo appSecretEo = this.appSecretDas.getSpecifiedAppSecret(appSecretReqDto.getTenantId(), appSecretReqDto.getInstanceId(), appSecretReqDto.getThirdparyType(), appSecretReqDto.getLoginSource());
        if (appSecretEo != null) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.APP_SECRET_EXISTS);
        }
        appSecretEo = new AppSecretEo();
        DtoHelper.dto2Eo((BaseVo)appSecretReqDto, (BaseEo)appSecretEo);
        this.appSecretDas.insert((BaseEo)appSecretEo);
        return appSecretEo.getId();
    }

    @Override
    @Transactional
    public void deleteById(Long id) {
        this.appSecretDas.deleteById(id);
    }

    @Override
    @Transactional
    public void modify(Long id, AppSecretReqDto appSecretReqDto) {
        appSecretReqDto.setInstanceId(Long.valueOf(appSecretReqDto.getInstanceId() == null ? -1L : appSecretReqDto.getInstanceId()));
        AppSecretEo appSecretEo = this.appSecretDas.getSpecifiedAppSecret(appSecretReqDto.getTenantId(), appSecretReqDto.getInstanceId(), appSecretReqDto.getThirdparyType(), appSecretReqDto.getLoginSource());
        if (appSecretEo != null && !id.equals(appSecretEo.getId())) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.APP_SECRET_EXISTS);
        }
        appSecretEo = new AppSecretEo();
        DtoHelper.dto2Eo((BaseVo)appSecretReqDto, (BaseEo)appSecretEo);
        appSecretEo.setId(id);
        this.appSecretDas.updateSelective((BaseEo)appSecretEo);
    }

    @Override
    public List<AppSecretEo> findList(String filter) {
        AppSecretEo appSecret = (AppSecretEo)ObjectHelper.Json2Bean((String)filter, AppSecretEo.class);
        return this.appSecretDas.select((BaseEo)appSecret);
    }
}

